/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSetSuperclassIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private final OCSymbol mySuperClass;
    private final OCVisibility myVisibility;
    @IntentionName
    private final String myText;

    public OCSetSuperclassIntentionAction(@NotNull OCSymbol classSymbol, OCSymbol superClass, @Nullable OCVisibility visibility, @NotNull OCCompilationContext context) {
        if (classSymbol == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(1);
        }
        super(context.getProject(), classSymbol);
        this.mySuperClass = superClass;
        this.myVisibility = visibility;
        this.myText = this.getTextImpl(context);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @IntentionName
    private String getTextImpl(@NotNull OCCompilationContext context) {
        String superTypeName;
        if (context == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.mySymbol instanceof OCInterfaceSymbol && !(superTypeName = ((OCInterfaceSymbol)this.mySymbol).getSuperClassName()).isEmpty() && this.mySuperClass != null) {
            return OCInspectionsBundle.message((String)"intention.name.change.superclass", (Object[])new Object[]{this.mySymbol.getNameWithKindLowercase(context), superTypeName, this.mySuperClass.getPresentableName()});
        }
        assert (this.mySuperClass != null);
        String subject = OCInspectionsBundle.message((String)"intention.name.choice.superclass", (Object[])new Object[]{this.myVisibility != null ? this.myVisibility.toString() : "", this.myVisibility != null ? 0 : 1, this.mySymbol.getNameWithKindLowercase(context)});
        return OCInspectionsBundle.message((String)"intention.name.set.superclass", (Object[])new Object[]{this.mySuperClass.getPresentableName(), subject});
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.change.superclass", (Object[])new Object[0]);
        if (string == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return !(!super.isAvailable() || this.mySymbol.isPredeclaration() || !(this.mySymbol instanceof OCInterfaceSymbol) && !(this.mySymbol instanceof OCStructSymbol) || !(this.mySuperClass instanceof OCInterfaceSymbol) && !(this.mySuperClass instanceof OCStructSymbol));
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(4);
        }
        OCSymbolDeclarator declaration = (OCSymbolDeclarator)this.mySymbol.locateDefinition(project);
        if (this.mySuperClass instanceof OCInterfaceSymbol) {
            if (declaration != null) {
                new OCElementsMover().setSuperClass((OCClassDeclaration)declaration, this.mySuperClass.getName());
            }
        } else {
            new OCElementsMover().removeBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, false);
            new OCElementsMover().addBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, this.myVisibility, false);
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement declaration;
        if (project == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(7);
        }
        if (!((declaration = this.mySymbol.locateDefinition(project)) instanceof OCStruct)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                OCSetSuperclassIntentionAction.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        OCStruct struct = (OCStruct)declaration;
        OCSymbolKind symbolKind = struct.getKind();
        String keyword = symbolKind.getStructKeyword();
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), keyword + " " + struct.getName(), keyword + " " + struct.getName() + " : " + this.myVisibility + " " + this.mySuperClass.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSetSuperclassIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSetSuperclassIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextImpl";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

