/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0004\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/quickfixes/OCAddFunctionSpecifierBase;", "", "myShouldInsert", "", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(ZLcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "mySpecifier", "Lcom/jetbrains/cidr/lang/parser/OCElementType;", "getMySpecifier", "()Lcom/jetbrains/cidr/lang/parser/OCElementType;", "getSpecifierElement", "Lcom/intellij/psi/PsiElement;", "element", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "getInsertAfterAnchor", "getElementToInsert", "context", "project", "invoke", "", "declarator", "Lcom/jetbrains/cidr/lang/psi/OCDeclarator;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddConstQualifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddConstexprSpecifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddExplicitSpecifier;", "Lcom/jetbrains/cidr/lang/quickfixes/OCAddNoexceptSpecifier;", "intellij.c"})
abstract class OCAddFunctionSpecifierBase {
    private final boolean myShouldInsert;
    @NotNull
    private final Project myProject;

    private OCAddFunctionSpecifierBase(boolean myShouldInsert, Project myProject) {
        this.myShouldInsert = myShouldInsert;
        this.myProject = myProject;
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected abstract OCElementType getMySpecifier();

    @Nullable
    public abstract PsiElement getSpecifierElement(@NotNull OCFunctionDeclaration var1);

    @Nullable
    public abstract PsiElement getInsertAfterAnchor(@NotNull OCFunctionDeclaration var1);

    @NotNull
    public PsiElement getElementToInsert(@NotNull PsiElement context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = OCElementFactory.createLeaf(PsiManager.getInstance((Project)project), this.getMySpecifier());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createLeaf(...)");
        return psiElement;
    }

    public final void invoke(@NotNull OCFunctionDeclaration element, @NotNull OCDeclarator declarator, @NotNull Project project) {
        boolean shouldDelete;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)declarator, (String)"declarator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement specifierElement = this.getSpecifierElement(element);
        boolean bl = shouldDelete = specifierElement != null && !this.myShouldInsert;
        if (specifierElement == null && this.myShouldInsert) {
            PsiElement nodeToInsert = this.getElementToInsert(element, project);
            PsiElement insertPt = this.getInsertAfterAnchor(element);
            if (insertPt == null) {
                PsiElement insertedElem = OCChangeUtil.addBefore(element, nodeToInsert, element.getTypeElement());
                v1 = OCChangeUtil.addAfter(element, OCElementFactory.spaceFromText(element), insertedElem);
            } else {
                OCChangeUtil.addAfter(declarator, nodeToInsert, insertPt);
                v1 = OCChangeUtil.addAfter(declarator, OCElementFactory.spaceFromText(element), insertPt);
            }
        } else if (shouldDelete) {
            OCChangeUtil.delete(specifierElement);
        }
    }

    public /* synthetic */ OCAddFunctionSpecifierBase(boolean myShouldInsert, Project myProject, DefaultConstructorMarker $constructor_marker) {
        this(myShouldInsert, myProject);
    }
}

