/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSelectorPartImpl
extends OCElementBase
implements OCMethodSelectorPart {
    public OCMethodSelectorPartImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCMethodSelectorPartImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public String getSelectorPart() {
        StringBuilder builder = new StringBuilder();
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            builder.append(child.getText());
            child = child.getTreeNext();
        }
        while (child != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(child.getElementType())) {
            child = child.getTreeNext();
        }
        if (child != null && child.getElementType() == OCTokenTypes.COLON) {
            builder.append(child.getText());
        }
        return builder.toString();
    }

    @Override
    public String getParameterName() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getText() : null;
    }

    public String getName() {
        return this.getParameterName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode parameterNode;
        if (name == null) {
            OCMethodSelectorPartImpl.$$$reportNull$$$0(1);
        }
        if ((parameterNode = this.findParameterNode()) != null) {
            OCChangeUtil.replaceChild(this.getNode(), parameterNode, OCElementFactory.createIdentifier(name, this).getNode());
        }
        return this;
    }

    @Override
    @Nullable
    public PsiElement getSelectorIdentifier() {
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            return child.getPsi();
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode paramNode = this.findParameterNode();
        return paramNode != null ? paramNode.getPsi() : null;
    }

    @Override
    public PsiElement getParameter() {
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first != (last = this.findLastChildByType((IElementType)OCTokenTypes.IDENTIFIER)) && last != null) {
            return last;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findParameterNode() {
        PsiElement parameter = this.getParameter();
        return parameter != null ? parameter.getNode() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getStartOffset() : super.getTextOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement id = this.getParameter();
        return id != null ? OCSymbolOffsetUtil.getComplexOffset(id) : super.getComplexOffset();
    }

    @Override
    @NotNull
    public OCType getType() {
        OCTypeElement typeElement = this.getTypeElement();
        OCType oCType = typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCMethodSelectorPartImpl.$$$reportNull$$$0(2);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getRawType() {
        OCTypeElement typeElement = this.getTypeElement();
        OCType oCType = typeElement != null ? typeElement.getRawType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCMethodSelectorPartImpl.$$$reportNull$$$0(3);
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCDeclaratorSymbol getLocalSymbol() {
        OCBuilderDriver<ASTNode> builderDriver;
        OCMethodSymbol.SelectorPartSymbol selector;
        OCFile file = this.getContainingOCFile();
        OCMethod method = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMethod.class});
        ComplexTextRange scope = null;
        if (method != null) {
            OCBlockStatement body = method.getBody();
            scope = OCSymbolOffsetUtil.getComplexRange(body != null ? body : method);
        }
        if ((selector = (builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), file)).processSelectorPart(this.getNode(), new StringBuilder(), scope, (Ref<Long>)new Ref(), null, false)) != null) {
            OCDeclaratorSymbol parameter = selector.getParameter();
            if (parameter instanceof OCDeclaratorSymbolImpl && method != null) {
                ((OCDeclaratorSymbolImpl)parameter).setParentMethod((OCMethodSymbol)method.getSymbol());
            }
            return parameter;
        }
        return null;
    }

    @Override
    public OCDeclaratorSymbol getSymbol() {
        return this.getLocalSymbol();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCMethodSelectorPartImpl.$$$reportNull$$$0(4);
        }
        visitor.visitMethodSelectorPart(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

