/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionImpl
extends OCExpressionBase
implements OCCastExpression {
    public OCCastExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findChildByType((IElementType)OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public OCCompoundInitializer getCompoundInitializer() {
        return (OCCompoundInitializer)this.findChildByType((IElementType)OCElementTypes.COMPOUND_INITIALIZER);
    }

    @Override
    @NotNull
    public OCType getCastType() {
        OCTypeElement typeElement = this.getTypeElement();
        OCType oCType = typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCCastKind getCastKind() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = OCElementUtil.getElementType(child);
            if (elementType == OCTokenTypes.STATIC_CAST_CPP_KEYWORD) {
                OCCastKind oCCastKind = OCCastKind.STATIC_CAST;
                if (oCCastKind == null) {
                    OCCastExpressionImpl.$$$reportNull$$$0(2);
                }
                return oCCastKind;
            }
            if (elementType == OCTokenTypes.CONST_CAST_CPP_KEYWORD) {
                OCCastKind oCCastKind = OCCastKind.CONST_CAST;
                if (oCCastKind == null) {
                    OCCastExpressionImpl.$$$reportNull$$$0(3);
                }
                return oCCastKind;
            }
            if (elementType == OCTokenTypes.DYNAMIC_CAST_CPP_KEYWORD) {
                OCCastKind oCCastKind = OCCastKind.DYNAMIC_CAST;
                if (oCCastKind == null) {
                    OCCastExpressionImpl.$$$reportNull$$$0(4);
                }
                return oCCastKind;
            }
            if (elementType != OCTokenTypes.REINTERPRET_CAST_CPP_KEYWORD) continue;
            OCCastKind oCCastKind = OCCastKind.REINTERPRET_CAST;
            if (oCCastKind == null) {
                OCCastExpressionImpl.$$$reportNull$$$0(5);
            }
            return oCCastKind;
        }
        OCCastKind oCCastKind = OCCastKind.C_STYLE_CAST;
        if (oCCastKind == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(6);
        }
        return oCCastKind;
    }

    @Override
    public PsiElement getBridgeCastModifier() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = OCElementUtil.getElementType(child);
            if (!OCTokenTypes.BRIDGE_CAST_KEYWORDS.contains(elementType)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(7);
        }
        visitor.visitCastExpression(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(8);
        }
        OCCompoundInitializer compoundInitializer = this.getCompoundInitializer();
        OCType unresolvedType = this.getCastType();
        OCType resolvedType = unresolvedType.resolve(context);
        if (compoundInitializer != null && resolvedType instanceof OCStructType) {
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(Collections.singletonList(compoundInitializer));
            OCType oCType = OCTypeUtils.deduceClassTemplateArguments((OCStructType)resolvedType, unresolvedType, arguments, true, context, this.getContainingFile().getVirtualFile(), this.getComplexOffset());
            if (oCType == null) {
                OCCastExpressionImpl.$$$reportNull$$$0(9);
            }
            return oCType;
        }
        OCType oCType = resolvedType;
        if (oCType == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(10);
        }
        return oCType;
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(11);
        }
        OCType oCType = this.getCastType();
        if (oCType == null) {
            OCCastExpressionImpl.$$$reportNull$$$0(12);
        }
        return oCType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCCastExpressionImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCCastExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCastType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCastKind";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

