/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.MapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationProvider;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class OCResolveRootAndConfigurationCache {
    @NotNull
    private final Project myProject;
    private final Map<VirtualFile, OCResolveRootAndConfiguration> myCache;

    public OCResolveRootAndConfigurationCache(@NotNull Project project) {
        if (project == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(0);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, OCResolveRootAndConfiguration>();
        this.myProject = project;
    }

    @NotNull
    public static OCResolveRootAndConfigurationCache getInstance(@NotNull Project project) {
        if (project == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(1);
        }
        OCResolveRootAndConfigurationCache oCResolveRootAndConfigurationCache = (OCResolveRootAndConfigurationCache)project.getService(OCResolveRootAndConfigurationCache.class);
        if (oCResolveRootAndConfigurationCache == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(2);
        }
        return oCResolveRootAndConfigurationCache;
    }

    @Nullable
    public OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationSafe(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(3);
        }
        try {
            return this.inferAndCache(virtualFile, true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Deprecated
    @NotNull
    public OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(4);
        }
        return this.inferAndCache(virtualFile, false);
    }

    @NotNull
    private OCResolveRootAndConfiguration inferAndCache(@NotNull VirtualFile virtualFile, boolean checkSymbolsAreLoaded) {
        OCResolveRootAndConfiguration cached;
        if (virtualFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(5);
        }
        if ((cached = this.myCache.get(virtualFile)) != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = cached;
            if (oCResolveRootAndConfiguration == null) {
                OCResolveRootAndConfigurationCache.$$$reportNull$$$0(6);
            }
            return oCResolveRootAndConfiguration;
        }
        OCResolveRootAndConfiguration result = this.inferResolveRootAndActiveConfiguration(virtualFile, checkSymbolsAreLoaded);
        this.myCache.put(virtualFile, result);
        ((OCInclusionContextListener)this.myProject.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result);
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = result;
        if (oCResolveRootAndConfiguration == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(7);
        }
        return oCResolveRootAndConfiguration;
    }

    @NotNull
    private OCResolveRootAndConfiguration inferResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, boolean checkSymbolsAreLoaded) {
        OCResolveRootAndConfiguration resolveRootAndConfiguration;
        if (virtualFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(8);
        }
        if ((resolveRootAndConfiguration = OCResolveRootAndConfigurationProvider.inferResolveRootAndConfiguration(virtualFile, this.myProject)) != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = resolveRootAndConfiguration;
            if (oCResolveRootAndConfiguration == null) {
                OCResolveRootAndConfigurationCache.$$$reportNull$$$0(9);
            }
            return oCResolveRootAndConfiguration;
        }
        if (OCRootKind.getRootKind(virtualFile, this.myProject) == OCRootKind.Include) {
            if (checkSymbolsAreLoaded && !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                throw IndexNotReadyException.create();
            }
            OCResolveRootAndConfiguration headerResult = this.inferResolveRootAndActiveConfigurationForHeader(virtualFile);
            if (headerResult != null) {
                OCResolveRootAndConfiguration oCResolveRootAndConfiguration = headerResult;
                if (oCResolveRootAndConfiguration == null) {
                    OCResolveRootAndConfigurationCache.$$$reportNull$$$0(10);
                }
                return oCResolveRootAndConfiguration;
            }
        }
        OCResolveConfiguration preselectedConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)virtualFile, (Project)this.myProject);
        return this.createResolveRootAndConfiguration(preselectedConfiguration, virtualFile);
    }

    public void invalidateForAll() {
        this.invalidateForAllExcept(null);
    }

    public void invalidateForAllExcept(@Nullable VirtualFile virtualFile) {
        this.invalidateExcept(virtualFile);
        OCHeaderContextCache.invalidateHeaderContextsExcept(virtualFile, this.myProject);
    }

    public void invalidateFor(@Nullable VirtualFile virtualFileInEditor) {
        if (virtualFileInEditor == null) {
            return;
        }
        this.myCache.remove(virtualFileInEditor);
        OCHeaderContextCache.invalidateHeaderContextsExcept(null, this.myProject);
    }

    private void invalidateExcept(@Nullable VirtualFile virtualFile) {
        MapUtil.removeExcept(this.myCache, virtualFile);
    }

    @Nullable
    private OCResolveRootAndConfiguration inferResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile) {
        if (virtualHeaderFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(11);
        }
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(importGraph.getAllHeaderRoots(virtualHeaderFile));
        roots.sort(new VirtualFileComparator(this.myProject, headerNameWithoutExtension));
        ArrayList<Pair> rootsThatMayMatchSelectedConfiguration = new ArrayList<Pair>();
        for (VirtualFile root : roots) {
            Ref scoreRef;
            Collection configs = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)this.myProject);
            if (OCResolveConfigurations.findPreselectedConfiguration((Project)this.myProject, (Collection)configs, (Ref)(scoreRef = new Ref((Object)0))) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(Pair.create((Object)root, (Object)((Integer)scoreRef.get())));
        }
        rootsThatMayMatchSelectedConfiguration.sort((o1, o2) -> Comparing.compare((Comparable)((Integer)o1.second), (Comparable)((Integer)o2.second)));
        OCResolveRootAndConfiguration fallBack = null;
        HashSet<VirtualFile> visitedRoots = new HashSet<VirtualFile>(rootsThatMayMatchSelectedConfiguration.size());
        for (Pair info : rootsThatMayMatchSelectedConfiguration) {
            VirtualFile rootFile = (VirtualFile)info.first;
            visitedRoots.add(rootFile);
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCResolveConfigurations.findPreselectedConfiguration((Project)this.myProject, configurations, null);
            if (configuration != null) {
                return this.createResolveRootAndConfiguration(configuration, rootFile);
            }
            if (fallBack != null) continue;
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)this.myProject, configurations);
            if (c.first == null) continue;
            fallBack = this.createResolveRootAndConfiguration((OCResolveConfiguration)c.first, rootFile);
        }
        for (VirtualFile rootFile : roots) {
            if (visitedRoots.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)this.myProject, configurations);
            if (c.first == null) continue;
            return this.createResolveRootAndConfiguration((OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private OCResolveRootAndConfiguration createResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            OCResolveRootAndConfigurationCache.$$$reportNull$$$0(12);
        }
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, this.myProject, false);
        return new OCResolveRootAndConfiguration(configuration, kind, rootFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCResolveRootAndConfigurationCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualHeaderFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCResolveRootAndConfigurationCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inferAndCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inferResolveRootAndActiveConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfigurationSafe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inferAndCache";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inferResolveRootAndActiveConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inferResolveRootAndActiveConfigurationForHeader";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createResolveRootAndConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        VirtualFileComparator(Project project, String headerNameWithoutExtension) {
            this.myProject = project;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result;
            if (root1 == null) {
                VirtualFileComparator.$$$reportNull$$$0(0);
            }
            if (root2 == null) {
                VirtualFileComparator.$$$reportNull$$$0(1);
            }
            if ((result = Boolean.compare(OCPCHCache.isPrecompiledHeader((VirtualFile)root1, (Project)this.myProject), OCPCHCache.isPrecompiledHeader((VirtualFile)root2, (Project)this.myProject))) != 0) {
                return -result;
            }
            result = Boolean.compare(OCFileTypeHelpers.isSourceFile((String)root1.getName()), OCFileTypeHelpers.isSourceFile((String)root2.getName()));
            if (result != 0) {
                return -result;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result = Boolean.compare(this.myHeaderNameWithoutExtension.equals(rootName1), this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result != 0) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root2";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCResolveRootAndConfigurationCache$VirtualFileComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

