/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextLazyGetDefinition;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextLazyGetDefinitionProvider;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCProtectedIncludeStack;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCInclusionContext
extends OCImmutableInclusionContext {
    @Override
    @NotNull
    public OCLanguageKind getLanguageKind();

    @NotNull
    public OCInclusionContext setRootFile(@Nullable PsiFile var1);

    public void setInheritProcessedFiles(boolean var1);

    public void addProcessedFile(@NotNull VirtualFile var1);

    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable var1);

    public void setProcessingListener(@Nullable Processor<OCSymbol> var1);

    public void setResolvePathListener(@Nullable ResolvePathListener var1);

    public void setChangeBuilder(@Nullable OCContextChangeBuilder var1);

    public void setPrecompiledHeaders(@NotNull List<VirtualFile> var1);

    @NotNull
    public OCParsingNameScope getNameScope();

    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean var1);

    @NotNull
    public OCInclusionContext deriveWithLanguageKind(@NotNull OCLanguageKind var1);

    default public void markExactDefinition(@NotNull String name, @NotNull String content) {
        if (name == null) {
            OCInclusionContext.$$$reportNull$$$0(0);
        }
        if (content == null) {
            OCInclusionContext.$$$reportNull$$$0(1);
        }
        this.markExactDefinition(name, content, false);
    }

    public void markExactDefinition(@NotNull String var1, @NotNull String var2, boolean var3);

    public void define(@NotNull OCMacroSymbol var1);

    public void define(String var1, String var2);

    public void undef(String var1);

    public void hideDefinition(@NotNull String var1);

    public void revealDefinition(@NotNull String var1);

    public void setSignatureBuilder(@Nullable SignatureBuilder var1);

    public void enterNamespace(@NotNull String var1);

    public void exitNamespace();

    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull VirtualFile var2, boolean var3);

    public boolean reserveInclude(@NotNull VirtualFile var1, boolean var2);

    public void preprocessContextOf(@Nullable PsiFile var1, @Nullable VirtualFile var2);

    public void preprocessInclude(@Nullable PsiFile var1, boolean var2);

    public boolean preprocessInclude(@Nullable PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4);

    @Contract(value="_, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable VirtualFile var1, @Nullable VirtualFile var2, int var3, int var4, int var5, @NotNull List<OCSymbol> var6, @Nullable OCContextChangeSet var7);

    public boolean preprocessInclude(@NotNull VirtualFile var1, boolean var2, @Nullable VirtualFile var3, int var4, @NotNull OCProtectedIncludeStack var5, int var6, @Nullable OCContextChangeSet var7);

    public void markAsInclude();

    @Nullable
    public Runnable getImpatientRescheduling();

    public void setImpatientRescheduling(@Nullable Runnable var1);

    public void setAbortOnLanguageKindMismatch(boolean var1);

    public static int getMaxInclusionLevel() {
        Integer inTests = OCInclusionContextImpl.MAX_INCLUSION_LEVEL_IN_TESTS;
        return inTests != null ? inTests : OCInclusionContextImpl.DEFAULT_MAX_INCLUSION_LEVEL;
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file, @NotNull OCResolveConfiguration configuration) {
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(3);
        }
        return OCPCHCache.isPrecompiledHeader((VirtualFile)file, (Project)configuration.getProject());
    }

    public static void onPrecompiledContextChange(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        OCPCHCache.onProjectContextChange((Project)project);
        configuration.putUserData(OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY, null);
    }

    public static void clearSymbolTableConformanceCache(OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        OCPCHCache.onProjectContextChange((Project)project);
        configuration.putUserData(OCInclusionContextImpl.INCLUDE_RESOLVE_CACHE, null);
    }

    @NotNull
    public static OCInclusionContext empty(@NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(5);
        }
        OCInclusionContextLazyGetDefinition lazyGetDefinition = OCInclusionContextLazyGetDefinitionProvider.inferLazyGetDefinition(file, kind, null);
        OCInclusionContext oCInclusionContext = new OCInclusionContextImpl(null, file.getProject(), kind, null, lazyGetDefinition).setRootFile(file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(6);
        }
        return oCInclusionContext;
    }

    @Nullable
    public static OCInclusionContext beforePCHFileContext(@NotNull PsiFile file) {
        OCLanguageKind kind;
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(7);
        }
        if ((kind = OCPsiFile.getKind(file)) == null) {
            return null;
        }
        OCResolveConfiguration configuration = OCFileActiveConfigurationCache.getActiveConfiguration((PsiElement)file);
        return configuration == null ? OCInclusionContextImpl.emptyWithBuiltinMacros(kind, file) : OCInclusionContext.beforePCHFileContext(configuration, kind, file);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(8);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(10);
        }
        OCInclusionContext oCInclusionContext = OCInclusionContext.initialContextWithoutRoot(configuration, kind, file).derive(file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(11);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(13);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(14);
        }
        return OCInclusionContext.sourceParsingContext(configuration, kind, file, OCRootKind.Root);
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file, @NotNull OCRootKind rootKind) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(16);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(17);
        }
        if (rootKind == null) {
            OCInclusionContext.$$$reportNull$$$0(18);
        }
        OCInclusionContext result = OCInclusionContext.initialPCHContextWithoutRoot(configuration, kind, file).derive(file);
        if (rootKind == OCRootKind.Include) {
            result.markAsInclude();
        }
        OCInclusionContext oCInclusionContext = result;
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(19);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCImmutableInclusionContext initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(20);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(21);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(22);
        }
        OCInclusionContextImpl oCInclusionContextImpl = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        if (oCInclusionContextImpl == null) {
            OCInclusionContext.$$$reportNull$$$0(23);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    public static OCImmutableInclusionContext initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(24);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(25);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(26);
        }
        OCInclusionContextImpl oCInclusionContextImpl = OCInclusionContextImpl.initialPCHContextWithoutRoot(configuration, kind, file);
        if (oCInclusionContextImpl == null) {
            OCInclusionContext.$$$reportNull$$$0(27);
        }
        return oCInclusionContextImpl;
    }

    @Nullable
    public static OCImmutableInclusionContext tryFindInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (config == null) {
            OCInclusionContext.$$$reportNull$$$0(28);
        }
        if (header == null) {
            OCInclusionContext.$$$reportNull$$$0(29);
        }
        if (pchCandidate == null) {
            OCInclusionContext.$$$reportNull$$$0(30);
        }
        if (OCInclusionContext.isPrecompiledHeader(pchCandidate, config) && OCImportGraph.getInstance(config.getProject()).getAllRootHeaders(config, pchCandidate, null, OCRootKind.Root).contains(header)) {
            return OCInclusionContextImpl.findInCachedPCHPrecompiledContexts(config, header);
        }
        return null;
    }

    @Nullable
    public static String extractFirstPathLiteralText(@NotNull CharSequence contentWithoutMacros) {
        IElementType tt;
        if (contentWithoutMacros == null) {
            OCInclusionContext.$$$reportNull$$$0(31);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(contentWithoutMacros, 0, contentWithoutMacros.length(), 10);
        while (lexer.getState() == 10 && (tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.HEADER_PATH_LITERAL) {
                return lexer.getTokenText();
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static OCIncludeSymbol.IncludePath extractPath(@Nullable CharSequence rawPathLiteralContext, boolean unescapePath) {
        char maybeSuffixPunctuator;
        int length;
        if (rawPathLiteralContext == null || (length = rawPathLiteralContext.length()) < 2) {
            OCIncludeSymbol.IncludePath includePath = OCIncludeSymbol.IncludePath.EMPTY;
            if (includePath == null) {
                OCInclusionContext.$$$reportNull$$$0(32);
            }
            return includePath;
        }
        int start = 0;
        char prefixPunctuator = rawPathLiteralContext.charAt(0);
        if (prefixPunctuator == '\"' || prefixPunctuator == '<') {
            start = 1;
        }
        if ((maybeSuffixPunctuator = rawPathLiteralContext.charAt(length - 1)) == '\"' && prefixPunctuator == '\"' || maybeSuffixPunctuator == '>' && prefixPunctuator == '<') {
            --length;
        }
        String path = rawPathLiteralContext.subSequence(start, length).toString();
        if (unescapePath) {
            path = path.replace("\\\n", "");
        }
        return new OCIncludeSymbol.IncludePath(path, prefixPunctuator != '\"');
    }

    @NotNull
    public static OCLanguageKind handleLanguageKindMismatch(@NotNull VirtualFile rootFile, @NotNull LanguageKindMismatchException e, boolean allowFallback) {
        boolean rootResponsible;
        if (rootFile == null) {
            OCInclusionContext.$$$reportNull$$$0(33);
        }
        if (e == null) {
            OCInclusionContext.$$$reportNull$$$0(34);
        }
        if (!allowFallback) {
            AssertionError assertionError = new AssertionError("Unexpected language kind mismatch", e);
            OCInclusionContextImpl.LOG.error((Throwable)((Object)assertionError));
            throw assertionError;
        }
        OCInclusionContextImpl.LOG.trace((Throwable)e);
        VirtualFile responsibleFile = e.responsibleFile;
        boolean bl = rootResponsible = responsibleFile == null;
        if (rootResponsible) {
            responsibleFile = rootFile;
        }
        if (!e.attemptedLanguageKind.isObjC() && e.requiredLanguageKind.isObjC()) {
            OCLanguageKindCalculator.markAsObjC(responsibleFile);
        }
        if (rootResponsible && e.rootFile != null) {
            e.rootFile.clearCaches();
        }
        OCLanguageKind oCLanguageKind = e.requiredLanguageKind;
        if (oCLanguageKind == null) {
            OCInclusionContext.$$$reportNull$$$0(35);
        }
        return oCLanguageKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 19, 23, 27, 32, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 15: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pchCandidate";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWithoutMacros";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "beforePCHFileContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceParsingContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "initialContextWithoutRoot";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "initialPCHContextWithoutRoot";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "handleLanguageKindMismatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markExactDefinition";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPrecompiledHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 6: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 32: 
            case 35: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforePCHFileContext";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sourceParsingContext";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initialContextWithoutRoot";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "initialPCHContextWithoutRoot";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryFindInCachedPCHPrecompiledContexts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "extractFirstPathLiteralText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "handleLanguageKindMismatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 19, 23, 27, 32, 35 -> new IllegalStateException(string);
        };
    }

    public static class LanguageKindMismatchException
    extends RuntimeException
    implements ControlFlowException {
        @NotNull
        final OCLanguageKind attemptedLanguageKind;
        @NotNull
        final OCLanguageKind requiredLanguageKind;
        @Nullable
        final PsiFile rootFile;
        @NotNull
        final VirtualFile includedFile;
        @Nullable
        VirtualFile responsibleFile;

        LanguageKindMismatchException(@NotNull OCLanguageKind attemptedLanguageKind, @NotNull OCLanguageKind requiredLanguageKind, @Nullable PsiFile rootFile, @NotNull VirtualFile includedFile) {
            if (attemptedLanguageKind == null) {
                LanguageKindMismatchException.$$$reportNull$$$0(0);
            }
            if (requiredLanguageKind == null) {
                LanguageKindMismatchException.$$$reportNull$$$0(1);
            }
            if (includedFile == null) {
                LanguageKindMismatchException.$$$reportNull$$$0(2);
            }
            this.attemptedLanguageKind = attemptedLanguageKind;
            this.requiredLanguageKind = requiredLanguageKind;
            this.rootFile = rootFile;
            this.includedFile = includedFile;
        }

        @Override
        @NlsSafe
        public String getMessage() {
            VirtualFile responsibleFile = this.responsibleFile;
            return "Language Kind did not match.\nwas {" + this.attemptedLanguageKind.getShortDisplayName() + "}, but expected {" + this.requiredLanguageKind.getShortDisplayName() + "}\n" + (String)(this.rootFile != null ? "for file {" + LanguageKindMismatchException.getPresentableUrl(this.rootFile) + "}\n" : "") + "due to including of file {" + this.includedFile.getPresentableUrl() + "}\n" + (String)(responsibleFile != null ? "from file {" + responsibleFile.getPresentableUrl() + "}" : "");
        }

        @NotNull
        private static String getPresentableUrl(@NotNull PsiFile psiFile) {
            VirtualFile file;
            if (psiFile == null) {
                LanguageKindMismatchException.$$$reportNull$$$0(3);
            }
            String string = (file = PsiUtilCore.getVirtualFile((PsiElement)psiFile)) != null ? file.getPresentableUrl() : psiFile.getName();
            if (string == null) {
                LanguageKindMismatchException.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attemptedLanguageKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requiredLanguageKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includedFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext$LanguageKindMismatchException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext$LanguageKindMismatchException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableUrl";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ResolvePathListener {
        public void resolve(@NotNull OCIncludeSymbol.IncludePath var1, boolean var2, @Nullable VirtualFile var3);
    }

    public static interface SignatureBuilder {
        public void setDefined(@NotNull String var1, boolean var2);

        public void setHeaderGuardDefined(@NotNull String var1, boolean var2);

        public void setDefinition(@NotNull String var1, @NotNull OCMacroSymbol var2);

        public void setIsDumbPlaceholder();

        public void enterConformanceCheckMode();

        public void exitConformanceCheckMode(boolean var1);
    }
}

