/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.navigation.OCFakeNavigatablePsiElement;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.settings.OCGotoDefinitionSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCGotoDeclarationHandler
implements GotoDeclarationHandler {
    static final int SLOW_RESULTS_TIMEOUT = 6000;

    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        PsiFile file;
        PsiFile psiFile = file = sourceElement != null ? sourceElement.getContainingFile() : null;
        if (!(file instanceof OCFile)) {
            return null;
        }
        if (Registry.is((String)"clion.clang.clangd.full_navigation")) {
            Pair<PsiFile, Integer> location = ExternalResolveUtils.resolveLocation(file, offset);
            if (location == null) {
                return null;
            }
            return new PsiElement[]{new OCFakeNavigatablePsiElement((PsiFile)location.getFirst(), (Integer)location.getSecond(), file.getViewProvider().getVirtualFile(), offset)};
        }
        if (ExternalResolveUtils.canDoExternalResolveRelaxed(sourceElement.getProject())) {
            Callable<PsiElement[]> slowResolver = () -> OCGotoDeclarationHandler.doGetGotoDeclarationTargets((OCFile)file, sourceElement, offset, editor);
            Callable<PsiElement[]> fastResolver = () -> ExternalResolveUtils.resolveElements(file, offset);
            PsiElement[] results = ExternalResolveUtils.findInParallel(6000L, slowResolver, fastResolver);
            if (results == null) {
                return null;
            }
            int adjustedOffset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)offset);
            return (PsiElement[])Arrays.stream(results).filter(result -> !OCGotoDeclarationHandler.isInsideElement(result, sourceElement, adjustedOffset)).toArray(PsiElement[]::new);
        }
        return OCGotoDeclarationHandler.doGetGotoDeclarationTargets((OCFile)file, sourceElement, offset, editor);
    }

    private static PsiElement @Nullable [] doGetGotoDeclarationTargets(@NotNull OCFile file, @NotNull PsiElement sourceElement, int offset, Editor editor) {
        if (file == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (sourceElement == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        Collection<? extends OCSymbol> symbols = OCGotoDeclarationHandler.getTargetSymbols(editor, sourceElement, offset);
        for (OCSymbol oCSymbol : symbols) {
            PsiElement element = oCSymbol.locateDefinition(file.getProject());
            int adjustedOffset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)offset);
            if (element == null || OCGotoDeclarationHandler.isInsideElement(element, sourceElement, adjustedOffset)) continue;
            if (element instanceof OCCallable && OCElementUtil.getElementType(file.findElementAt(offset)) != OCTokenTypes.IDENTIFIER) {
                return null;
            }
            elements.add(element);
        }
        return elements.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Contract(value="null,_,_ -> false; _,null,_ -> false")
    private static boolean isInsideElement(@Nullable PsiElement parent, @Nullable PsiElement child, int offset) {
        return parent != null && child != null && parent.getTextRange().contains(offset) && parent.getContainingFile() == child.getContainingFile();
    }

    private static Collection<? extends OCSymbol> getTargetSymbols(Editor editor, @NotNull PsiElement sourceElement, int offset) {
        OCSymbol symbol;
        PsiElement source;
        if (sourceElement == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        if ((source = OCGotoDeclarationHandler.findFoldedStringResourceTarget(editor, sourceElement)) == null) {
            source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags() | 0x1000, offset);
        }
        Collection<OCSymbol> namespaces = null;
        if (source instanceof OCCppNamespaceQualifier) {
            namespaces = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source);
        } else {
            ASTNode node = sourceElement.getNode();
            if (node != null && node.getElementType() == OCTokenTypes.IDENTIFIER && sourceElement.getParent() instanceof OCCppNamespaceQualifier) {
                namespaces = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)sourceElement.getParent());
            }
        }
        if (!ContainerUtil.isEmpty(namespaces)) {
            return namespaces;
        }
        OCSymbol oCSymbol = symbol = source instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)source).getSymbol() : null;
        if (symbol == null) {
            return Collections.emptyList();
        }
        if (symbol instanceof OCFunctionGroupSymbol) {
            return ((OCFunctionGroupSymbol)symbol).getOverloads();
        }
        LinkedHashSet<OCSymbol> result = new LinkedHashSet<OCSymbol>();
        boolean insideElement = OCGotoDeclarationHandler.isInsideElement(source, sourceElement, offset);
        Project project = sourceElement.getProject();
        if (symbol.isCallable() || insideElement) {
            OCInterfaceSymbol mainInterface;
            OCSendMessageExpression sendMessageExpression;
            OCObjectTypeContext receiverContext;
            PsiElement psiElement;
            PsiReference reference;
            OCSymbol definitionSymbol = null;
            if (symbol instanceof OCMethodSymbol && (reference = TargetElementUtil.findReference((Editor)editor, (int)offset)) != null && (psiElement = reference.getElement()) instanceof OCSendMessageExpression && (receiverContext = (sendMessageExpression = (OCSendMessageExpression)psiElement).getReceiverContext()) != null) {
                definitionSymbol = receiverContext.getKnownResponder(sendMessageExpression.getMessageSelector(), false);
            }
            if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface(project)) != null) {
                result.add(mainInterface);
            }
            if (definitionSymbol == null) {
                definitionSymbol = symbol.getDefinitionSymbol(project);
            }
            if (definitionSymbol == symbol && insideElement && OCGotoDefinitionSettings.getInstance().shouldJumpToAssociatedSymbol) {
                OCSymbol declSymbol;
                OCCppNamespaceQualifier namespaceQualifier = source instanceof OCDeclarator ? ((OCDeclarator)source).getNamespaceQualifier() : null;
                List<Object> parentSymbols = namespaceQualifier != null ? namespaceQualifier.resolveToSymbols() : Collections.emptyList();
                OCSymbol parentSymbol = parentSymbols.size() == 1 ? (OCSymbol)parentSymbols.get(0) : null;
                OCSymbol oCSymbol2 = declSymbol = parentSymbol instanceof OCStructSymbol ? ((OCStructSymbol)parentSymbol).findMember(symbol.getName()) : null;
                if (declSymbol == null || !declSymbol.isSameSymbol(symbol, project)) {
                    declSymbol = symbol.getAssociatedSymbol(project);
                }
                if (!(declSymbol == null || symbol instanceof OCClassSymbol && StringUtil.isEmpty((String)((OCClassSymbol)symbol).getCategoryName()) && !result.isEmpty())) {
                    result.add(declSymbol);
                }
                if (symbol instanceof OCMemberSymbol) {
                    OCSymbol relatedSymbol;
                    CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                        protected boolean accept(OCMemberSymbol memberSymbol) {
                            return !memberSymbol.isDefinition();
                        }
                    };
                    OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, true, false, project);
                    if (finder.isFound()) {
                        result.add((OCSymbol)finder.getFoundValue());
                    }
                    if ((relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, project)) != null) {
                        result.add(relatedSymbol);
                    }
                }
            } else if (definitionSymbol != null) {
                result.add(definitionSymbol);
            } else if (symbol instanceof OCMemberSymbol) {
                CommonProcessors.CollectProcessor<OCMemberSymbol> finder = new CommonProcessors.CollectProcessor<OCMemberSymbol>(){

                    protected boolean accept(OCMemberSymbol memberSymbol) {
                        return memberSymbol.isDefinition();
                    }
                };
                OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, false, true, project);
                result.addAll(finder.getResults());
            }
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                result.add((OCSymbol)symbol1);
                return true;
            }), project);
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null) {
            PsiElement element = symbol.locateDefinition(project);
            OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(project);
            if (property != null && (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(project) || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)element.getParent()).getPropertyRef() == element)) {
                symbol = property;
            }
        }
        if (result.isEmpty()) {
            result.add(symbol);
        }
        return result;
    }

    @Nullable
    private static PsiElement findFoldedStringResourceTarget(@NotNull Editor editor, @NotNull PsiElement sourceElement) {
        PsiReference ref;
        FoldRegion foldRegion;
        OCMacroCall macroCall;
        PsiElement parent;
        if (editor == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(4);
        }
        if ((parent = sourceElement.getParent()) != null && PsiUtilCore.getElementType((ASTNode)parent.getNode()) == OCElementTypes.MACRO_REF && (macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)parent, OCMacroCall.class)) != null && (foldRegion = editor.getFoldingModel().getFoldRegion(PsiTreeUtilKt.getStartOffset((PsiElement)macroCall), PsiTreeUtilKt.getEndOffset((PsiElement)macroCall))) != null && !foldRegion.isExpanded() && (ref = OCElementUtil.findReferenceInMacroCall(macroCall, null)) instanceof OCStringResourceReference) {
            return ref.resolve();
        }
        return null;
    }

    private static Collection<OCSymbol> getAppropriateNamespaceDeclarations(OCCppNamespaceQualifier source) {
        Collection<OCSymbol> symbols;
        if (source.getParent() instanceof OCReferenceElement) {
            symbols = ((OCReferenceElement)source.getParent()).resolveToOverloadsSymbols();
        } else if (source.getParent() instanceof OCCppNamespaceQualifier) {
            symbols = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source.getParent());
        } else {
            return Collections.emptyList();
        }
        LinkedHashSet<OCSymbol> result = new LinkedHashSet<OCSymbol>();
        List<OCSymbol> ownSymbols = source.resolveToSymbols();
        for (OCSymbol ownSymbol : ownSymbols) {
            for (OCSymbol child : symbols) {
                if (!(child instanceof OCSymbolWithQualifiedName) || !ownSymbol.equals(((OCSymbolWithQualifiedName)child).getParent()) || !OCGotoDeclarationHandler.isNamespaceWithVisibleName(ownSymbol)) continue;
                result.add(ownSymbol);
            }
        }
        return result;
    }

    private static boolean isNamespaceWithVisibleName(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCGotoDeclarationHandler.$$$reportNull$$$0(5);
        }
        return symbol instanceof OCNamespaceSymbol && !((OCNamespaceSymbol)symbol).isSyntheticNamespace();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetGotoDeclarationTargets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetSymbols";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findFoldedStringResourceTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isNamespaceWithVisibleName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

