/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.util.VirtualFileUtilKt;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\"\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapDefaultPathResolver;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPathResolver;", "resolveRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "scopeRoot", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "resolveHeader", "relativePath", "", "resolveDir", "containsHeader", "", "file", "containsDir", "getRelativeHeaderPath", "derive", "moduleName", "moduleScope", "isFramework", "unsafeResolveRoot", "getUnsafeResolveRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "unsafeScopeRoot", "getUnsafeScopeRoot", "Companion", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nModuleMapDefaultPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapDefaultPathResolver.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapDefaultPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class ModuleMapDefaultPathResolver
implements ModuleMapPathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile resolveRoot;
    @NotNull
    private final VirtualFile scopeRoot;
    @NotNull
    private static final Regex regex;

    @JvmOverloads
    public ModuleMapDefaultPathResolver(@NotNull VirtualFile resolveRoot, @NotNull VirtualFile scopeRoot) {
        Intrinsics.checkNotNullParameter((Object)resolveRoot, (String)"resolveRoot");
        Intrinsics.checkNotNullParameter((Object)scopeRoot, (String)"scopeRoot");
        this.resolveRoot = resolveRoot;
        this.scopeRoot = scopeRoot;
    }

    public /* synthetic */ ModuleMapDefaultPathResolver(VirtualFile virtualFile, VirtualFile virtualFile2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            virtualFile2 = virtualFile;
        }
        this(virtualFile, virtualFile2);
    }

    @Override
    @Nullable
    public VirtualFile resolveHeader(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        CharSequence charSequence = relativePath;
        Regex regex = ModuleMapDefaultPathResolver.regex;
        String string = "/";
        String path = regex.replace(charSequence, string);
        boolean bl = false;
        VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.resolveRoot);
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(path)) == null) {
            virtualFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public VirtualFile resolveDir(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.resolveHeader(relativePath);
    }

    @Override
    public boolean containsHeader(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.scopeRoot);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            bl = VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean containsDir(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.containsHeader(file);
    }

    @Override
    @Nullable
    public String getRelativeHeaderPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.containsHeader(file) ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.resolveRoot) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ModuleMapDefaultPathResolver derive(@NotNull String moduleName, @Nullable String moduleScope, boolean isFramework) {
        ModuleMapDefaultPathResolver moduleMapDefaultPathResolver;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        if (moduleScope != null) {
            String it = moduleScope;
            boolean bl = false;
            VirtualFile virtualFile = this.resolveRoot.findFileByRelativePath(it);
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                VirtualFile it2 = virtualFile3 = virtualFile;
                boolean bl2 = false;
                Object object = virtualFile2 = it2.isDirectory() ? virtualFile3 : null;
                if (virtualFile2 != null) {
                    VirtualFile it3 = virtualFile2;
                    boolean bl3 = false;
                    moduleMapDefaultPathResolver = new ModuleMapDefaultPathResolver(this.resolveRoot, it3);
                    return moduleMapDefaultPathResolver;
                }
            }
        }
        moduleMapDefaultPathResolver = this;
        return moduleMapDefaultPathResolver;
    }

    @TestOnly
    @NotNull
    public final VirtualFile getUnsafeResolveRoot() {
        return this.resolveRoot;
    }

    @TestOnly
    @NotNull
    public final VirtualFile getUnsafeScopeRoot() {
        return this.scopeRoot;
    }

    @JvmOverloads
    public ModuleMapDefaultPathResolver(@NotNull VirtualFile resolveRoot) {
        Intrinsics.checkNotNullParameter((Object)resolveRoot, (String)"resolveRoot");
        this(resolveRoot, null, 2, null);
    }

    static {
        Pattern pattern = Pattern.compile("^/{2,}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern pattern2 = pattern;
        regex = new Regex(pattern2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapDefaultPathResolver$Companion;", "", "<init>", "()V", "regex", "Lkotlin/text/Regex;", "createUninitialized", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapDefaultPathResolver;", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleMapDefaultPathResolver createUninitialized() {
            NullVirtualFile nullVirtualFile = NullVirtualFile.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)nullVirtualFile, (String)"INSTANCE");
            return new ModuleMapDefaultPathResolver((VirtualFile)nullVirtualFile, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

