/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/IncludedHeadersRootModuleMapCollector;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRootProcessor;", "root", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;)V", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "_roots", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "process", "", "file", "roots", "", "getRoots", "()Ljava/util/List;", "intellij.c"})
public final class IncludedHeadersRootModuleMapCollector
extends HeadersSearchRootProcessor {
    @NotNull
    private final IncludedHeadersRoot root;
    @Nullable
    private final VirtualFile baseDir;
    @NotNull
    private final List<HeadersSearchRoot> _roots;

    public IncludedHeadersRootModuleMapCollector(@NotNull IncludedHeadersRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.baseDir = this.root.getVirtualFile();
        this._roots = new ArrayList();
        if (this.baseDir != null) {
            this._roots.add((HeadersSearchRoot)this.root);
        }
    }

    public boolean process(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory() && !Intrinsics.areEqual((Object)file, (Object)this.baseDir)) {
            IncludedHeadersRoot includedHeadersRoot = IncludedHeadersRoot.create((Project)this.root.getProject(), (VirtualFile)file, (boolean)false, (boolean)false, (HeadersSearchPath.Kind)this.root.getKind());
            Intrinsics.checkNotNullExpressionValue((Object)includedHeadersRoot, (String)"create(...)");
            this._roots.add((HeadersSearchRoot)includedHeadersRoot);
        }
        return true;
    }

    @NotNull
    public final List<HeadersSearchRoot> getRoots() {
        return this._roots;
    }
}

