/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.interactive.repl.hosting;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.interactive.OCInteractiveBundle;
import com.jetbrains.cidr.lang.interactive.repl.history.CommandHistory;
import com.jetbrains.cidr.lang.interactive.repl.history.OCHistoryKeyListener;
import com.jetbrains.cidr.lang.interactive.repl.hosting.OCAbstractReplConsoleRunnerKt;
import com.jetbrains.cidr.lang.interactive.repl.hosting.OCAbstractReplHost;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002EFB9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010)\u001a\u0004\u0018\u00010\u001aH\u0004J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020\bH\u0014J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001aJ\b\u00101\u001a\u00020\u001cH&J\u000e\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006J\u0018\u00104\u001a\u00020/2\u0006\u00103\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006H\u0016J\b\u00106\u001a\u000207H\u0014J\n\u00108\u001a\u0004\u0018\u000109H\u0014J&\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010\"\u001a\u00020!H\u0014J\b\u0010A\u001a\u00020\u0002H\u0014J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000209H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR+\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8D@DX\u0084\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006G"}, d2={"Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplConsoleRunner;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lcom/intellij/execution/console/LanguageConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "icon", "Ljavax/swing/Icon;", "language", "Lcom/intellij/lang/Language;", "fileExtension", "replHost", "Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/lang/Language;Ljava/lang/String;Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;)V", "getTitle", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getLanguage", "()Lcom/intellij/lang/Language;", "getFileExtension", "commandHistory", "Lcom/jetbrains/cidr/lang/interactive/repl/history/CommandHistory;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "fallbackDir", "getFallbackDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentDescriptor", "getContentDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "setContentDescriptor", "(Lcom/intellij/execution/ui/RunContentDescriptor;)V", "contentDescriptor$delegate", "Lkotlin/properties/ReadWriteProperty;", "getCurrentFile", "isValid", "", "isAutoFocusContent", "getConsoleIcon", "sendFile", "", "file", "createCommandLine", "createExecutableTextFrom", "visibleText", "sendText", "executableText", "createExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "createProcess", "Ljava/lang/Process;", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "createConsoleView", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "LoadCurrentFileAction", "ResetInteractiveAction", "intellij.c"})
public abstract class OCAbstractReplConsoleRunner
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String title;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Language language;
    @NotNull
    private final String fileExtension;
    @NotNull
    private final OCAbstractReplHost replHost;
    @NotNull
    private final CommandHistory commandHistory;
    @Nullable
    private final VirtualFile projectDir;
    @Nullable
    private GeneralCommandLine commandLine;
    @Nullable
    private final VirtualFile fallbackDir;
    @NotNull
    private final ReadWriteProperty contentDescriptor$delegate;

    public OCAbstractReplConsoleRunner(@NotNull Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @NotNull Icon icon, @NotNull Language language, @NotNull String fileExtension, @NotNull OCAbstractReplHost replHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
        super(project, title, null);
        this.title = title;
        this.icon = icon;
        this.language = language;
        this.fileExtension = fileExtension;
        this.replHost = replHost;
        this.commandHistory = new CommandHistory();
        VirtualFile virtualFile = this.projectDir = OCAbstractReplConsoleRunnerKt.access$isDirectoryBased(this.replHost.getProject()) ? this.replHost.getProject().getBaseDir() : null;
        this.fallbackDir = (virtualFile != null ? virtualFile.exists() : false) ? this.projectDir : VfsUtil.getUserHomeDir();
        this.contentDescriptor$delegate = Delegates.INSTANCE.notNull();
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @Nullable
    protected final VirtualFile getFallbackDir() {
        return this.fallbackDir;
    }

    @NotNull
    protected final RunContentDescriptor getContentDescriptor() {
        return (RunContentDescriptor)this.contentDescriptor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    protected final void setContentDescriptor(@NotNull RunContentDescriptor runContentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)runContentDescriptor, (String)"<set-?>");
        this.contentDescriptor$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)runContentDescriptor);
    }

    @Nullable
    protected final VirtualFile getCurrentFile() {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor();
        return fileEditor != null ? fileEditor.getFile() : null;
    }

    public final boolean isValid() {
        ProcessHandler processHandler = this.getProcessHandler();
        if (processHandler == null) {
            return false;
        }
        ProcessHandler processHandler2 = processHandler;
        return !processHandler2.isProcessTerminated() && !processHandler2.isProcessTerminating();
    }

    public boolean isAutoFocusContent() {
        return false;
    }

    @NotNull
    protected Icon getConsoleIcon() {
        return this.icon;
    }

    public final void sendFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isValid()) {
            return;
        }
        String visibleText = ".L " + file.getPath();
        String executableText = this.createExecutableTextFrom(visibleText);
        this.sendText(visibleText, executableText);
    }

    @NotNull
    public abstract GeneralCommandLine createCommandLine();

    @NotNull
    public final String createExecutableTextFrom(@NotNull String visibleText) {
        Intrinsics.checkNotNullParameter((Object)visibleText, (String)"visibleText");
        return visibleText + "\n";
    }

    public void sendText(@NotNull String visibleText, @NotNull String executableText) {
        Intrinsics.checkNotNullParameter((Object)visibleText, (String)"visibleText");
        Intrinsics.checkNotNullParameter((Object)executableText, (String)"executableText");
        if (!this.isValid()) {
            return;
        }
        this.getConsoleView().print(visibleText, ConsoleViewContentType.USER_INPUT);
        this.getConsoleView().print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        EditorUtil.scrollToTheEnd((Editor)((Editor)this.getConsoleView().getHistoryViewer()));
        this.commandHistory.addEntry(new CommandHistory.Entry(visibleText, executableText));
        RunContentManager.getInstance((Project)this.getProject()).selectRunContent(this.getContentDescriptor());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(this.getExecutor().getId());
        if (toolWindow != null) {
            toolWindow.show(null);
        }
        OutputStream outputStream2 = this.getProcessHandler().getProcessInput();
        if (outputStream2 == null) {
            throw new IllegalStateException("Broken interactive stream".toString());
        }
        OutputStream stream = outputStream2;
        try {
            byte[] byArray = executableText.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            stream.write(byArray);
            stream.flush();
        }
        catch (IOException e) {
            OCLog.LOG.warn("Interactive stream is closed.", (Throwable)e);
        }
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessHandler processHandler = this.getProcessHandler();
        return new ProcessBackedConsoleExecuteActionHandler(this, processHandler){
            final /* synthetic */ OCAbstractReplConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false);
            }

            public void runExecuteAction(LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                String string = consoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String visibleText = string;
                String executableText = this.this$0.createExecutableTextFrom(visibleText);
                this.this$0.sendText(visibleText, executableText);
                consoleView.setInputText("");
            }
        };
    }

    @Nullable
    protected Process createProcess() {
        block5: {
            block4: {
                this.commandLine = this.createCommandLine();
                if (this.commandLine == null) break block4;
                GeneralCommandLine generalCommandLine = this.commandLine;
                Intrinsics.checkNotNull((Object)generalCommandLine);
                if (new File(generalCommandLine.getExePath()).exists()) break block5;
            }
            GeneralCommandLine generalCommandLine = this.commandLine;
            String string = generalCommandLine != null ? generalCommandLine.getExePath() : null;
            if (string == null) {
                string = "";
            }
            String exePath = string;
            Object[] objectArray = new Object[]{exePath};
            throw new ProcessNotCreatedException(OCInteractiveBundle.INSTANCE.message("dialog.message.interactive.process.0.not.created", objectArray), this.commandLine);
        }
        GeneralCommandLine generalCommandLine = this.commandLine;
        Intrinsics.checkNotNull((Object)generalCommandLine);
        return generalCommandLine.createProcess();
    }

    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setContentDescriptor(contentDescriptor);
        Object[] objectArray = new AnAction[]{new LoadCurrentFileAction(this.replHost), this.createCloseAction(defaultExecutor, contentDescriptor), new ResetInteractiveAction(this.replHost)};
        List actionList = CollectionsKt.mutableListOf((Object[])objectArray);
        toolbarActions.addAll((Collection)actionList);
        actionList.add(this.createConsoleExecAction(this.getConsoleExecuteActionHandler()));
        return actionList;
    }

    @NotNull
    protected LanguageConsoleView createConsoleView() {
        BasicGutterContentProvider gutterProvider2 = new BasicGutterContentProvider(){

            public void beforeEvaluate(Editor e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        LanguageConsoleView languageConsoleView = new LanguageConsoleBuilder().gutterContentProvider((GutterContentProvider)gutterProvider2).build(this.getProject(), this.language);
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"build(...)");
        LanguageConsoleView consoleView = languageConsoleView;
        OCHistoryKeyListener historyKeyListener = new OCHistoryKeyListener(this.replHost.getProject(), consoleView.getConsoleEditor(), this.commandHistory, false, 8, null);
        consoleView.getConsoleEditor().getContentComponent().addKeyListener(historyKeyListener);
        this.commandHistory.getListeners().add(historyKeyListener);
        return consoleView;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        GeneralCommandLine generalCommandLine = this.commandLine;
        Intrinsics.checkNotNull((Object)generalCommandLine);
        String string = generalCommandLine.getCommandLineString();
        Charset charset = Charsets.UTF_8;
        return (OSProcessHandler)new ColoredProcessHandler(process2, string, charset){

            public boolean isSilentlyDestroyOnClose() {
                return true;
            }

            protected BaseOutputReader.Options readerOptions() {
                return BaseOutputReader.Options.BLOCKING;
            }
        };
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(OCAbstractReplConsoleRunner.class, "contentDescriptor", "getContentDescriptor()Lcom/intellij/execution/ui/RunContentDescriptor;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplConsoleRunner$LoadCurrentFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "replHost", "Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;", "<init>", "(Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.c"})
    private static final class LoadCurrentFileAction
    extends AnAction {
        @NotNull
        private final OCAbstractReplHost replHost;

        public LoadCurrentFileAction(@NotNull OCAbstractReplHost replHost) {
            Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
            super(OCInteractiveBundle.INSTANCE.message("interactive.action.load.current.file.text", new Object[0]), null, AllIcons.Actions.AddFile);
            this.replHost = replHost;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileEditor fileEditor = FileEditorManager.getInstance((Project)this.replHost.getProject()).getSelectedEditor();
            if (fileEditor == null || (fileEditor = fileEditor.getFile()) == null) {
                return;
            }
            FileEditor currentFile = fileEditor;
            this.replHost.getConsole$intellij_c().sendFile((VirtualFile)currentFile);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplConsoleRunner$ResetInteractiveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "replHost", "Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;", "<init>", "(Lcom/jetbrains/cidr/lang/interactive/repl/hosting/OCAbstractReplHost;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.c"})
    private static final class ResetInteractiveAction
    extends AnAction {
        @NotNull
        private final OCAbstractReplHost replHost;

        public ResetInteractiveAction(@NotNull OCAbstractReplHost replHost) {
            Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
            super(OCInteractiveBundle.INSTANCE.message("interactive.action.reset.text", new Object[0]), null, AllIcons.Actions.Restart);
            this.replHost = replHost;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.replHost.resetConsole$intellij_c();
        }
    }
}

