/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hmap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.hmap.Bucket;
import com.jetbrains.cidr.lang.hmap.ChannelScope;
import com.jetbrains.cidr.lang.hmap.GenerateByteChannelKt;
import com.jetbrains.cidr.lang.hmap.Header;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapsHelpersKt;
import com.jetbrains.cidr.lang.hmap.OCMutableHeaderMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J*\u0010\u0013\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0003JN\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010 \u001a\u00020\u00122\b\b\u0002\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&H\u0007JD\u0010'\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000e\u001a\u00020(2\b\b\u0002\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\f\u0010)\u001a\u00020&*\u00020&H\u0003J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0007J\f\u00103\u001a\u00020\u001f*\u000204H\u0007J\u0018\u00105\u001a\u00020\u001f*\u0002042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b.\u0010\u0003\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00106\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00100\u00a8\u00069"}, d2={"Lcom/jetbrains/cidr/lang/hmap/OCHeaderMaps;", "", "<init>", "()V", "NUL", "", "readFromFile", "Lcom/jetbrains/cidr/lang/hmap/OCMutableHeaderMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "readFromPath", "path", "Ljava/nio/file/Path;", "readFromChannel", "channel", "Ljava/nio/channels/SeekableByteChannel;", "unsafeReadAsCaseSensitive", "caseSensitive", "", "reconstructFrom", "header", "Lcom/jetbrains/cidr/lang/hmap/Header;", "buckets", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/cidr/lang/hmap/Bucket;", "stringsBuffer", "Ljava/nio/ByteBuffer;", "writeToPath", "", "map", "", "", "overwrite", "byteOrder", "Ljava/nio/ByteOrder;", "forceNormalization", "Ljava/text/Normalizer$Form;", "minCapacity", "", "writeToChannel", "Ljava/nio/channels/WritableByteChannel;", "toLowercase", "hashBucketKey", "bytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "unsafeDisableMacUnicodeNormalization", "getUnsafeDisableMacUnicodeNormalization$annotations", "getUnsafeDisableMacUnicodeNormalization", "()Z", "setUnsafeDisableMacUnicodeNormalization", "(Z)V", "normalizeForVFS", "", "normalizeForDisk", "useNormalizationFormD", "getUseNormalizationFormD", "StringPoolBuilder", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCHeaderMaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCHeaderMaps.kt\ncom/jetbrains/cidr/lang/hmap/OCHeaderMaps\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n1#2:310\n*E\n"})
public final class OCHeaderMaps {
    @NotNull
    public static final OCHeaderMaps INSTANCE = new OCHeaderMaps();
    private static final byte NUL = 0;
    @TestOnly
    private static boolean unsafeDisableMacUnicodeNormalization;

    private OCHeaderMaps() {
    }

    @JvmStatic
    @Nullable
    public static final OCMutableHeaderMap readFromFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = VfsUtilCore.virtualToIoFile((VirtualFile)file).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return OCHeaderMaps.readFromPath(path, false);
    }

    @JvmStatic
    @Nullable
    public static final OCMutableHeaderMap readFromPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return OCHeaderMaps.readFromPath(path, false);
    }

    @JvmStatic
    @ApiStatus.Experimental
    @Nullable
    public static final OCMutableHeaderMap readFromChannel(@NotNull SeekableByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return OCHeaderMaps.readFromChannel(channel, false);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final OCMutableHeaderMap unsafeReadAsCaseSensitive(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return OCHeaderMaps.readFromPath(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final OCMutableHeaderMap readFromPath(Path path, boolean caseSensitive) {
        Object object;
        try {
            OCMutableHeaderMap oCMutableHeaderMap;
            object = new OpenOption[]{StandardOpenOption.READ};
            object = Files.newByteChannel(path, object);
            Throwable throwable = null;
            try {
                SeekableByteChannel channel = (SeekableByteChannel)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)channel);
                oCMutableHeaderMap = OCHeaderMaps.readFromChannel(channel, caseSensitive);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = oCMutableHeaderMap;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    @JvmStatic
    private static final OCMutableHeaderMap readFromChannel(SeekableByteChannel channel, boolean caseSensitive) {
        try {
            ByteBuffer byteBuffer;
            ByteBuffer $this$readFromChannel_u24lambda_u241 = byteBuffer = OCHeaderMapsHelpersKt.read(channel, 24);
            boolean $i$a$-apply-OCHeaderMaps$readFromChannel$headerBuffer$22 = false;
            if ($this$readFromChannel_u24lambda_u241.remaining() < 24) {
                return null;
            }
            ByteBuffer headerBuffer = byteBuffer;
            Intrinsics.checkNotNull((Object)headerBuffer);
            ByteOrder[] $i$a$-apply-OCHeaderMaps$readFromChannel$headerBuffer$22 = new ByteOrder[]{ByteOrder.LITTLE_ENDIAN, ByteOrder.BIG_ENDIAN};
            Header header = Header.Companion.parseNextSniffingByteOrder(headerBuffer, $i$a$-apply-OCHeaderMaps$readFromChannel$headerBuffer$22);
            if (header == null) {
                return null;
            }
            Header header2 = header;
            IntBuffer bucketsBuffer = OCHeaderMapsHelpersKt.read(channel, header2.getBucketsBytes()).order(headerBuffer.order()).asIntBuffer();
            Sequence buckets = SequencesKt.generateSequence(() -> OCHeaderMaps.readFromChannel$lambda$3(bucketsBuffer));
            long stringsOffset = header2.getStringsOffset();
            long stringsBytes = channel.size() - stringsOffset;
            if (stringsBytes < 0L) {
                return null;
            }
            channel.position(stringsOffset);
            ByteBuffer stringsBuffer = OCHeaderMapsHelpersKt.read(channel, OCHeaderMapsHelpersKt.toIntExact(stringsBytes));
            OCMutableHeaderMap oCMutableHeaderMap = OCMutableHeaderMap.Companion.create(header2.getNumEntries(), caseSensitive);
            Intrinsics.checkNotNull((Object)stringsBuffer);
            return OCHeaderMaps.reconstructFrom(oCMutableHeaderMap, header2, (Sequence<Bucket>)buckets, stringsBuffer);
        }
        catch (IOException e) {
            return null;
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    @JvmStatic
    private static final OCMutableHeaderMap reconstructFrom(OCMutableHeaderMap $this$reconstructFrom, Header header, Sequence<Bucket> buckets, ByteBuffer stringsBuffer) {
        OCMutableHeaderMap oCMutableHeaderMap;
        OCMutableHeaderMap $this$reconstructFrom_u24lambda_u247 = oCMutableHeaderMap = $this$reconstructFrom;
        boolean bl = false;
        Int2ObjectOpenHashMap stringPool = new Int2ObjectOpenHashMap(header.getNumEntries());
        for (Bucket bucket : buckets) {
            String suffix;
            String prefix;
            String key;
            if (OCHeaderMaps.reconstructFrom$lambda$7$getNullTerminatedString(stringsBuffer, (Int2ObjectOpenHashMap<String>)stringPool, bucket.getKey()) == null || OCHeaderMaps.reconstructFrom$lambda$7$getNullTerminatedString(stringsBuffer, (Int2ObjectOpenHashMap<String>)stringPool, bucket.getPrefix()) == null || OCHeaderMaps.reconstructFrom$lambda$7$getNullTerminatedString(stringsBuffer, (Int2ObjectOpenHashMap<String>)stringPool, bucket.getSuffix()) == null) continue;
            $this$reconstructFrom_u24lambda_u247.put(key, prefix + suffix);
        }
        return oCMutableHeaderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void writeToPath(@NotNull Map<String, String> map2, @NotNull Path path, boolean overwrite, @NotNull ByteOrder byteOrder, @Nullable Normalizer.Form forceNormalization, int minCapacity) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        Object object = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW};
        object = Files.newByteChannel(path, object);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            OCHeaderMaps.writeToChannel(map2, it, byteOrder, forceNormalization, minCapacity);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeToPath$default(Map map2, Path path, boolean bl, ByteOrder byteOrder, Normalizer.Form form, int n, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            byteOrder = ByteOrder.nativeOrder();
        }
        if ((n2 & 0x10) != 0) {
            form = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 2;
        }
        OCHeaderMaps.writeToPath(map2, path, bl, byteOrder, form, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void writeToChannel(@NotNull Map<String, String> map2, @NotNull WritableByteChannel channel, @NotNull ByteOrder byteOrder, @Nullable Normalizer.Form forceNormalization, int minCapacity) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        StringPoolBuilder pool = new StringPoolBuilder(Charsets.UTF_8, forceNormalization);
        Ref.IntRef maxValueLength = new Ref.IntRef();
        int bucketsSize = OCHeaderMapsHelpersKt.coerceNextPowerOfTwo(RangesKt.coerceAtLeast((int)(map2.size() + 1), (int)minCapacity));
        int n = 0;
        Object object = new Bucket[bucketsSize];
        while (n < bucketsSize) {
            int n2 = n++;
            object[n2] = Bucket.Companion.getEmpty();
        }
        Bucket[] buckets = object;
        for (String key : CollectionsKt.sorted((Iterable)map2.keySet())) {
            Bucket bucket;
            int valueLengthAcc;
            String suffix;
            String string;
            Object prefix;
            String value;
            if (map2.get(key) == null) continue;
            Object object2 = VfsUtil.getParentDir((String)value);
            if (object2 == null || (object2 = (String)object2 + "/") == null) {
                object2 = prefix = "";
            }
            if ((string = VfsUtil.extractFileName((String)value)) == null) {
                string = suffix = value;
            }
            if ((valueLengthAcc = pool.getLengthForStringAtOffset((bucket = new Bucket(pool.get(key), pool.get((String)prefix), pool.get(suffix))).getPrefix()) + pool.getLengthForStringAtOffset(bucket.getSuffix())) > maxValueLength.element) {
                maxValueLength.element = valueLengthAcc;
            }
            int idx = OCHeaderMapsHelpersKt.toIntExact(OCHeaderMapsHelpersKt.asUnsigned(OCHeaderMaps.hashBucketKey(OCHeaderMapsHelpersKt.asSequence(pool.getBufferForStringAtOffset(bucket.getKey())))) % (long)buckets.length);
            while (buckets[idx] != Bucket.Companion.getEmpty()) {
                idx = (idx + 1) % buckets.length;
            }
            buckets[idx] = bucket;
        }
        Closeable closeable = GenerateByteChannelKt.byteChannel(byteOrder, (Function2<? super ChannelScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ChannelScope, Continuation<? super Unit>, Object>(map2, buckets, maxValueLength, pool, null){
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Map<String, String> $map;
            final /* synthetic */ Bucket[] $buckets;
            final /* synthetic */ Ref.IntRef $maxValueLength;
            final /* synthetic */ StringPoolBuilder $pool;
            {
                this.$map = $map;
                this.$buckets = $buckets;
                this.$maxValueLength = $maxValueLength;
                this.$pool = $pool;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$byteChannel = (ChannelScope)this.L$0;
                        header = new Header(this.$map.size(), this.$buckets.length, this.$maxValueLength.element);
                        var4_5 /* !! */  = $this$byteChannel;
                        $this$emit$iv = header;
                        $i$f$emit = false;
                        this.L$0 = $this$byteChannel;
                        this.L$1 = header;
                        this.label = 1;
                        v0 = $this$emit$iv.emit((ChannelScope)this_$iv, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$f$emit = false;
                        header = (Header)this.L$1;
                        $this$byteChannel = (ChannelScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        var4_5 /* !! */  = this.$buckets;
                        $this$emit$iv = 0;
                        var6_14 = var4_5 /* !! */ .length;
lbl26:
                        // 2 sources

                        while ($this$emit$iv < var6_14) {
                            bucket = var4_5 /* !! */ [$this$emit$iv];
                            var8_16 = $this$byteChannel;
                            $this$emit$iv = bucket;
                            $i$f$emit = false;
                            this.L$0 = $this$byteChannel;
                            this.L$1 = header;
                            this.L$2 = var4_5 /* !! */ ;
                            this.I$0 = $this$emit$iv;
                            this.I$1 = var6_14;
                            this.label = 2;
                            v1 = $this$emit$iv.emit((ChannelScope)this_$iv, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl51
                        }
                        break;
                    }
                    case 2: {
                        $i$f$emit = false;
                        var6_14 = this.I$1;
                        $this$emit$iv = this.I$0;
                        var4_5 /* !! */  = (Bucket[])this.L$2;
                        header = (Header)this.L$1;
                        $this$byteChannel = (ChannelScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl51:
                        // 2 sources

                        ++$this$emit$iv;
                        ** GOTO lbl26
                    }
                }
                v2 = var4_6 = $this$byteChannel.getTotalBytesEmitted() == header.getStringsOffset();
                if (_Assertions.ENABLED && !var4_6) {
                    $this$emit$iv = "Assertion failed";
                    throw new AssertionError((Object)$this$emit$iv);
                }
                this.L$0 = $this$byteChannel;
                this.L$1 = null;
                this.L$2 = null;
                this.label = 3;
                v3 = $this$byteChannel.emit(false, (Continuation<? super Unit>)((Continuation)this));
                if (v3 == var11_2) {
                    return var11_2;
                }
                ** GOTO lbl69
                {
                    case 3: {
                        $this$byteChannel = (ChannelScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl69:
                        // 2 sources

                        var4_7 = this.$pool.getEntries().iterator();
lbl70:
                        // 3 sources

                        while (var4_7.hasNext()) {
                            entry = var4_7.next();
                            this.L$0 = $this$byteChannel;
                            this.L$1 = var4_7;
                            this.label = 4;
                            v4 = $this$byteChannel.emit(entry, (Continuation<? super Unit>)((Continuation)this));
                            if (v4 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl85
                        }
                        break;
                    }
                    case 4: {
                        var4_7 = (Iterator<ByteBuffer>)this.L$1;
                        $this$byteChannel = (ChannelScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl85:
                        // 2 sources

                        this.L$0 = $this$byteChannel;
                        this.L$1 = var4_7;
                        this.label = 5;
                        v5 = $this$byteChannel.emit(false, (Continuation<? super Unit>)((Continuation)this));
                        if (v5 != var11_2) ** GOTO lbl70
                        return var11_2;
                    }
                    case 5: {
                        var4_7 = (Iterator)this.L$1;
                        $this$byteChannel = (ChannelScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        ** GOTO lbl70
                    }
                }
                v6 = var4_8 = $this$byteChannel.getTotalBytesEmitted() == (long)24 + (long)this.$buckets.length * (long)12 + (long)this.$pool.getBytes();
                if (_Assertions.ENABLED && !var4_8) {
                    var5_13 = "Assertion failed";
                    throw new AssertionError((Object)var5_13);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ChannelScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        object = null;
        try {
            ReadableByteChannel it = (ReadableByteChannel)closeable;
            boolean bl = false;
            long l = ByteStreams.copy((ReadableByteChannel)it, (WritableByteChannel)channel);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public static /* synthetic */ void writeToChannel$default(Map map2, WritableByteChannel writableByteChannel, ByteOrder byteOrder, Normalizer.Form form, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byteOrder = ByteOrder.nativeOrder();
        }
        if ((n2 & 8) != 0) {
            form = null;
        }
        if ((n2 & 0x10) != 0) {
            n = 2;
        }
        OCHeaderMaps.writeToChannel(map2, writableByteChannel, byteOrder, form, n);
    }

    @JvmStatic
    private static final int toLowercase(int $this$toLowercase) {
        return (65 <= $this$toLowercase ? $this$toLowercase < 91 : false) ? $this$toLowercase + 97 - 65 : $this$toLowercase;
    }

    @JvmStatic
    @VisibleForTesting
    public static final int hashBucketKey(@NotNull ByteSequence bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int hash = 0;
        int n = bytes.length();
        for (int i = 0; i < n; ++i) {
            hash += OCHeaderMaps.toLowercase(OCHeaderMapsHelpersKt.asUnsigned(bytes.byteAt(i))) * 13;
        }
        return hash;
    }

    public static final boolean getUnsafeDisableMacUnicodeNormalization() {
        return unsafeDisableMacUnicodeNormalization;
    }

    public static final void setUnsafeDisableMacUnicodeNormalization(boolean bl) {
        unsafeDisableMacUnicodeNormalization = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getUnsafeDisableMacUnicodeNormalization$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String normalizeForVFS(@NotNull CharSequence $this$normalizeForVFS) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$normalizeForVFS, (String)"<this>");
        if (INSTANCE.getUseNormalizationFormD()) {
            String string2 = Normalizer.normalize($this$normalizeForVFS, Normalizer.Form.NFC);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
        } else {
            string = ((Object)$this$normalizeForVFS).toString();
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String normalizeForDisk(@NotNull CharSequence $this$normalizeForDisk, @Nullable Normalizer.Form forceNormalization) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeForDisk, (String)"<this>");
        Normalizer.Form form = forceNormalization;
        if (form == null) {
            if (INSTANCE.getUseNormalizationFormD()) {
                form = Normalizer.Form.NFD;
            } else {
                return ((Object)$this$normalizeForDisk).toString();
            }
        }
        Normalizer.Form form2 = form;
        String string = Normalizer.normalize($this$normalizeForDisk, form2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        return string;
    }

    public static /* synthetic */ String normalizeForDisk$default(CharSequence charSequence, Normalizer.Form form, int n, Object object) {
        if ((n & 1) != 0) {
            form = null;
        }
        return OCHeaderMaps.normalizeForDisk(charSequence, form);
    }

    private final boolean getUseNormalizationFormD() {
        if (unsafeDisableMacUnicodeNormalization) {
            return false;
        }
        if (!SystemInfo.isMac) {
            return false;
        }
        if (Runtime.version().feature() < 20) {
            return true;
        }
        String value = System.getProperty("jdk.nio.path.useNormalizationFormD");
        return value != null && (Intrinsics.areEqual((Object)"", (Object)value) || Boolean.parseBoolean(value));
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToPath(@NotNull Map<String, String> map2, @NotNull Path path, boolean overwrite, @NotNull ByteOrder byteOrder, @Nullable Normalizer.Form forceNormalization) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        OCHeaderMaps.writeToPath$default(map2, path, overwrite, byteOrder, forceNormalization, 0, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToPath(@NotNull Map<String, String> map2, @NotNull Path path, boolean overwrite, @NotNull ByteOrder byteOrder) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        OCHeaderMaps.writeToPath$default(map2, path, overwrite, byteOrder, null, 0, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToPath(@NotNull Map<String, String> map2, @NotNull Path path, boolean overwrite) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OCHeaderMaps.writeToPath$default(map2, path, overwrite, null, null, 0, 56, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToPath(@NotNull Map<String, String> map2, @NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OCHeaderMaps.writeToPath$default(map2, path, false, null, null, 0, 60, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToChannel(@NotNull Map<String, String> map2, @NotNull WritableByteChannel channel, @NotNull ByteOrder byteOrder, @Nullable Normalizer.Form forceNormalization) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        OCHeaderMaps.writeToChannel$default(map2, channel, byteOrder, forceNormalization, 0, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToChannel(@NotNull Map<String, String> map2, @NotNull WritableByteChannel channel, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        OCHeaderMaps.writeToChannel$default(map2, channel, byteOrder, null, 0, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void writeToChannel(@NotNull Map<String, String> map2, @NotNull WritableByteChannel channel) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        OCHeaderMaps.writeToChannel$default(map2, channel, null, null, 0, 28, null);
    }

    private static final Bucket readFromChannel$lambda$3(IntBuffer $bucketsBuffer) {
        while ($bucketsBuffer.remaining() >= 3) {
            Intrinsics.checkNotNull((Object)$bucketsBuffer);
            Bucket it = Bucket.Companion.parseNext($bucketsBuffer);
            boolean bl = false;
            if (it == Bucket.Companion.getEmpty()) continue;
            return it;
        }
        return null;
    }

    private static final String reconstructFrom$lambda$7$getNullTerminatedString(ByteBuffer $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString, Int2ObjectOpenHashMap<String> stringPool, int offset) {
        if (!(0 <= offset ? offset <= $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString.limit() : false)) {
            return null;
        }
        String string = (String)stringPool.get(offset);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString.position(offset);
        ByteBuffer $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246 = $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString.slice();
        boolean bl = false;
        while ($this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246.hasRemaining()) {
            String string2;
            byte lastByte = $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246.get();
            if (lastByte != 0) continue;
            $this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246.position($this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246.position() - 1).flip();
            CharBuffer charBuffer = Charsets.UTF_8.decode($this$reconstructFrom_u24lambda_u247_u24getNullTerminatedString_u24lambda_u246);
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"decode(...)");
            String it = string2 = OCHeaderMaps.normalizeForVFS(charBuffer);
            boolean bl2 = false;
            stringPool.put(offset, (Object)it);
            return string2;
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000eH\u0086\u0002J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001bJ\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010$\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/hmap/OCHeaderMaps$StringPoolBuilder;", "", "charset", "Ljava/nio/charset/Charset;", "forceNormalization", "Ljava/text/Normalizer$Form;", "<init>", "(Ljava/nio/charset/Charset;Ljava/text/Normalizer$Form;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getForceNormalization", "()Ljava/text/Normalizer$Form;", "map", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "getMap", "()Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "map2entries", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "getMap2entries", "()Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "entries", "", "Ljava/nio/ByteBuffer;", "getEntries", "()Ljava/util/List;", "value", "", "bytes", "getBytes", "()I", "get", "string", "getBufferForStringAtOffset", "offset", "getLengthForStringAtOffset", "toString", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nOCHeaderMaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCHeaderMaps.kt\ncom/jetbrains/cidr/lang/hmap/OCHeaderMaps$StringPoolBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n1#2:310\n*E\n"})
    private static final class StringPoolBuilder {
        @NotNull
        private final Charset charset;
        @Nullable
        private final Normalizer.Form forceNormalization;
        @NotNull
        private final Object2IntOpenHashMap<String> map;
        @NotNull
        private final Int2IntOpenHashMap map2entries;
        @NotNull
        private final List<ByteBuffer> entries;
        private int bytes;

        public StringPoolBuilder(@NotNull Charset charset, @Nullable Normalizer.Form forceNormalization) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.charset = charset;
            this.forceNormalization = forceNormalization;
            this.map = new Object2IntOpenHashMap();
            this.map2entries = new Int2IntOpenHashMap();
            this.entries = new ArrayList();
            this.bytes = 1;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        @Nullable
        public final Normalizer.Form getForceNormalization() {
            return this.forceNormalization;
        }

        @NotNull
        public final Object2IntOpenHashMap<String> getMap() {
            return this.map;
        }

        @NotNull
        public final Int2IntOpenHashMap getMap2entries() {
            return this.map2entries;
        }

        @NotNull
        public final List<ByteBuffer> getEntries() {
            return this.entries;
        }

        public final int getBytes() {
            return this.bytes;
        }

        public final int get(@NotNull String string) {
            ByteBuffer byteBuffer;
            int n;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int currentOffset = n = this.bytes;
            boolean bl = false;
            if (this.map.containsKey((Object)string)) {
                return this.map.getInt((Object)string);
            }
            this.map.put((Object)string, currentOffset);
            String normalized = OCHeaderMaps.normalizeForDisk(string, this.forceNormalization);
            ByteBuffer $this$get_u24lambda_u241_u24lambda_u240 = byteBuffer = this.charset.encode(normalized);
            boolean bl2 = false;
            this.bytes += $this$get_u24lambda_u241_u24lambda_u240.limit() + 1;
            ByteBuffer buffer = byteBuffer;
            this.map2entries.put(currentOffset, this.entries.size());
            Intrinsics.checkNotNull((Object)buffer);
            this.entries.add(buffer);
            return n;
        }

        @NotNull
        public final ByteBuffer getBufferForStringAtOffset(int offset) {
            return this.entries.get(this.map2entries.get(offset));
        }

        public final int getLengthForStringAtOffset(int offset) {
            return this.getBufferForStringAtOffset(offset).limit();
        }

        @NotNull
        public String toString() {
            String string = this.map.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

