/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hmap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000f\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapWatcher;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/Disposable$Default;", "manager", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapManager;", "<init>", "(Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapManager;)V", "beforeValidityChanged", "", "pointers", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "([Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;)V", "validityChanged", "invalidateFilePointers", "after", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCHeaderMapWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCHeaderMapWatcher.kt\ncom/jetbrains/cidr/lang/hmap/OCHeaderMapWatcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,40:1\n547#2,2:41\n547#2,2:43\n*S KotlinDebug\n*F\n+ 1 OCHeaderMapWatcher.kt\ncom/jetbrains/cidr/lang/hmap/OCHeaderMapWatcher\n*L\n26#1:41,2\n35#1:43,2\n*E\n"})
public final class OCHeaderMapWatcher
implements VirtualFilePointerListener,
BulkFileListener,
Disposable.Default {
    @NotNull
    private final OCHeaderMapManager manager;

    public OCHeaderMapWatcher(@NotNull OCHeaderMapManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        Disposer.register((Disposable)((Disposable)this.manager), (Disposable)((Disposable)this));
        MessageBusConnection messageBusConnection = this.manager.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
        Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
        this.invalidateFilePointers(pointers);
    }

    public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
        Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
        this.invalidateFilePointers(pointers);
    }

    /*
     * WARNING - void declaration
     */
    private final void invalidateFilePointers(VirtualFilePointer[] pointers) {
        void $this$filterTo$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])pointers), OCHeaderMapWatcher::invalidateFilePointers$lambda$0);
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!OCHeaderMapManager.Companion.isHeaderMap(it)) continue;
            destination$iv.add(element$iv);
        }
        HashSet affectedFiles = (HashSet)destination$iv;
        this.manager.invalidateAndResolve(affectedFiles);
    }

    /*
     * WARNING - void declaration
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)events), OCHeaderMapWatcher::after$lambda$2);
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!OCHeaderMapManager.Companion.isHeaderMap(it)) continue;
            destination$iv.add(element$iv);
        }
        HashSet affectedFiles = (HashSet)destination$iv;
        this.manager.invalidateAndResolveExisting(affectedFiles);
    }

    private static final VirtualFile invalidateFilePointers$lambda$0(VirtualFilePointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final VirtualFile after$lambda$2(VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VFileContentChangeEvent vFileContentChangeEvent = it instanceof VFileContentChangeEvent ? (VFileContentChangeEvent)it : null;
        return vFileContentChangeEvent != null ? vFileContentChangeEvent.getFile() : null;
    }
}

