/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateSharedInstanceHandler
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>> {
    @NlsSafe
    private static final String SHARED_INSTANCE_HEADER_TEMPLATE_NAME = "OC Shared Instance Header.h";
    @NlsSafe
    private static final String SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME = "OC Shared Instance Implementation.m";
    @NlsSafe
    private static final String CLASS_TYPE_TEMPLATE_PROPERTY = "CLASS_TYPE";

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("generate.shared.instance.handler.action.title", new Object[0]);
        if (string == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(1);
        }
        return new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(OCResolveContext.forPsi(element), true)){

            @Override
            @NotNull
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }
        };
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> members, OCObjCActionContext<OCMethodSymbol> actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.StaticMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCMethodSymbol> members, @NotNull OCObjCActionContext<OCMethodSymbol> context) {
        String string;
        String templateName;
        if (element == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(2);
        }
        if (members == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(4);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)element.getProject());
        if (element instanceof OCInterface) {
            templateName = SHARED_INSTANCE_HEADER_TEMPLATE_NAME;
        } else if (element instanceof OCImplementation) {
            templateName = SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME;
        } else {
            return "";
        }
        FileTemplate template = fileTemplateManager.getCodeTemplate(templateName);
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)element.getProject()).getDefaultProperties());
        properties.setProperty(CLASS_TYPE_TEMPLATE_PROPERTY, context.getType().getBestNameInContext(element));
        try {
            string = template.getText(properties);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
        }
        if (string == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

