/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCForSurrounder
extends OCStatementSurrounder<OCForStatement> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "for (a) {\n}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCForStatement statement) {
        return statement.getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCForStatement statement) {
        OCStatement inners = statement.getInitializer();
        if (inners == null) {
            return TextRange.EMPTY_RANGE;
        }
        int offset = inners.getTextRange().getStartOffset();
        OCChangeUtil.delete(inners);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return OCBundle.message("surround.with.for.template", new Object[0]);
    }
}

