/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.spellchecker;

import com.intellij.cidr.cpp.lexer.CidrPrefixStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public final class OCSpellCheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final StringLiteralTokenizer STRING_LITERAL_TOKENIZER = new StringLiteralTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof OCMacroForeignLeafElement || element instanceof OCCppUsingStatement || element instanceof OCCppNamespaceQualifier || element instanceof OCQualifiedExpression || element instanceof OCStructLike && !((OCStructLike)element).isDeclaration() || element instanceof PsiComment && ((PsiComment)element).getTokenType() == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                OCSpellCheckerStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        IElementType nodeType = OCElementUtil.getElementType(element);
        if (OCTokenTypes.ALL_STRINGS.contains(nodeType)) {
            StringLiteralTokenizer stringLiteralTokenizer = STRING_LITERAL_TOKENIZER;
            if (stringLiteralTokenizer == null) {
                OCSpellCheckerStrategy.$$$reportNull$$$0(1);
            }
            return stringLiteralTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            OCSpellCheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/spellchecker/OCSpellCheckerStrategy", "getTokenizer"));
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PsiElement> {
        private StringLiteralTokenizer() {
        }

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(1);
            }
            TextRange range = element.getTextRange();
            int stopChar = 34;
            CidrPrefixStringLiteralLexer lexer = new CidrPrefixStringLiteralLexer('\"', OCTokenTypeProvider.INSTANCE.getRAW_STRING_PREFIX_TYPE(), (LexerBase)(OCElementUtil.getElementType(element) == OCTokenTypes.STRING_LITERAL ? OCHighlightingLexer.createStringLiteralLexer((char)'\"', (IElementType)OCTokenTypes.STRING_LITERAL) : OCHighlightingLexer.createRawStringLexer((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE)));
            String elementText = element.getText();
            lexer.start((CharSequence)elementText, 0, range.getEndOffset() - range.getStartOffset());
            StringBuilder sb = new StringBuilder();
            int startOffset = 0;
            while (lexer.getTokenType() != null) {
                IElementType tt = lexer.getTokenType();
                String text = elementText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tt)) {
                    StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
                } else if (tt == OCTokenTypes.STRING_LITERAL) {
                    if (sb.length() == 0) {
                        startOffset = lexer.getTokenStart();
                    }
                    sb.append(text);
                } else {
                    StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
                }
                lexer.advance();
            }
            StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
        }

        private static void consumeCollectedText(@NotNull PsiElement element, @NotNull TokenConsumer consumer, @NotNull StringBuilder sb, int startOffset) {
            if (element == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(3);
            }
            if (sb == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(4);
            }
            if (sb.length() != 0) {
                String textToCheck = sb.toString();
                consumer.consumeToken(element, textToCheck, false, startOffset, TextRange.allOf((String)textToCheck), (Splitter)PlainTextSplitter.getInstance());
                sb.setLength(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/editor/spellchecker/OCSpellCheckerStrategy$StringLiteralTokenizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tokenize";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeCollectedText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

