/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultStatementWithExpressionFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (editor == null) {
            DefaultStatementWithExpressionFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            DefaultStatementWithExpressionFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            DefaultStatementWithExpressionFixer.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof OCStatementWithExpression) {
            OCStatementWithExpression conditionalStatement = (OCStatementWithExpression)psiElement;
            if (!(psiElement instanceof OCDoWhileStatement || psiElement instanceof OCForStatement || psiElement instanceof OCForeachStatement || DefaultStatementWithExpressionFixer.hasMacroBasedStatement(psiElement, conditionalStatement.getKeywordType()))) {
                Document doc = editor.getDocument();
                ASTNode rParenth = conditionalStatement.getRParenth();
                ASTNode lParenth = conditionalStatement.getLParenth();
                PsiElement condition = conditionalStatement.getExpression();
                if (lParenth == null) {
                    ASTNode dogNode;
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset()));
                    OCStatement block = conditionalStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(block).getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(conditionalStatement).getEndOffset());
                    Object prefix = "";
                    if (OCTokenTypes.KEYWORDS_WITH_AT.contains((IElementType)conditionalStatement.getKeywordType()) && (dogNode = psiElement.getNode().findChildByType((IElementType)OCElementTypes.OBJC_KEYWORD)) != null) {
                        prefix = "@";
                    }
                    prefix = (String)prefix + conditionalStatement.getKeywordType().getName() + " (";
                    doc.replaceString(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset(), stopOffset, (CharSequence)((String)prefix + ")"));
                    processor2.registerUnresolvedError(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset() + ((String)prefix).length());
                } else {
                    DefaultStatementWithExpressionFixer.fixConditionIfNeed(editor, processor2, lParenth, condition, rParenth);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/smartEnter/DefaultStatementWithExpressionFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

