/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TemplateInsertHandler
implements InsertHandler<LookupElement> {
    @NonNls
    protected static final String TEMPLATE_REGEX = "\\n|(<caret>)|(<#(.*)#>)";
    private final String myInsertion;

    protected TemplateInsertHandler(String insertion) {
        this.myInsertion = insertion;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String caretToken;
        int caretOffset;
        char currentChar;
        if (context == null) {
            TemplateInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            TemplateInsertHandler.$$$reportNull$$$0(1);
        }
        Document document = context.getDocument();
        Editor editor = context.getEditor();
        Object insertion = TemplateInsertHandler.preprocessInsertion(context, this.myInsertion);
        int tailOffset = context.getStartOffset() + ((String)insertion).length();
        char c = currentChar = context.getTailOffset() < document.getTextLength() ? document.getCharsSequence().charAt(context.getTailOffset()) : (char)'\u0000';
        if (((String)insertion).endsWith(" ") && context.getCompletionChar() != ' ' && (currentChar == ')' || currentChar == ' ' || currentChar == '\t')) {
            insertion = ((String)insertion).trim();
        }
        if ((caretOffset = ((String)insertion).indexOf(caretToken = "<caret>")) != -1) {
            insertion = ((String)insertion).substring(0, caretOffset) + ((String)insertion).substring(caretOffset + caretToken.length());
            tailOffset = context.getStartOffset() + caretOffset;
        } else if (!Character.isWhitespace(currentChar) && !Character.isUnicodeIdentifierPart(currentChar) && ((String)insertion).endsWith(Character.toString(currentChar)) && currentChar != ')') {
            insertion = ((String)insertion).substring(0, ((String)insertion).length() - 1);
        }
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        context.setTailOffset(tailOffset);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document.getText();
        int firstParamStart = documentText.indexOf("<#", context.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        this.reformatAfterInsertion(context, (String)insertion, tailOffset);
        if (firstParamStart >= 0 && firstParamEnd >= 0 && selectionModel.hasSelection()) {
            editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart());
        } else if (context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            int toOffset = context.getTailOffset();
            editor.getCaretModel().moveToOffset(toOffset);
            if (toOffset > 0 && editor.getDocument().getCharsSequence().charAt(toOffset - 1) == '\n') {
                CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(editor.getDocument(), toOffset);
            }
        }
        if (context.getCompletionChar() == ' ') {
            context.setAddCompletionChar(false);
        }
    }

    protected void reformatAfterInsertion(@NotNull InsertionContext context, @NotNull String insertion, int caretOffset) {
        if (context == null) {
            TemplateInsertHandler.$$$reportNull$$$0(2);
        }
        if (insertion == null) {
            TemplateInsertHandler.$$$reportNull$$$0(3);
        }
        if (!insertion.endsWith(" ")) {
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
        }
    }

    public static String preprocessInsertion(InsertionContext context, String insertion) {
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)context.getFile());
        CommonCodeStyleSettings common = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings custom = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FOR_KEYWORD, common.SPACE_BEFORE_FOR_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.IF_KEYWORD, common.SPACE_BEFORE_IF_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.WHILE_KEYWORD, common.SPACE_BEFORE_WHILE_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SWITCH_KEYWORD, common.SPACE_BEFORE_SWITCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.CATCH_KEYWORD, common.SPACE_BEFORE_CATCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FINALLY_KEYWORD, common.SPACE_BEFORE_FINALLY_KEYWORD);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SYNCHRONIZED_KEYWORD, common.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.PROPERTY_KEYWORD, custom.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES);
        return insertion;
    }

    private static String checkKeyword(String insertion, OCElementType keyword, boolean space) {
        if (insertion.equals(keyword.getName())) {
            return space ? keyword.getName() + " " : keyword.getName();
        }
        return insertion;
    }

    public static LookupElementBuilder lookup(String template) {
        String data = template.replaceAll(TEMPLATE_REGEX, "").trim();
        return TemplateInsertHandler.lookup(data, template);
    }

    public static LookupElementBuilder lookup(String userString, String template) {
        return LookupElementBuilder.create((Object)new TemplateObject(userString), (String)userString).withInsertHandler((InsertHandler)new TemplateInsertHandler(template));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertion";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/TemplateInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatAfterInsertion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TemplateObject {
        @NotNull
        private final String myData;

        public TemplateObject(@NotNull String data) {
            if (data == null) {
                TemplateObject.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        public String toString() {
            return this.myData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateObject object = (TemplateObject)o;
            return this.myData.equals(object.myData);
        }

        public int hashCode() {
            return this.myData.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/cidr/lang/editor/completion/TemplateInsertHandler$TemplateObject", "<init>"));
        }
    }
}

