/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    @Nullable
    private PsiElement myContextExpression;
    private String myInsertion;

    FunctionInsertHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression) {
        if (symbol == null) {
            FunctionInsertHandler.$$$reportNull$$$0(0);
        }
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
    }

    public static void changeQualifyingTokenIfNeeded(InsertionContext context, PsiElement contextExpression, LookupElement item) {
        if (contextExpression instanceof OCQualifiedExpression) {
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)contextExpression;
            OCUsageTriggerCollector.COMPLETION_QUALIFIED.log();
            OCPunctuatorElementType actualToken = qualifiedExpression.getQualifyingTokenKind();
            OCPunctuatorElementType completionToken = (OCPunctuatorElementType)OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.get((UserDataHolder)item);
            if (!qualifiedExpression.canChangeQualifyingToken() || completionToken == null || completionToken == actualToken) {
                return;
            }
            Document document = context.getDocument();
            OCElement qualifyingElement = qualifiedExpression.getQualifyingElement();
            TextRange range = OCElementUtil.getUserVisibleRangeInDocument(qualifyingElement);
            if (range != null) {
                OCUsageTriggerCollector.QualifyToken qualifyToken = actualToken == OCTokenTypes.DOT ? OCUsageTriggerCollector.QualifyToken.DOT : OCUsageTriggerCollector.QualifyToken.DEREFERENCE;
                OCUsageTriggerCollector.COMPLETION_QUALIFYING_TOKEN.log((Object)qualifyToken);
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)completionToken.getName());
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            }
        }
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            FunctionInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            FunctionInsertHandler.$$$reportNull$$$0(2);
        }
        if (FunctionInsertHandler.isUsedAsAName(this.mySymbol, this.myContextExpression)) {
            return;
        }
        boolean hasParams = !this.mySymbol.getParameterSymbols().isEmpty();
        boolean isCudaKernel = this.mySymbol.isCudaKernel();
        if (isCudaKernel) {
            CallableInsertUtils.addKernel(context);
        }
        CallableInsertUtils.addParensIfRequired(context, item, hasParams);
        if (hasParams && CallableInsertUtils.shouldInsertPlaceholders(context)) {
            assert (this.myInsertion != null);
            context.getDocument().insertString(context.getEditor().getCaretModel().getOffset(), (CharSequence)this.myInsertion);
            CallableInsertUtils.selectFirstPlaceholderIfPresent(context);
        }
        FunctionInsertHandler.changeQualifyingTokenIfNeeded(context, this.myContextExpression, item);
        if (hasParams) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
        if (isCudaKernel) {
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset() - 5);
        }
    }

    public void calculateInsertion(@NotNull OCResolveContext context) {
        if (context == null) {
            FunctionInsertHandler.$$$reportNull$$$0(3);
        }
        StringBuilder insertion = new StringBuilder();
        List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
        int paramCount = params.size();
        if (params.isEmpty()) {
            return;
        }
        boolean mergeLast = this.mySymbol.isVararg() && params.get(paramCount - 1).isUnnamed();
        int varargIdx = mergeLast ? paramCount - 1 : Integer.MAX_VALUE;
        int firstTemplateStart = -1;
        int firstTemplateEnd = -1;
        for (int i = 0; i < paramCount; ++i) {
            OCDeclaratorSymbol param = params.get(i);
            OCType type = param.getType();
            if (type instanceof OCVoidType) continue;
            if (i > 0) {
                insertion.append(", ");
            }
            if (i == 0 || i < varargIdx) {
                if (firstTemplateStart == -1) {
                    firstTemplateStart = insertion.length();
                }
                insertion.append("<#");
            }
            if (i == varargIdx) {
                insertion.append("...");
            } else {
                insertion.append(param.getType().getBestNameInContext(context));
                if (!param.isUnnamed()) {
                    insertion.append(' ');
                    insertion.append(param.getName());
                }
            }
            if (i == varargIdx - 1) continue;
            insertion.append("#>");
            if (firstTemplateEnd != -1) continue;
            firstTemplateEnd = insertion.length();
        }
        this.myInsertion = insertion.toString();
    }

    private static boolean isUsedAsAName(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement context) {
        if (symbol == null) {
            FunctionInsertHandler.$$$reportNull$$$0(4);
        }
        if (context != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof OCExpression) {
                PsiElement superParent = parent.getParent();
                if (superParent instanceof OCUnaryExpression) {
                    return ((OCUnaryExpression)superParent).isGetAddress();
                }
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes((OCExpression)parent, false, resolveContext);
                for (OCType type : types) {
                    OCFunctionType ft;
                    OCType oCType;
                    if (!((type = type.resolve(resolveContext)) instanceof OCPointerType) || !((oCType = ((OCPointerType)type).getRefType()) instanceof OCFunctionType) || (ft = (OCFunctionType)oCType).checkCompatible(symbol.getResolvedType(resolveContext), null, context, resolveContext).getState() != OCTypeCheckState.OK) continue;
                    return true;
                }
            } else if (parent instanceof OCCppUsingStatement) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/FunctionInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateInsertion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsAName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

