/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.settings.OCCodeFoldingSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFoldingBuilder
extends CustomFoldingBuilder {
    private static final Set<? extends IElementType> INCLUDE_ELEMENT_TYPES = Set.of(OCElementTypes.IMPORT_DIRECTIVE, OCElementTypes.IMPORT_MODULE_STATEMENT);

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            OCFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            OCFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            OCFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!DumbService.isDumb((Project)root.getProject())) {
            ASTNode node = root.getNode();
            if (node != null) {
                OCFoldingBuilder.appendDescriptors(node, document, descriptors);
            }
        } else {
            OCLog.LOG.error("Folding builder was called in dumb mode!");
        }
    }

    @NotNull
    private static Pair<ASTNode, Integer> nodeStart(@Nullable ASTNode node) {
        Pair pair = Pair.create((Object)node, (Object)1);
        if (pair == null) {
            OCFoldingBuilder.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    private static Pair<ASTNode, Integer> nodeEnd(@Nullable ASTNode node) {
        Pair pair = Pair.create((Object)node, (Object)-1);
        if (pair == null) {
            OCFoldingBuilder.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    private static ASTNode appendDescriptors(@NotNull ASTNode node, @NotNull Document document, @NotNull List<FoldingDescriptor> descriptors) {
        IElementType type;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (document == null) {
            OCFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            OCFoldingBuilder.$$$reportNull$$$0(7);
        }
        if ((type = node.getElementType()) == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION) {
            ASTNode body = node.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(body), OCFoldingBuilder.nodeEnd(body), FoldingCondition.NOT_EMPTY_SEVERAL_LINES);
        } else if (type == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            ASTNode template = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(node);
            if (OCElementUtil.getElementType(template) == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(template), OCFoldingBuilder.nodeEnd(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (OCElementTypes.STRUCTURE_TYPES.contains(type) || type == OCElementTypes.CPP_NAMESPACE) {
            ASTNode start = node.findChildByType((IElementType)OCTokenTypes.LBRACE);
            end = node.findChildByType((IElementType)OCTokenTypes.RBRACE);
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(start), OCFoldingBuilder.nodeEnd(end), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
        } else if (OCElementTypes.CLASSES.contains(type)) {
            if (document.getLineNumber(node.getStartOffset()) != document.getLineNumber(node.getTextRange().getEndOffset())) {
                Pair<ASTNode, Integer> startPair;
                if (type == OCElementTypes.INTERFACE) {
                    for (start = node.findChildByType((IElementType)OCElementTypes.INSTANCE_VARIABLES_LIST); start != null && start.getTreePrev() != null && OCFoldingBuilder.isUnimportantNode(start.getTreePrev()); start = start.getTreePrev()) {
                    }
                    startPair = OCFoldingBuilder.nodeStart(start);
                } else {
                    start = node.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
                    startPair = OCFoldingBuilder.nodeEnd(start);
                }
                end = OCElementUtil.findObjCKeyword(node, (IElementType)OCTokenTypes.END_KEYWORD);
                if (end != null) {
                    end = end.getTreeParent();
                }
                OCFoldingBuilder.registerRange(document, node, descriptors, startPair, OCFoldingBuilder.nodeStart(end), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (type == OCElementTypes.INSTANCE_VARIABLES_LIST || type == OCElementTypes.TEMPLATE_ARGUMENT_LIST || type == OCTokenTypes.BLOCK_COMMENT || type == OCTokenTypes.RAW_STRING_LITERAL) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.NOT_EMPTY_SEVERAL_LINES);
        } else if (type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.ALWAYS);
        } else if (INCLUDE_ELEMENT_TYPES.contains(type)) {
            firstChildNode = node.getFirstChildNode();
            if (firstChildNode != null) {
                return OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, INCLUDE_ELEMENT_TYPES, (Pair<ASTNode, Integer>)Pair.create((Object)firstChildNode, (Object)-2), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (type == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            firstChildNode = node.getFirstChildNode();
            if (firstChildNode != null) {
                return OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, Collections.singleton(OCElementTypes.SYNTHESIZED_PROPERTIES_LIST), (Pair<ASTNode, Integer>)Pair.create((Object)firstChildNode, (Object)-2), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (type == OCTokenTypes.EOL_COMMENT) {
            if (node.getTreeParent().getElementType() instanceof IFileElementType) {
                return OCFoldingBuilder.collapseConsequentNodesOfSpecifiedType(document, node, descriptors, Collections.singleton(OCTokenTypes.EOL_COMMENT), OCFoldingBuilder.nodeStart(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
            }
        } else if (type == OCTokenTypes.TEMPLATE_START_MARK) {
            ASTNode stop;
            ASTNode parent = node.getTreeParent();
            if (parent.getTextLength() > 0 && (stop = parent.findChildByType((IElementType)OCTokenTypes.TEMPLATE_STOP_MARK, node)) != null) {
                descriptors.add(new FoldingDescriptor(parent, TextRange.create((int)node.getStartOffset(), (int)(stop.getStartOffset() + stop.getTextLength())), null, Collections.emptySet(), true));
            }
        } else if (type == OCElementTypes.MESSAGE_EXPRESSION || type == OCElementTypes.MACRO_CALL) {
            OCLocalizedString localizedString = OCFoldingBuilder.getLocalizedString(node);
            if (localizedString != null) {
                OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.ALWAYS, Collections.singleton(localizedString.getContainingFile()));
            }
        } else if (type == OCElementTypes.NS_ARRAY_LITERAL || type == OCElementTypes.NS_DICTIONARY_LITERAL || type == OCElementTypes.BLOCK_EXPRESSION) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES);
        } else if (Registry.is((String)"cidr.enable.show.block.folding") && OCElementTypes.BLOCK_STATEMENTS.contains(type)) {
            OCFoldingBuilder.registerRange(document, node, descriptors, OCFoldingBuilder.nodeStart(node), OCFoldingBuilder.nodeEnd(node), FoldingCondition.NOT_EMPTY_SEVERAL_LINES);
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            child = OCFoldingBuilder.appendDescriptors(child, document, descriptors).getTreeNext();
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            OCFoldingBuilder.$$$reportNull$$$0(8);
        }
        return aSTNode;
    }

    private static boolean isUnimportantNode(@NotNull ASTNode node) {
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(9);
        }
        return OCTokenTypes.COMMENTS.contains(node.getElementType()) || node instanceof PsiWhiteSpace || node.getTextLength() == 0;
    }

    @Nullable
    private static OCLocalizedString getLocalizedString(@NotNull ASTNode node) {
        OCStringResourceReference stringRef;
        PsiReference ref;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((ref = OCElementUtil.findReferenceInMacroCall(node.getPsi(), null)) instanceof OCStringResourceReference && (stringRef = (OCStringResourceReference)ref).areAllLanguagesLocalized()) {
            return (OCLocalizedString)stringRef.resolve();
        }
        return null;
    }

    private static void registerRange(@NotNull Document document, @NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull Pair<ASTNode, Integer> start, @NotNull Pair<ASTNode, Integer> end, @NotNull FoldingCondition foldingCondition) {
        if (document == null) {
            OCFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (descriptors == null) {
            OCFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (start == null) {
            OCFoldingBuilder.$$$reportNull$$$0(14);
        }
        if (end == null) {
            OCFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (foldingCondition == null) {
            OCFoldingBuilder.$$$reportNull$$$0(16);
        }
        OCFoldingBuilder.registerRange(document, node, descriptors, start, end, foldingCondition, Collections.emptySet());
    }

    private static void registerRange(@NotNull Document document, @NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull Pair<ASTNode, Integer> start, @NotNull Pair<ASTNode, Integer> end, @NotNull FoldingCondition foldingCondition, @NotNull Set<Object> dependencies) {
        if (document == null) {
            OCFoldingBuilder.$$$reportNull$$$0(17);
        }
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(18);
        }
        if (descriptors == null) {
            OCFoldingBuilder.$$$reportNull$$$0(19);
        }
        if (start == null) {
            OCFoldingBuilder.$$$reportNull$$$0(20);
        }
        if (end == null) {
            OCFoldingBuilder.$$$reportNull$$$0(21);
        }
        if (foldingCondition == null) {
            OCFoldingBuilder.$$$reportNull$$$0(22);
        }
        if (dependencies == null) {
            OCFoldingBuilder.$$$reportNull$$$0(23);
        }
        int posStart = OCFoldingBuilder.getOffsetPosition(start);
        int posEnd = OCFoldingBuilder.getOffsetPosition(end);
        int length = posEnd - posStart;
        int docLength = document.getTextLength();
        if (posStart < 0 || posStart > docLength || posEnd < 0 || posEnd > docLength || length <= 0) {
            return;
        }
        boolean needFolding = false;
        switch (foldingCondition) {
            case LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES: {
                needFolding = length > 5;
            }
            case NOT_EMPTY_SEVERAL_LINES: {
                needFolding |= length > 1 && document.getLineNumber(posStart) != document.getLineNumber(posEnd);
                break;
            }
            case ALWAYS: {
                needFolding = true;
            }
        }
        if (needFolding) {
            FoldingDescriptor foldingDescriptor = new FoldingDescriptor(node, TextRange.create((int)posStart, (int)posEnd), null, dependencies);
            foldingDescriptor.setCanBeRemovedWhenCollapsed(node.getElementType() == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT);
            descriptors.add((FoldingDescriptor)foldingDescriptor);
        }
    }

    private static int getOffsetPosition(@NotNull Pair<ASTNode, Integer> anchorNode) {
        ASTNode maybeSpace;
        ASTNode leaf;
        ASTNode node;
        if (anchorNode == null) {
            OCFoldingBuilder.$$$reportNull$$$0(24);
        }
        if ((node = (ASTNode)anchorNode.first) == null || (Integer)anchorNode.second == 0) {
            return -1;
        }
        ASTNode aSTNode = leaf = (Integer)anchorNode.second > 0 ? OCFormatterUtil.firstLeaf(node) : OCFormatterUtil.lastLeaf(node);
        if (leaf instanceof OCMacroForeignLeafElement) {
            return -1;
        }
        if (leaf == null) {
            leaf = node;
        } else if ((Integer)anchorNode.second > 0 && OCCodeFoldingSettings.getInstance().isCollapseNewLineBeforeLBrace() && OCElementUtil.getElementType(leaf) == OCTokenTypes.LBRACE && OCElementUtil.getElementType(maybeSpace = TreeUtil.prevLeaf((ASTNode)((ASTNode)anchorNode.first))) == TokenType.WHITE_SPACE && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(TreeUtil.prevLeaf((ASTNode)maybeSpace))) && maybeSpace.textContains('\n') && (!OCElementTypes.BLOCK_STATEMENTS.contains(((ASTNode)anchorNode.first).getElementType()) || OCElementUtil.getElementType(TreeUtil.prevLeaf((ASTNode)maybeSpace)) != OCTokenTypes.SEMICOLON)) {
            leaf = maybeSpace;
        }
        TextRange range = leaf.getTextRange();
        return ((Integer)anchorNode.second > 0 ? range.getStartOffset() + 1 : range.getEndOffset() - 1) - (Integer)anchorNode.second;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType tt;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(25);
        }
        if (range == null) {
            OCFoldingBuilder.$$$reportNull$$$0(26);
        }
        if (OCElementTypes.CLASSES.contains(tt = node.getElementType()) || INCLUDE_ELEMENT_TYPES.contains(tt) || tt == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return "...";
        }
        if (tt == OCTokenTypes.BLOCK_COMMENT) {
            return node instanceof PsiDocCommentBase ? "/**...*/" : "/.../";
        }
        if (tt == OCTokenTypes.EOL_COMMENT) {
            return "//...";
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            return "@[...]";
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            return "@{...}";
        }
        if (tt == OCTokenTypes.RAW_STRING_LITERAL) {
            return "\"...\"";
        }
        if (tt == OCElementTypes.BLOCK_EXPRESSION) {
            OCTypeElement returnType = ((OCBlockExpression)node.getPsi()).getReturnTypeElement();
            OCParameterList paramList = ((OCBlockExpression)node.getPsi()).getParameterList();
            return "^" + (returnType != null ? returnType.getTextWithMacros() : "") + (paramList != null ? paramList.getTextWithMacros() : "") + "{...}";
        }
        if (tt == OCElementTypes.LITERAL_EXPRESSION || tt == OCElementTypes.MACRO_DEFINITION || tt == OCElementTypes.DECLARATOR) {
            int from = range.getStartOffset() - node.getStartOffset();
            String substring = node.getText().substring(from, from + range.getLength());
            String result = StringUtil.trimStart((String)StringUtil.trimEnd((String)substring, (String)"#>"), (String)"<#");
            return result.isEmpty() ? "{...}" : result;
        }
        if (tt == OCElementTypes.MESSAGE_EXPRESSION || tt == OCElementTypes.MACRO_CALL) {
            OCLocalizedString pair = OCFoldingBuilder.getLocalizedString(node);
            if (pair != null) {
                return "@\"" + pair.getEscapedValue() + "\"";
            }
        } else {
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                return OCFoldingBuilder.getTemplateParamsText(node);
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                return "<~>";
            }
            if (tt == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                return "...";
            }
        }
        return OCFoldingBuilder.getLanguagePlaceholderText(node, (Segment)range, "{...}");
    }

    private static String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull Segment range, @NotNull String foldingText) {
        PsiElement maybeSpace;
        PsiFile file;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(27);
        }
        if (range == null) {
            OCFoldingBuilder.$$$reportNull$$$0(28);
        }
        if (foldingText == null) {
            OCFoldingBuilder.$$$reportNull$$$0(29);
        }
        if ((file = node.getPsi().getContainingFile()) != null && (maybeSpace = file.findElementAt(range.getStartOffset())) instanceof PsiWhiteSpace && maybeSpace.textContains('\n')) {
            return " " + foldingText;
        }
        return foldingText;
    }

    @NotNull
    private static String getTemplateParamsText(@NotNull ASTNode node) {
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(30);
        }
        StringBuilder builder = new StringBuilder();
        ASTNode leaf = OCFormatterUtil.firstLeaf(node);
        boolean afterPunctuator = false;
        while (leaf != null) {
            IElementType tt = leaf.getElementType();
            if (!(leaf instanceof OCMacroForeignLeafElement) && !OCFormatterUtil.isInessential(leaf) && tt != OCTokenTypes.TYPENAME_CPP_KEYWORD && tt != OCTokenTypes.CLASS_KEYWORD) {
                boolean punctuator = tt instanceof OCPunctuatorElementType;
                if (!afterPunctuator && !punctuator && builder.length() != 0) {
                    builder.append(' ');
                }
                afterPunctuator = punctuator;
                builder.append(leaf.getText());
            }
            leaf = OCFormatterUtil.nextLeafInOwner(leaf, node);
        }
        String string = builder.toString();
        if (string == null) {
            OCFoldingBuilder.$$$reportNull$$$0(31);
        }
        return string;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(32);
        }
        OCCodeFoldingSettings settings = OCCodeFoldingSettings.getInstance();
        IElementType type = node.getElementType();
        if (INCLUDE_ELEMENT_TYPES.contains(type)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        if (type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            return settings.isCollapseConditionallyNotCompiled();
        }
        if (type == OCTokenTypes.BLOCK_COMMENT || type == OCTokenTypes.EOL_COMMENT) {
            return settings.isCollapseMultilineComments();
        }
        if (type == OCElementTypes.METHOD || type == OCElementTypes.FUNCTION_DEFINITION) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        if (type == OCElementTypes.INSTANCE_VARIABLES_LIST) {
            return settings.isCollapseIvars();
        }
        if (type == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
            return settings.isCollapseSynthesizes();
        }
        if (type == OCElementTypes.LITERAL_EXPRESSION || type == OCElementTypes.MESSAGE_EXPRESSION || type == OCElementTypes.MACRO_CALL) {
            return settings.isCollapseLocalizedStrings();
        }
        if (type == OCElementTypes.BLOCK_EXPRESSION) {
            return settings.isCollapseBlockExpressions();
        }
        if (type == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            return settings.isCollapseTemplateParamList();
        }
        return false;
    }

    @NotNull
    private static ASTNode collapseConsequentNodesOfSpecifiedType(@NotNull Document document, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<? extends IElementType> elementTypes, @NotNull Pair<ASTNode, Integer> start, @NotNull FoldingCondition foldingCondition) {
        PsiElement firstElement;
        if (document == null) {
            OCFoldingBuilder.$$$reportNull$$$0(33);
        }
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(34);
        }
        if (descriptors == null) {
            OCFoldingBuilder.$$$reportNull$$$0(35);
        }
        if (elementTypes == null) {
            OCFoldingBuilder.$$$reportNull$$$0(36);
        }
        if (start == null) {
            OCFoldingBuilder.$$$reportNull$$$0(37);
        }
        if (foldingCondition == null) {
            OCFoldingBuilder.$$$reportNull$$$0(38);
        }
        PsiElement lastElement = firstElement = node.getPsi();
        PsiElement current = lastElement.getNextSibling();
        boolean hasErrors = false;
        boolean containsCustomRegionMarker = OCFoldingBuilder.isCustomRegionElement((PsiElement)firstElement);
        if (firstElement instanceof OCIncludeDirective && !((OCIncludeDirective)firstElement).isValidDirective()) {
            hasErrors = true;
        }
        while (current != null) {
            IElementType type;
            while (current instanceof PsiWhiteSpace) {
                current = current.getNextSibling();
            }
            if (current instanceof OCIncludeDirective && !((OCIncludeDirective)current).isValidDirective()) {
                hasErrors = true;
            }
            if ((type = OCElementUtil.getElementType(current)) == null || !elementTypes.contains(type)) break;
            lastElement = current;
            current = current.getNextSibling();
            containsCustomRegionMarker |= OCFoldingBuilder.isCustomRegionElement((PsiElement)lastElement);
        }
        if (lastElement != firstElement) {
            ASTNode lastElementNode = lastElement.getNode();
            if (!hasErrors && !containsCustomRegionMarker) {
                Pair<ASTNode, Integer> end = OCFoldingBuilder.nodeEnd(lastElementNode);
                OCFoldingBuilder.registerRange(document, node, descriptors, start, end, foldingCondition);
            }
            ASTNode aSTNode = lastElementNode;
            if (aSTNode == null) {
                OCFoldingBuilder.$$$reportNull$$$0(39);
            }
            return aSTNode;
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            OCFoldingBuilder.$$$reportNull$$$0(40);
        }
        return aSTNode;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(41);
        }
        return (psi = node.getPsi()) instanceof PsiFile || psi instanceof OCBlockStatement;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            OCFoldingBuilder.$$$reportNull$$$0(42);
        }
        return (psi = node.getPsi()) instanceof OCPragma || psi instanceof PsiComment;
    }

    public boolean isDumbAware() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 31, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 31: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCFoldingBuilder";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 18: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 16: 
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingCondition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorNode";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingText";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCFoldingBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeStart";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeEnd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendDescriptors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParamsText";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 31: 
            case 39: 
            case 40: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnimportantNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalizedString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerRange";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetPosition";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateParamsText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 31, 39, 40 -> new IllegalStateException(string);
        };
    }

    static enum FoldingCondition {
        LONGER_THAN_5CHARS_OR_NOT_EMPTY_SEVERAL_LINES,
        NOT_EMPTY_SEVERAL_LINES,
        ALWAYS;

    }
}

