/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesFinalHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class OCEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    private static final Logger LOG = Logger.getInstance(OCEnterAfterUnmatchedBraceHandler.class);
    private static final EnterBetweenBracesFinalHandler ENTER_BETWEEN_BRACES_HANDLER = new EnterBetweenBracesFinalHandler();

    public boolean isApplicable(@NotNull PsiFile file, int caretOffset) {
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(0);
        }
        return OCLanguageUtils.isSupported(file);
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(2);
        }
        if (caretOffsetRef == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(3);
        }
        if (caretAdvance == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(5);
        }
        if (!OCLanguageUtils.isSupported(language = EnterHandler.getLanguage((DataContext)dataContext))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return OCEnterAfterUnmatchedBraceHandler.isBlockWithSemicolonAtEnd(editor, caretOffsetRef) ? OCEnterAfterUnmatchedBraceHandler.preprocessEnterInsideBraces(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler) : super.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
    }

    private static EnterHandlerDelegate.Result preprocessEnterInsideBraces(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterHandlerDelegate.Result result;
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(7);
        }
        if (caretOffsetRef == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(8);
        }
        if (caretAdvance == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(10);
        }
        return (result = ENTER_BETWEEN_BRACES_HANDLER.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler)) == EnterHandlerDelegate.Result.Continue ? EnterHandlerDelegate.Result.DefaultForceIndent : result;
    }

    private static boolean isBlockWithSemicolonAtEnd(@NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef) {
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(11);
        }
        if (caretOffsetRef == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(12);
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
        it.retreat();
        if (!OCTypedHandlerDelegate.needSemicolonAtContextEnd(it)) {
            return false;
        }
        it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
        while (!it.atEnd()) {
            if (it.getTokenType() == OCTokenTypes.RBRACE) {
                it.advance();
                while (!it.atEnd() && OCTokenTypes.WHITESPACES.contains(it.getTokenType())) {
                    it.advance();
                }
                return !it.atEnd() && it.getTokenType() == OCTokenTypes.SEMICOLON;
            }
            it.advance();
        }
        return false;
    }

    @NotNull
    protected String generateStringToInsert(@NotNull Editor editor, int caretOffset, int maxRBraceCount) {
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(13);
        }
        assert (maxRBraceCount > 0);
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
        StringBuilder generatedRBraces = new StringBuilder(maxRBraceCount);
        while (((LexerEditorHighlighter.HighlighterIteratorImpl)it).currentIndex() >= 0) {
            IElementType currType = it.getTokenType();
            if (currType == OCTokenTypes.LBRACE) {
                it.retreat();
                generatedRBraces.append('}');
                if (!OCTypedHandlerDelegate.needSemicolonAtContextEnd(it)) break;
                generatedRBraces.append(';');
                break;
            }
            if (StringUtil.contains((CharSequence)it.getDocument().getCharsSequence(), (int)it.getStart(), (int)it.getEnd(), (char)'\n') || currType == OCTokenTypes.RBRACE) break;
            it.retreat();
        }
        String string = generatedRBraces.length() == 0 ? "}" : generatedRBraces.toString();
        if (string == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file, @NotNull Document document, @NotNull Editor editor, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(15);
        }
        if (document == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(17);
        }
        try {
            int firstLine = document.getLineNumber(caretOffset + 1);
            int lastLine = document.getLineNumber(rBracesInsertOffset + 2);
            for (int line = firstLine; line <= lastLine; ++line) {
                EnterHandler.adjustLineIndentNoCommit((Language)file.getLanguage(), (Document)document, (Editor)editor, (int)Math.max(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)line), 0));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            document.deleteString(caretOffset, caretOffset + 1);
        }
    }

    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        int fileLength;
        CharSequence text;
        int offset;
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(19);
        }
        if ((offset = CharArrayUtil.shiftForward((CharSequence)(text = editor.getDocument().getCharsSequence()), (int)caretOffset, (String)" \t")) < (fileLength = text.length()) && ")];,%<?".indexOf(text.charAt(offset)) < 0) {
            offset = OCEnterAfterUnmatchedBraceHandler.calculateOffsetToInsertClosingBraceWithLexer(file, editor, text, offset);
        }
        return Math.min(offset, fileLength);
    }

    private static int calculateOffsetToInsertClosingBraceWithLexer(@NotNull PsiFile file, @NotNull Editor editor, @NotNull CharSequence text, int offset) {
        if (file == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(21);
        }
        if (text == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(22);
        }
        HighlighterIterator it = editor.getHighlighter().createIterator(offset);
        while (!it.atEnd() && !OCLineIndentProvider.hasNewLine(text, it)) {
            IElementType type = it.getTokenType();
            if (OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS.contains(type) || type == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                return offset;
            }
            if (type == OCTokenTypes.RBRACE || type == OCTokenTypes.LBRACE) break;
            it.advance();
        }
        if (it.atEnd()) {
            return offset;
        }
        if (OCLineIndentProvider.hasNewLine(text, it)) {
            return OCTokenTypes.WHITESPACES.contains(it.getTokenType()) ? CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)it.getStart(), (String)"\n") : offset;
        }
        if (it.getTokenType() == OCTokenTypes.RBRACE) {
            return OCEnterAfterUnmatchedBraceHandler.checkSemicolonAfterRBrace(it, text);
        }
        if (it.getTokenType() == OCTokenTypes.LBRACE) {
            offset = it.getStart();
            return BraceMatchingUtil.matchBrace((CharSequence)text, (FileType)file.getFileType(), (HighlighterIterator)it, (boolean)true) ? OCEnterAfterUnmatchedBraceHandler.checkSemicolonAfterRBrace(it, text) : offset;
        }
        return it.getStart();
    }

    private static int checkSemicolonAfterRBrace(@NotNull HighlighterIterator it, @NotNull CharSequence text) {
        if (it == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(23);
        }
        if (text == null) {
            OCEnterAfterUnmatchedBraceHandler.$$$reportNull$$$0(24);
        }
        int start = it.getStart();
        int end = it.getEnd();
        it.advance();
        OCLineIndentProvider.skipWhiteSpacesInLine(it, text, true);
        return it.atEnd() || it.getTokenType() == OCTokenTypes.SEMICOLON ? start : end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateStringToInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnterInsideBraces";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBlockWithSemicolonAtEnd";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateStringToInsert";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatCodeFragmentBetweenBraces";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRBraceOffset";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffsetToInsertClosingBraceWithLexer";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSemicolonAfterRBrace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

