/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public final class CompoundJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(CompoundJoinLinesHandler.class);

    private static boolean isInvalidWithoutBraces(PsiElement elem) {
        return elem instanceof OCCatchSection || elem instanceof OCTryStatement || elem instanceof OCLambdaExpression || elem instanceof OCFunctionDefinition || elem instanceof OCRequiresClause;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile psiFile, int start, int end) {
        OCBlockStatement blockStatement;
        if (document == null) {
            CompoundJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            CompoundJoinLinesHandler.$$$reportNull$$$0(1);
        }
        PsiElement elementAtStartLineEnd = psiFile.findElementAt(start);
        PsiElement elementAtNextLineStart = psiFile.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (elementAtStartLineEnd.getNode().getElementType() != OCTokenTypes.LBRACE) {
            return -1;
        }
        PsiElement codeBlock = elementAtStartLineEnd.getParent();
        if (!(codeBlock instanceof OCBlockStatement)) {
            return -1;
        }
        PsiElement parentStatement = codeBlock.getParent();
        if (CompoundJoinLinesHandler.isInvalidWithoutBraces(parentStatement)) {
            return -1;
        }
        if (CompoundJoinLinesHandler.getForceBraceSetting(parentStatement) == 3) {
            return -1;
        }
        if (parentStatement instanceof OCIfStatement && !OCParenthesesUtils.canStripBraces(blockStatement = (OCBlockStatement)codeBlock)) {
            return -1;
        }
        PsiElement foundStatement = null;
        for (PsiElement element = elementAtStartLineEnd.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace || element instanceof OCMacroCall) continue;
            if (element.getNode().getElementType() == OCTokenTypes.RBRACE && element.getParent() == codeBlock) {
                if (foundStatement != null) break;
                return -1;
            }
            if (foundStatement != null) {
                return -1;
            }
            foundStatement = element;
        }
        if (foundStatement == null) {
            return -1;
        }
        try {
            PsiElement newStatement = OCChangeUtil.replaceHandlingMacros(codeBlock, foundStatement);
            return newStatement.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }

    private static int getForceBraceSetting(PsiElement statement) {
        PsiFile codeFile = statement.getContainingFile();
        CommonCodeStyleSettings codeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)codeFile, (Language)codeFile.getLanguage());
        if (statement instanceof OCIfStatement) {
            return codeStyleSettings.IF_BRACE_FORCE;
        }
        if (statement instanceof OCWhileStatement) {
            return codeStyleSettings.WHILE_BRACE_FORCE;
        }
        if (statement instanceof OCForStatement || statement instanceof OCForeachStatement) {
            return codeStyleSettings.FOR_BRACE_FORCE;
        }
        if (statement instanceof OCDoWhileStatement) {
            return codeStyleSettings.DOWHILE_BRACE_FORCE;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/CompoundJoinLinesHandler";
        objectArray[2] = "tryJoinLines";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

