/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInputOutputVariablesFinder
extends OCSingleSymbolAlgorithm {
    private final TextRange mySelection;
    private boolean myInput;

    public OCInputOutputVariablesFinder(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol, @Nullable TextRange selection) {
        if (cfg == null) {
            OCInputOutputVariablesFinder.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCInputOutputVariablesFinder.$$$reportNull$$$0(1);
        }
        super(cfg, false, symbol);
        this.mySelection = selection;
    }

    private boolean isSelected(@NotNull OCInstruction instruction) {
        PsiElement element;
        if (instruction == null) {
            OCInputOutputVariablesFinder.$$$reportNull$$$0(2);
        }
        if ((element = instruction.getRValue()) == null) {
            element = instruction.getLValue();
        }
        if (element == null) {
            return false;
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.WRITE && element instanceof OCExpression) {
            element = element.getParent();
        }
        return this.mySelection.contains(OCElementUtil.getRangeWithMacros(element));
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCInputOutputVariablesFinder.$$$reportNull$$$0(3);
        }
        return switch (instruction.getKind()) {
            case OCInstruction.InstructionKind.READ, OCInstruction.InstructionKind.READ_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE -> {
                if (this.isSelected(instruction)) {
                    OCInstruction declInstruction = this.myCfg.getDeclaratorInstruction(instruction.getSymbol());
                    if (declInstruction != null && !this.isSelected(declInstruction)) {
                        this.myInput = true;
                    }
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCInputOutputVariablesFinder.$$$reportNull$$$0(4);
        }
        if (this.isSelected(instruction)) {
            return switch (instruction.getKind()) {
                case OCInstruction.InstructionKind.REFERENCE, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK -> true;
                case OCInstruction.InstructionKind.DECLARATOR -> {
                    PsiElement declarator = instruction.getRValue();
                    if (declarator instanceof OCDeclarator && ((OCDeclarator)declarator).getResolvedType() instanceof OCStructType) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public boolean isInputVariable() {
        return this.myInput;
    }

    public boolean isOutputVariable() {
        return !this.getReachableElements().isEmpty();
    }

    public boolean isWrittenVariable() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction instruction : instructions.values()) {
            if (!this.isEndInstruction(instruction)) continue;
            return true;
        }
        return false;
    }

    public boolean isEscapedDeclarator() {
        if (!this.mySelection.contains(this.mySymbol.getOffset())) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction instruction : instructions.values()) {
            if (this.isSelected(instruction)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public List<PsiReference> getVariableUsages() {
        PsiElement element = this.mySymbol.locateDefinition(this.myCfg.getCodeFragment().getProject());
        if (element == null) {
            return null;
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope())) {
            if (!this.mySelection.contains(reference.getElement().getTextRange())) continue;
            result.add(reference);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCInputOutputVariablesFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStartInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEndInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

