/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFoldExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCAsmStatementPartImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowBuilder
extends OCVisitor {
    private OCDataFlowAnalyzer myAnalyzer;
    protected OCControlFlowGraph myGraph;
    private TextRange mySelection;
    private final boolean myOptimizeUnreachableNodes;
    private boolean myHasCrossSelectionJumps;
    private boolean myHasTopLevelCaseStatements;
    private List<OCNode> myBreakNodes;
    protected List<OCNode> myContinueNodes;
    private Stack<List<OCNode>> myTryThrows;
    private Stack<Ref<OCNode>> myFirstThrowableNodes;
    private Stack<SwitchInfo> mySwitchStack;
    private Stack<List<PsiElement>> myValuesStack;
    private Map<String, OCNode> myLabeledNodes;
    private MostlySingularMultiMap<String, OCNode> myGotoNodes;
    private int myShortCircuitDepth;
    private static final TokenSet closingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON, OCTokenTypes.RBRACE}), OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCTokenTypes.DIRECTIVES});

    protected OCControlFlowBuilder() {
        this.myOptimizeUnreachableNodes = true;
    }

    public OCControlFlowBuilder(@Nullable OCDataFlowAnalyzer analyzer, @NotNull OCControlFlowGraph graph, @Nullable TextRange selection) {
        if (graph == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this(analyzer, graph, selection, true);
    }

    public OCControlFlowBuilder(@Nullable OCDataFlowAnalyzer analyzer, @NotNull OCControlFlowGraph graph, @Nullable TextRange selection, boolean optimizeUnreachableNodes) {
        if (graph == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(1);
        }
        this.myAnalyzer = analyzer;
        this.mySelection = selection;
        this.myOptimizeUnreachableNodes = optimizeUnreachableNodes;
        this.init(graph);
    }

    protected void init(@NotNull OCControlFlowGraph graph) {
        if (graph == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.myGraph = graph;
        this.myGotoNodes = new MostlySingularMultiMap();
        this.myLabeledNodes = new HashMap<String, OCNode>();
        this.mySwitchStack = new Stack();
        this.myValuesStack = new Stack();
        this.myTryThrows = new Stack();
        this.myFirstThrowableNodes = new Stack();
        this.myContinueNodes = new ArrayList<OCNode>();
        this.myBreakNodes = new ArrayList<OCNode>();
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(3);
        }
        this.getKidIterator(element).acceptAll();
    }

    private KidIterator getKidIterator(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(4);
        }
        final ASTNode firstChild = (node = element.getNode()) != null ? node.getFirstChildNode() : null;
        return new KidIterator(){
            private ASTNode child;
            private boolean initialized;

            @Override
            public void skipLeaves() {
                if (!this.initialized) {
                    this.initialized = true;
                    this.child = firstChild;
                }
                while (!(this.child == null || this.child.getFirstChildNode() != null && this.child.getElementType() != OCElementTypes.OBJC_KEYWORD && OCElementUtil.isElementSignificant(this.child.getPsi()))) {
                    PsiElement psiElement = this.child.getPsi();
                    if (psiElement != null && OCControlFlowBuilder.this.doEnlargeNodes()) {
                        OCNode node = OCControlFlowBuilder.this.myGraph.getLastAddedNode();
                        if (node.isEmpty() && closingTokens.contains(this.child.getElementType())) {
                            OCNode previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            while (previousNode != null && node.getEndOffset() < previousNode.getEndOffset() && previousNode.getEndOffset() <= psiElement.getTextOffset()) {
                                node = previousNode;
                                previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            }
                        }
                        node.enlarge(psiElement, psiElement.getParent());
                    }
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void accept(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    kid.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void skip(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void acceptAll() {
                this.skipLeaves();
                while (this.child != null) {
                    ProgressManager.checkCanceled();
                    PsiElement element = this.child.getPsi();
                    if (element != null) {
                        element.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    }
                    this.child = this.child.getTreeNext();
                    this.skipLeaves();
                }
            }

            @Override
            public void finish() {
                this.skipLeaves();
            }
        };
    }

    protected boolean doEnlargeNodes() {
        return true;
    }

    public void processFirstCodeFragment(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(5);
        }
        this.myTryThrows.push(new ArrayList());
        this.myValuesStack.push(new ArrayList());
        if (OCControlFlowBuilder.isFunctionWithTryBlock(codeFragment)) {
            this.myFirstThrowableNodes.add((Object)Ref.create());
        }
        this.addStartNode(this.myGraph.addNode());
        this.processNextCodeFragment(codeFragment);
    }

    public void processNextCodeFragment(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (codeFragment instanceof OCCallable) {
            this.visitElement(codeFragment);
        } else {
            codeFragment.accept((PsiElementVisitor)this);
        }
    }

    private static boolean isFunctionWithTryBlock(@NotNull PsiElement element) {
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(7);
        }
        if (element instanceof OCCallable) {
            ASTNode astNode = element.getNode();
            return astNode.findChildByType((IElementType)OCElementTypes.CATCH_SECTION) != null;
        }
        return false;
    }

    protected void addStartNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.myGraph.setStartNode(node);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(9);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(10);
        }
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues) {
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(11);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(12);
        }
        return this.addBranch(fromNode, toNode, modifiedValues, null);
    }

    @Nullable
    protected NodeState addUnstructuralBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(13);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(14);
        }
        return this.addBranch(fromNode, toNode, null);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(15);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(16);
        }
        return this.addBranch(fromNode, toNode, null);
    }

    protected OCNode acceptCondition(@Nullable OCElement condition, @NotNull KidIterator itr, boolean isLoop) {
        if (itr == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(17);
        }
        itr.accept(condition);
        itr.skipLeaves();
        return this.myGraph.getLastAddedNode();
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (condition == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(19);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(20);
        }
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (condition == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(21);
        }
        if (fromNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(22);
        }
        if (toNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(23);
        }
        return this.addConditionalBranch(condition, branch, fromNode, toNode, null, null);
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        this.visitIfLike(stmt, stmt.getCondition(), stmt.getThenBranch(), stmt.getElseBranch());
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression) {
        this.visitIfLike(expression, expression.getCondition(), expression.getPositiveExpression(true), expression.getNegativeExpression());
    }

    private void visitIfLike(@NotNull PsiElement element, @Nullable OCElement condition, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(24);
        }
        this.myValuesStack.push(new ArrayList());
        KidIterator itr = this.getKidIterator(element);
        if (element instanceof OCIfStatement) {
            OCIfStatement ifStmt = (OCIfStatement)element;
            itr.accept(ifStmt.getInitStatement());
        }
        OCNode conditionNode = this.acceptCondition(condition, itr, false);
        Number conditionValue = OCControlFlowBuilder.getValueOfCondition(condition);
        boolean needThenBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean needElseBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode thenStartNode = this.myGraph.addNode();
        if (condition != null && (needThenBranch || !this.myOptimizeUnreachableNodes)) {
            this.addConditionalBranch(condition, true, conditionNode, thenStartNode);
        }
        itr.accept(thenBranch);
        OCNode thenFinishNode = this.myGraph.getLastAddedNode();
        OCNode elseStartNode = this.myGraph.addNode();
        if (condition != null && (needElseBranch || !this.myOptimizeUnreachableNodes)) {
            this.addConditionalBranch(condition, false, conditionNode, elseStartNode);
        }
        itr.accept(elseBranch);
        OCNode elseFinishNode = this.myGraph.getLastAddedNode();
        List writes = (List)this.myValuesStack.pop();
        if (conditionNode != this.myGraph.getLastAddedNode()) {
            OCNode exitNode = this.myGraph.addNode();
            this.addBranch(thenFinishNode, exitNode, writes);
            this.addBranch(elseFinishNode, exitNode, writes);
        }
        itr.finish();
    }

    @Nullable
    private static Number getValueOfCondition(@Nullable OCElement conditionElement) {
        OCExpression conditionalExpression = null;
        if (conditionElement instanceof OCExpression) {
            conditionalExpression = (OCExpression)conditionElement;
        } else if (conditionElement instanceof OCCondition) {
            OCCondition condition = (OCCondition)conditionElement;
            OCExpression expression = condition.getExpression();
            if (expression != null) {
                conditionalExpression = expression;
            } else {
                OCDeclaration declaration = condition.getDeclaration();
                if (declaration != null && declaration.getDeclarators().size() != 0) {
                    List<OCDeclarator> declarators = declaration.getDeclarators();
                    conditionalExpression = declarators.get(0).getInitializer();
                }
            }
        }
        return OCExpressionEvaluator.evaluate(conditionalExpression);
    }

    private int @NotNull [] saveLoopState() {
        int[] nArray = new int[]{this.myBreakNodes.size(), this.myContinueNodes.size()};
        if (nArray == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(25);
        }
        return nArray;
    }

    private boolean isSelected(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(26);
        }
        OCElementsRange range = node.getRange();
        return this.mySelection != null && range != null && this.mySelection.contains(range.getTextRange());
    }

    public boolean hasCrossSelectionJumps() {
        return this.myHasCrossSelectionJumps;
    }

    public boolean hasDanglingJumps() {
        return !this.myBreakNodes.isEmpty() || !this.myContinueNodes.isEmpty() || this.myHasTopLevelCaseStatements;
    }

    private void patchLoopJumps(int @NotNull [] savedState, @Nullable OCNode continueToNode, @Nullable OCNode breakToNode, @Nullable List<PsiElement> writes) {
        int i;
        if (savedState == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(27);
        }
        if (breakToNode != null) {
            for (i = this.myBreakNodes.size() - 1; i >= savedState[0]; --i) {
                this.addUnstructuralBranch(this.myBreakNodes.get(i), breakToNode);
                this.myBreakNodes.remove(i);
            }
        }
        if (continueToNode != null) {
            for (i = this.myContinueNodes.size() - 1; i >= savedState[1]; --i) {
                this.addUnstructuralBranch(this.myContinueNodes.get(i), continueToNode);
                this.myContinueNodes.remove(i);
            }
        }
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        this.visitForWhile(stmt, null, stmt.getCondition(), null, stmt.getBody());
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        this.visitForWhile(stmt, stmt.getInitializer(), stmt.getCondition(), stmt.getIncrement(), stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement) {
        OCElement condition = statement.getVariableDeclaration();
        if (condition == null) {
            condition = statement.getVariableExpression();
        }
        this.visitForWhile(statement, condition, statement.getCollectionExpression(), null, statement.getBody());
    }

    private void visitForWhile(@NotNull OCElement element, @Nullable OCElement initializer, @Nullable OCElement condition, @Nullable OCStatement increment, @Nullable OCStatement body) {
        OCNode conditionStartNode;
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(28);
        }
        KidIterator itr = this.getKidIterator(element);
        itr.accept(initializer);
        OCNode enterNode = this.myGraph.getLastAddedNode();
        OCNode continueNode = conditionStartNode = this.myGraph.addNode();
        NodeState condState1 = this.addBranch(enterNode, conditionStartNode);
        this.myValuesStack.push(new ArrayList());
        OCNode conditionEndNode = this.acceptCondition(condition, itr, true);
        boolean foreach = element instanceof OCForeachStatement;
        Number conditionValue = foreach ? (Number)null : (Number)OCControlFlowBuilder.getValueOfCondition(condition);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode bodyStartNode = this.myGraph.addNode();
        if (conditionNotFalse || !this.myOptimizeUnreachableNodes) {
            if (foreach || condition == null) {
                this.addBranch(conditionStartNode, bodyStartNode);
            } else {
                this.addConditionalBranch(condition, true, conditionEndNode, bodyStartNode);
            }
        }
        int[] state = this.saveLoopState();
        itr.skip(increment);
        itr.accept(body);
        OCNode bodyEndNode = this.getLoopBodyEndNode();
        if (increment != null) {
            OCNode incrementNode = this.myGraph.addNode();
            this.addBranch(bodyEndNode, incrementNode);
            increment.accept(this);
            bodyEndNode = this.myGraph.getLastAddedNode();
            continueNode = incrementNode;
        }
        List writes = (List)this.myValuesStack.pop();
        OCNode exitNode = this.myGraph.addNode();
        this.patchLoopJumps(state, continueNode, exitNode, writes);
        NodeState condState2 = this.addBranch(bodyEndNode, conditionStartNode, writes);
        if (conditionNotFalse || !this.myOptimizeUnreachableNodes) {
            if (!Comparing.equal((Object)condState1, (Object)condState2) && condition != null) {
                this.addConditionalBranch(condition, true, conditionEndNode, bodyStartNode, null, condState1);
            } else {
                this.addBranch(conditionEndNode, bodyStartNode, null, condState1);
            }
        }
        if (conditionNotTrue || !this.myOptimizeUnreachableNodes) {
            if (foreach) {
                this.addBranch(conditionStartNode, exitNode);
            } else if (condition != null) {
                this.addConditionalBranch(condition, false, conditionEndNode, exitNode);
            }
        }
        itr.finish();
    }

    protected OCNode getLoopBodyEndNode() {
        return this.myGraph.getLastAddedNode();
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        boolean conditionNotTrue;
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode loopStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, loopStartNode);
        int[] state = this.saveLoopState();
        this.myValuesStack.push(new ArrayList());
        itr.accept(stmt.getBody());
        OCExpression condition = stmt.getCondition();
        OCNode conditionNode = this.acceptCondition(condition, itr, false);
        Number conditionValue = OCExpressionEvaluator.evaluate(condition);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean bl = conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        if (loopStartNode.isEmpty()) {
            this.myGraph.removeNode(loopStartNode, false);
            return;
        }
        List writes = (List)this.myValuesStack.pop();
        OCNode loopEndNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        if (condition != null) {
            if (conditionNotFalse || !this.myOptimizeUnreachableNodes) {
                this.addConditionalBranch(condition, true, loopEndNode, loopStartNode, Collections.emptyList(), null);
            }
            if (conditionNotTrue || !this.myOptimizeUnreachableNodes) {
                this.addConditionalBranch(condition, false, loopEndNode, exitNode);
            }
        }
        this.patchLoopJumps(state, conditionNode, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        this.visitElement(stmt);
        OCNode breakNode = this.myGraph.getLastAddedNode();
        this.myBreakNodes.add(breakNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        this.visitElement(stmt);
        OCNode continueNode = this.myGraph.getLastAddedNode();
        this.myContinueNodes.add(continueNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        OCNode labeledNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            labeledNode = this.myGraph.addNode();
            this.addBranch(lastNode, labeledNode);
        } else {
            labeledNode = lastNode;
        }
        this.visitElement(stmt);
        this.myLabeledNodes.put(stmt.getLabel(), labeledNode);
        for (OCNode gotoNode : this.myGotoNodes.get((Object)stmt.getLabel())) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (!(this.isSelected(gotoNode) ^ this.isSelected(labeledNode))) continue;
            this.myHasCrossSelectionJumps = true;
        }
        OCSymbol symbol = stmt.getLocalSymbol();
        if (symbol != null) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, stmt.getLabelElement(), symbol);
        }
    }

    @Override
    public void visitGotoStatement(OCGotoStatement stmt) {
        this.visitElement(stmt);
        OCNode gotoNode = this.myGraph.getLastAddedNode();
        this.myGraph.addNode();
        OCReferenceElement label = stmt.getLabel();
        if (label == null) {
            return;
        }
        this.myGotoNodes.add((Object)label.getCanonicalText(), (Object)gotoNode);
        OCNode labeledNode = this.myLabeledNodes.get(label.getCanonicalText());
        this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, stmt.getNavigationElement(), label.resolveToSymbol());
        if (labeledNode != null) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (this.isSelected(gotoNode) ^ this.isSelected(labeledNode)) {
                this.myHasCrossSelectionJumps = true;
            }
        }
    }

    protected void addCaseStatement(@NotNull OCCaseStatement stmt, @NotNull OCNode caseNode, @NotNull SwitchInfo info) {
        if (stmt == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(29);
        }
        if (caseNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(30);
        }
        if (info == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(31);
        }
        this.addBranch(info.getNode(), caseNode);
        info.addCaseExpression(stmt.getExpression());
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        SwitchInfo info;
        OCNode caseNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            caseNode = this.myGraph.addNode();
            this.addBranch(lastNode, caseNode);
        } else {
            caseNode = lastNode;
        }
        SwitchInfo switchInfo = info = this.mySwitchStack.isEmpty() ? null : (SwitchInfo)this.mySwitchStack.peek();
        if (info != null) {
            this.addCaseStatement(stmt, caseNode, info);
            if (stmt.isDefault()) {
                info.setHasDefault(true);
            }
        } else {
            this.myHasTopLevelCaseStatements = true;
        }
        this.visitElement(stmt);
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        OCType type;
        KidIterator itr = this.getKidIterator(stmt);
        itr.accept(stmt.getInitStatement());
        OCCondition expression = stmt.getExpression();
        itr.accept(expression);
        itr.skipLeaves();
        this.myValuesStack.push(new ArrayList());
        OCNode switchNode = this.myGraph.getLastAddedNode();
        this.mySwitchStack.push((Object)new SwitchInfo(expression, switchNode));
        int[] state = this.saveLoopState();
        this.myGraph.addNode();
        OCStatement body = stmt.getBody();
        itr.accept(body);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        List writes = (List)this.myValuesStack.pop();
        this.addBranch(lastNode, exitNode, writes);
        boolean allCasesCovered = ((SwitchInfo)this.mySwitchStack.pop()).hasDefault();
        OCType oCType = type = expression != null ? expression.getResolvedType().getTerminalType() : null;
        if (type instanceof OCStructType && ((OCStructType)type).isEnumClass()) {
            ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            if (body != null) {
                OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
                allCasesCovered |= OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)new Ref()).isEmpty();
            }
        }
        if (!allCasesCovered) {
            this.addBranch(switchNode, exitNode, writes);
        }
        this.patchLoopJumps(state, null, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        this.visitElement(stmt);
        OCNode returnNode = this.myGraph.getLastAddedNode();
        this.myGraph.addReturnNode(returnNode);
        this.myGraph.addNode();
        returnNode.setNodeAfterReturn(this.myGraph.getLastAddedNode());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression) {
        this.visitElement(expression);
        this.processThrow();
    }

    private void processThrow() {
        OCNode throwNode = this.myGraph.getLastAddedNode();
        this.myGraph.addExitNode(throwNode);
        this.myGraph.addNode();
        ((List)this.myTryThrows.peek()).add(throwNode);
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        this.myFirstThrowableNodes.push((Object)Ref.create());
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode bodyStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, bodyStartNode);
        this.myTryThrows.push(new ArrayList());
        itr.accept(stmt.getBody());
        bodyStartNode.enlarge(stmt, stmt);
        OCNode bodyEndNode = this.myGraph.getLastAddedNode();
        List throwNodes = (List)this.myTryThrows.pop();
        ArrayList<OCNode> catchEndNodes = new ArrayList<OCNode>();
        OCNode firstThrowableNode = (OCNode)((Ref)this.myFirstThrowableNodes.pop()).get();
        for (PsiElement psiElement : stmt.getCatchSections()) {
            this.processCatch(psiElement, bodyEndNode, firstThrowableNode, throwNodes);
            catchEndNodes.add(this.myGraph.getLastAddedNode());
        }
        OCNode exitNode = this.myGraph.addNode();
        this.addBranch(bodyEndNode, exitNode);
        for (OCNode node : catchEndNodes) {
            this.addBranch(node, exitNode);
        }
        if (stmt.getFinallySection() != null) {
            this.visitElement(stmt.getFinallySection());
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        OCNode firstThrowableNode = (OCNode)((Ref)this.myFirstThrowableNodes.peek()).get();
        List throwNodes = (List)this.myTryThrows.peek();
        OCNode lastBodyNode = this.myGraph.getLastAddedNode();
        this.processCatch(catchSection, lastBodyNode, firstThrowableNode, throwNodes);
    }

    private void processCatch(@NotNull PsiElement catchElement, @NotNull OCNode lastNode, @Nullable OCNode firstThrowableNode, @NotNull List<OCNode> throwNodes) {
        if (catchElement == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(32);
        }
        if (lastNode == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (throwNodes == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(34);
        }
        OCNode catchStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, catchStartNode);
        if (firstThrowableNode != null) {
            this.addBranch(firstThrowableNode, catchStartNode);
        }
        for (OCNode node : throwNodes) {
            this.addBranch(node, catchStartNode);
        }
        this.visitElement(catchElement);
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.visitBlockOrLambdaExpression(blockExpression);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.visitBlockOrLambdaExpression(lambdaExpression);
    }

    private void visitBlockOrLambdaExpression(@NotNull OCCallable callable) {
        if (callable == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(35);
        }
        this.myGraph.getLastAddedNode().enlarge(callable, callable);
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer((PsiElement)callable, this.myAnalyzer);
        analyzer.buildControlFlowGraph();
        OCUnreachableCodeFinder finder = analyzer.getUnreachableCodeFinder();
        OCNode lastNode = this.myGraph.getLastAddedNode();
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.REFERENCE, finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE));
        this.processReferencesFromBlock(finder);
        finder.clearInstructions();
    }

    private void processReferencesFromBlock(OCUnreachableCodeFinder finder) {
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        OCSymbol symbol = declarator.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, declarator, symbol);
        }
        this.visitElement(declarator);
        if (symbol != null && symbol.getKind().isLocal()) {
            OCType symbolType = symbol.getType().resolve(declarator);
            if (declarator.getInitializer() != null && symbol.getKind() != OCSymbolKind.PARAMETER) {
                this.processAssignment(symbol, declarator.getNameIdentifier(), declarator.getInitializer(), false);
            } else if (!declarator.getInitializers().isEmpty() && symbol.getKind() != OCSymbolKind.PARAMETER || symbolType instanceof OCArrayType) {
                OCExpression rValue = declarator.getInitializers().size() == 1 ? declarator.getInitializers().get(0) : null;
                boolean complexAssignment = rValue == null;
                this.processAssignment(symbol, declarator.getNameIdentifier(), rValue, complexAssignment);
            } else {
                PsiElement parent = declarator.getParent().getParent();
                if (parent instanceof OCForeachStatement || parent instanceof OCDeclarationStatement && parent.getParent() instanceof OCForeachStatement) {
                    this.processAssignment(symbol, declarator.getNameIdentifier(), null, true);
                } else {
                    this.processNonInitializedDeclarator(symbol, declarator.getNameIdentifier());
                }
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        this.visitElement(part);
        OCSymbol symbol = part.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, part.getParameter(), symbol);
        }
        if (symbol != null) {
            this.processNonInitializedDeclarator(symbol, part.getNameIdentifier());
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        OCExpression source = expression.getSourceExpression();
        OCExpression receiver = expression.getReceiverExpression();
        if (source != null) {
            source.accept(this);
        }
        receiver.accept(this);
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    protected void processNonInitializedDeclarator(@NotNull OCSymbol symbol, @Nullable PsiElement lValue) {
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(36);
        }
    }

    protected void processDereference(@NotNull OCReferenceExpression expression) {
        if (expression == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(37);
        }
    }

    protected void processReference(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        if (element == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(38);
        }
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(39);
        }
        this.myGraph.addInstruction(OCInstruction.InstructionKind.REFERENCE, element, symbol);
    }

    protected void processReferenceFromBlock(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(40);
        }
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment) {
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(41);
        }
        this.processAssignment(symbol, lValue, rValue, complexAssignment, false);
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment, boolean shortCircuitEvaluation) {
        OCInstruction write;
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(42);
        }
        if (!shortCircuitEvaluation) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.KILL, lValue, null, symbol);
        }
        if ((write = this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, lValue, rValue, symbol)) != null) {
            this.addModifiedValue(write.getRValue());
        }
    }

    protected void addModifiedValue(@Nullable PsiElement value) {
        if (value != null) {
            for (List list : this.myValuesStack) {
                list.add(value);
            }
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        super.visitDeclaration(declaration);
        List<OCDeclarator> declarators = declaration.getDeclarators();
        boolean hasDeclaratorsOfStructType = false;
        for (OCDeclarator declarator : declarators) {
            OCStructType structType;
            OCType type = declarator.getType().resolve(declaration);
            if (!(type instanceof OCStructType) || (structType = (OCStructType)type).isEnumClass() || structType.isEnum()) continue;
            hasDeclaratorsOfStructType = true;
            break;
        }
        if (hasDeclaratorsOfStructType) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        OCElementType sign = expression.getOperationSign();
        if (sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR) {
            KidIterator itr = this.getKidIterator(expression);
            itr.accept(expression.getLeft());
            Number leftValue = OCControlFlowBuilder.getValueOfCondition(expression.getLeft());
            if (leftValue == null) {
                ++this.myShortCircuitDepth;
                itr.accept(expression.getRight());
                --this.myShortCircuitDepth;
            } else if (OCExpressionEvaluator.singAsInC(leftValue) == 0 == (sign == OCTokenTypes.OROR)) {
                itr.accept(expression.getRight());
            }
            itr.finish();
        } else {
            this.visitElement(expression);
        }
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        super.visitUnaryExpression(expression);
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        super.visitArraySelectionExpression(expression);
        if (OCCodeInsightUtil.isOverloadedOperatorUsage(expression)) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression) {
        this.visitElement(expression);
        if (!expression.isNoThrow()) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitCppTypeIdExpression(OCCppTypeidExpression expression) {
        this.visitElement(expression);
        this.splitThrowableNode();
    }

    @Override
    public void visitFoldExpression(OCFoldExpression expression) {
        this.visitElement(expression);
        this.splitThrowableNode();
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        this.visitElement(expression);
        if (expression.getCastKind() == OCCastKind.DYNAMIC_CAST && expression.getCastType().resolve(expression) instanceof OCCppReferenceType) {
            this.splitThrowableNode();
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression callExpression) {
        this.visitElement(callExpression);
        this.splitThrowableNode();
        OCExpression functionReferenceExpression = callExpression.getFunctionReferenceExpression();
        OCSymbol symbol = OCGetSymbolVisitor.getSymbol(functionReferenceExpression);
        if (symbol != null && OCControlFlowBuilder.isNoReturn(symbol)) {
            OCNode returnNode = this.myGraph.getLastAddedNode();
            this.myGraph.addExitNode(returnNode);
            this.myGraph.addNode();
        }
    }

    private void splitThrowableNode() {
        if (!this.myFirstThrowableNodes.isEmpty() && ((Ref)this.myFirstThrowableNodes.peek()).isNull()) {
            OCNode throwableNode = this.myGraph.getLastAddedNode();
            OCNode toNode = this.myGraph.addNode();
            this.addBranch(throwableNode, toNode);
            ((Ref)this.myFirstThrowableNodes.peek()).set((Object)throwableNode);
        }
    }

    private static boolean isNoReturn(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowBuilder.$$$reportNull$$$0(43);
        }
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isNoReturn()) {
            return true;
        }
        String symbolName = symbol.getName();
        return symbolName.equals("__builtin_unreachable") || symbolName.equals("__builtin_trap");
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        this.visitElement(expression);
        OCExpression receiver = expression.getReceiverExpression();
        String selector = expression.getMessageSelector();
        if (selector.startsWith("raise") && receiver != null && receiver.getResolvedType().getName().equals("NSException")) {
            this.processThrow();
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        PsiElement parent;
        OCInstruction instruction;
        OCExpression element;
        this.visitElement(expression);
        OCSymbol symbol = expression.resolveToSymbol();
        if (!this.isSymbolInScope(symbol)) {
            return;
        }
        boolean wasQualifierOrIndex = false;
        if (symbol.getType().resolve(expression) instanceof OCStructType) {
            for (element = OCParenthesesUtils.topmostParenthesized(expression); element.getParent() instanceof OCQualifiedExpression || element.getParent() instanceof OCArraySelectionExpression && ((OCArraySelectionExpression)element.getParent()).getArrayExpression() == element; element = element.getParent()) {
                wasQualifierOrIndex = true;
            }
        }
        if (wasQualifierOrIndex && (instruction = this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression, symbol)) != null && element instanceof OCExpression && !(OCParenthesesUtils.topmostParenthesized(element).getParent() instanceof OCCallExpression)) {
            instruction.setTransparentRead(true);
        }
        if ((parent = element.getContext()) == null) {
            return;
        }
        MyParentVisitor visitor = new MyParentVisitor(element, symbol, wasQualifierOrIndex);
        parent.accept((PsiElementVisitor)visitor);
        if (!wasQualifierOrIndex && !visitor.isGenerated()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression, symbol);
        }
        if (visitor.isDereference()) {
            this.processDereference(expression);
        }
    }

    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCSymbol symbol) {
        return symbol != null && symbol.getKind().isLocal();
    }

    @Override
    public void visitBlockStatement(OCBlockStatement stmt) {
        PsiElement parent = stmt.getParent();
        if (!(parent instanceof OCFunctionDefinition) || parent == this.myGraph.getCodeFragment()) {
            this.visitElement(stmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 24: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itr";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savedState";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseNode";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastNode";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwNodes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "saveLoopState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKidIterator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processFirstCodeFragment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processNextCodeFragment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionWithTryBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStartNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addBranch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addUnstructuralBranch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "acceptCondition";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addConditionalBranch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitIfLike";
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "patchLoopJumps";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitForWhile";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addCaseStatement";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processCatch";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockOrLambdaExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processNonInitializedDeclarator";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processDereference";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceFromBlock";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processAssignment";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isNoReturn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 25 -> new IllegalStateException(string);
        };
    }

    protected static interface KidIterator {
        public void skipLeaves();

        public void accept(@Nullable PsiElement var1);

        public void skip(@Nullable PsiElement var1);

        public void acceptAll();

        public void finish();
    }

    protected static interface NodeState {
    }

    protected static class SwitchInfo {
        OCNode myNode;
        OCExpression myExpression;
        List<OCExpression> myCaseExpressions;
        boolean myHasDefault;

        public SwitchInfo(@Nullable OCCondition expression, @NotNull OCNode node) {
            if (node == null) {
                SwitchInfo.$$$reportNull$$$0(0);
            }
            this.myCaseExpressions = new ArrayList<OCExpression>();
            this.myExpression = expression != null ? expression.getExpression() : null;
            this.myNode = node;
        }

        @NotNull
        public OCNode getNode() {
            OCNode oCNode = this.myNode;
            if (oCNode == null) {
                SwitchInfo.$$$reportNull$$$0(1);
            }
            return oCNode;
        }

        @Nullable
        public OCExpression getExpression() {
            return this.myExpression;
        }

        public boolean hasDefault() {
            return this.myHasDefault;
        }

        public void setHasDefault(boolean hasDefault) {
            this.myHasDefault = hasDefault;
        }

        public void addCaseExpression(@Nullable OCExpression expr) {
            if (expr != null) {
                this.myCaseExpressions.add(expr);
            }
        }

        public List<OCExpression> getCaseExpressions() {
            return this.myCaseExpressions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$SwitchInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$SwitchInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyParentVisitor
    extends OCVisitor {
        @NotNull
        private final PsiElement myElement;
        private final OCSymbol mySymbol;
        private final boolean myWasQualifierOrIndex;
        private boolean myGenerated;
        private boolean myDereference;

        private MyParentVisitor(@NotNull PsiElement element, OCSymbol symbol, boolean wasQualifierOrIndex) {
            if (element == null) {
                MyParentVisitor.$$$reportNull$$$0(0);
            }
            if (symbol == null) {
                MyParentVisitor.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.mySymbol = symbol;
            this.myWasQualifierOrIndex = wasQualifierOrIndex;
        }

        public boolean isGenerated() {
            return this.myGenerated;
        }

        private boolean isDereference() {
            return this.myDereference;
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression) {
            if (this.processOperator(expression, OCOperatorReference.OperatorPlacement.INFIX)) {
                return;
            }
            boolean complexAssign = expression.getOperationSign() != OCTokenTypes.EQ;
            OCExpression receiver = expression.getReceiverExpression();
            OCExpression source = expression.getSourceExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)receiver, (PsiElement)this.myElement, (boolean)false)) {
                this.generateAssignmentInstructions(receiver, source, complexAssign, expression.getContainingFile());
                this.myGenerated = true;
            }
        }

        private void generateAssignmentInstructions(@Nullable OCExpression receiver, @Nullable OCExpression source, boolean isComplexAssign, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                MyParentVisitor.$$$reportNull$$$0(2);
            }
            if (isComplexAssign) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
            }
            if (!this.myWasQualifierOrIndex) {
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, receiver, source, isComplexAssign, OCControlFlowBuilder.this.myShortCircuitDepth != 0);
            } else if (this.mySymbol.getType().resolve((PsiElement)containingFile) instanceof OCStructType) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, receiver, source, this.mySymbol);
            }
        }

        private void processFunctionCall(@Nullable OCFunctionSymbol operator, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @Nullable OCFunctionType functionType, List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
            if (context == null) {
                MyParentVisitor.$$$reportNull$$$0(3);
            }
            ProgressManager.checkCanceled();
            if (arguments == null) {
                return;
            }
            if (operator instanceof OCFunctionGroupSymbol) {
                for (OCFunctionSymbol symbol : ((OCFunctionGroupSymbol)operator).getOverloads()) {
                    this.processFunctionCall(symbol, operatorPlacement, functionType, arguments, context);
                }
                return;
            }
            List<Object> parameterTypes = operator != null ? OCResolveOverloadsUtil.getParameterTypes(operator, operatorPlacement, context, this.myElement, null) : (functionType != null ? functionType.getParameterTypes() : Collections.emptyList());
            int argumentIndex = -1;
            for (int index = 0; index < arguments.size(); ++index) {
                OCTypeOwner argument = arguments.get(index);
                if (!(argument instanceof PsiElement) || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)argument), (PsiElement)this.myElement, (boolean)false)) continue;
                argumentIndex = index;
                break;
            }
            if (argumentIndex == -1 || argumentIndex >= parameterTypes.size()) {
                return;
            }
            OCType paramType = (OCType)parameterTypes.get(argumentIndex);
            if (paramType instanceof OCCppReferenceType && !((OCCppReferenceType)paramType).isReferenceToConst() || operator != null && argumentIndex == 0 && operator.isCppMemberOperator(OCResolveContext.forPsi(this.myElement))) {
                OCControlFlowBuilder.this.processReference(this.myElement, this.mySymbol);
                this.myGenerated = true;
            }
        }

        private boolean processOperator(@NotNull OCExpression expression, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement) {
            if (expression == null) {
                MyParentVisitor.$$$reportNull$$$0(4);
            }
            boolean isOperator = false;
            PsiReference reference = expression.getReference();
            if (reference instanceof OCOperatorReference) {
                for (OCSymbol operator : ((OCOperatorReference)reference).resolveToSymbolsViaClang()) {
                    if (!(operator instanceof OCFunctionSymbol)) continue;
                    isOperator = true;
                    this.processFunctionCall((OCFunctionSymbol)operator, operatorPlacement, null, ((OCOperatorReference)reference).getArgumentExpressions(), OCResolveContext.forPsi(expression));
                }
            }
            return isOperator;
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            if (this.processOperator(expression, OCOperatorReference.OperatorPlacement.POSTFIX)) {
                return;
            }
            OCType type = expression.getFunctionReferenceExpression().getResolvedType().getTerminalType();
            if (type instanceof OCFunctionType) {
                OCFunctionType functionType = (OCFunctionType)type;
                OCArgumentList argumentList = expression.getArgumentList();
                this.processFunctionCall(null, null, functionType, argumentList.getArguments(), OCResolveContext.forPsi(argumentList));
            }
        }

        @Override
        public void visitArgumentList(OCArgumentList argList) {
            this.visitParent(argList);
        }

        @Override
        public void visitMessageArgument(OCMessageArgument argument) {
            OCSendMessageExpression call = (OCSendMessageExpression)argument.getParent();
            int index = call.getArguments().indexOf(argument);
            OCSendMessageExpression.ProbableResponders responders = call.getProbableResponders();
            for (OCMethodSymbol method : responders.getAllResponders()) {
                OCDeclaratorSymbol parameter;
                if (method.getSelectors().size() <= index || (parameter = method.getSelectors().get(index).getParameter()) == null || !parameter.isPassByReference() && (!(parameter.getType() instanceof OCCppReferenceType) || ((OCCppReferenceType)parameter.getType()).isReferenceToConst())) continue;
                OCExpression expression = argument.getArgumentExpression();
                if (expression != null) {
                    OCControlFlowBuilder.this.processReference(expression, this.mySymbol);
                }
                this.myGenerated = true;
                return;
            }
        }

        @Override
        public void visitForeachStatement(OCForeachStatement statement) {
            OCElement expression = statement.getVariableExpression();
            if (expression instanceof OCExpressionStatement) {
                expression = ((OCExpressionStatement)expression).getExpression();
            }
            if (this.myElement == expression) {
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, this.myElement, null, true);
                this.myGenerated = true;
            }
        }

        @Override
        public void visitDeclarationStatement(OCDeclarationStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myGenerated = true;
            }
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            OCFunctionSymbol ctorSymbol;
            OCType declaratorType = declarator.getResolvedType();
            if (declaratorType instanceof OCCppReferenceType) {
                OCCppReferenceType referenceType = (OCCppReferenceType)declaratorType;
                if (!referenceType.isReferenceToConst()) {
                    OCControlFlowBuilder.this.processReference(this.myElement, this.mySymbol);
                    this.myGenerated = true;
                }
            } else if (declaratorType instanceof OCStructType && (ctorSymbol = OCResolveUtil.resolveCtorCall(declarator)) != null) {
                OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
                this.processFunctionCall(ctorSymbol, null, null, declarator.getInitializers(), resolveContext);
            }
        }

        @Override
        public void visitExpressionStatement(OCExpressionStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myGenerated = true;
            }
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression) {
            if (!(this.processOperator(expression, OCOperatorReference.OperatorPlacement.POSTFIX) || expression.getOperationSign() != OCTokenTypes.PLUSPLUS && expression.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, expression.getOperand(), expression.getOperand(), true);
                this.myGenerated = true;
            }
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression) {
            if (!(this.processOperator(expression, OCOperatorReference.OperatorPlacement.PREFIX) || expression.getOperationSign() != OCTokenTypes.PLUSPLUS && expression.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, expression.getOperand(), expression.getOperand(), true);
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(expression).getParent();
                if (parent != null) {
                    parent.accept((PsiElementVisitor)this);
                }
            }
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            this.processOperator(expression, OCOperatorReference.OperatorPlacement.INFIX);
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            if (this.processOperator(expression, OCOperatorReference.OperatorPlacement.PREFIX)) {
                return;
            }
            OCElementType sign = expression.getOperationSign();
            if (sign == OCTokenTypes.AND || sign == OCTokenTypes.__IMAG__KEYWORD || sign == OCTokenTypes.__REAL__KEYWORD) {
                OCControlFlowBuilder.this.processReference(expression, this.mySymbol);
                this.myGenerated = true;
            } else if (sign == OCTokenTypes.MUL) {
                if (OCParenthesesUtils.topmostParenthesized(expression).getParent() instanceof OCSizeofExpression) {
                    this.myGenerated = true;
                } else {
                    this.myDereference = true;
                }
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            if (!(this.processOperator(expression, OCOperatorReference.OperatorPlacement.INFIX) || expression.getQualifier() != this.myElement || expression.getQualifyingTokenKind() == OCTokenTypes.DOT && expression.getQualifier().getResolvedType().isPointerToObject())) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
            if (!this.processOperator(expression, OCOperatorReference.OperatorPlacement.POSTFIX) && expression.getArrayExpression() == this.myElement && !expression.getArrayExpression().getResolvedType().isPointerToObject()) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression.getCondition(), (PsiElement)this.myElement, (boolean)false)) {
                this.visitParent(expression);
            }
        }

        @Override
        public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
            this.visitParent(expression);
        }

        @Override
        public void visitCastExpression(OCCastExpression expression) {
            OCType castType = expression.getCastType();
            if (castType instanceof OCCppReferenceType && !((OCCppReferenceType)castType).isReferenceToConst()) {
                this.visitParent(expression);
            }
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            this.visitParent(initializer);
        }

        @Override
        public void visitAsmStatementPart(OCAsmStatementPartImpl statement) {
            OCExpression expression = statement.getExpression();
            if (statement.isOutputParametersPart() && expression != null) {
                this.generateAssignmentInstructions(expression, null, false, statement.getContainingFile());
            }
        }

        private void visitParent(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                MyParentVisitor.$$$reportNull$$$0(5);
            }
            if ((parent = element.getParent()) != null) {
                parent.accept((PsiElementVisitor)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCControlFlowBuilder$MyParentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateAssignmentInstructions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFunctionCall";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processOperator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

