/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.documentation.ClangdBridgeCompletionItem;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalResolveUtils {
    private static final ThreadLocal<Integer> ourResolveProhibited = ThreadLocal.withInitial(() -> 0);
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ExternalResolveUtils.class.getName());

    public static void prohibitClangResolve() {
        assert (ourResolveProhibited.get() >= 0) : "Unbalanced prohibitClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() + 1);
    }

    public static void allowClangResolve() {
        assert (ourResolveProhibited.get() > 0) : "Unbalanced allowClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() - 1);
    }

    @Nullable
    public static List<OCSymbol> resolveSymbols(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(0);
        }
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static OCSymbol resolveSymbol(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(1);
        }
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.chooseBestSymbol(elements, ref) : null;
    }

    @Nullable
    public static List<Pair<PsiFile, Integer>> resolveLocations(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(2);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        String url = file.getViewProvider().getVirtualFile().getUrl();
        Project project = file.getProject();
        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
            List<OCExternalResolver.Resolved> resolvedList = resolver.resolve(file, offset);
            if (ContainerUtil.isEmpty(resolvedList)) continue;
            return resolvedList.stream().map(resolved -> ExternalResolveUtils.toLocation(project, resolved, url)).filter(location -> location != null).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static Pair<PsiFile, Integer> resolveLocation(@NotNull PsiFile file, int offset) {
        List<Pair<PsiFile, Integer>> locations;
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(3);
        }
        return !ContainerUtil.isEmpty(locations = ExternalResolveUtils.resolveLocations(file, offset)) ? locations.get(0) : null;
    }

    public static PsiElement @Nullable [] resolveElements(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(4);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(file, offset);
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    public static PsiElement @Nullable [] resolveType(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(5);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalTypeResolve(file, offset);
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    public static <T> T findCombined(@NotNull PsiReference ref, @NotNull Function<PsiReference, T> mainResolver, @NotNull Function<PsiReference, T> secondaryResolver) {
        VirtualFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(6);
        }
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(7);
        }
        if (secondaryResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isWriteAccessAllowed() && ExternalResolveUtils.canDoExternalResolve(ref) && (file = ExternalResolveUtils.getRefFile(ref)) != null) {
            return (T)ExternalResolveUtils.findInParallel(15L, () -> mainResolver.apply(ref), () -> secondaryResolver.apply(ref), false, true);
        }
        T mainResult = mainResolver.apply(ref);
        if (mainResult != null) {
            return mainResult;
        }
        return secondaryResolver.apply(ref);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> callable) {
        void fallbackResolver;
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(9);
        }
        if (callable == null) {
            ExternalResolveUtils.$$$reportNull$$$0(10);
        }
        return ExternalResolveUtils.findInParallel(mainResolverTimeoutMs, mainResolver, fallbackResolver, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> fallbackResolver, boolean acceptNullFromMainResolver, boolean bl) {
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(11);
        }
        if (fallbackResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(12);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        try {
            void acceptNullFromFallbackResolver;
            Object ex2;
            CompletableFuture<? extends T> mainResolveFuture = ExternalResolveUtils.onPooledThread(mainResolver, (ProgressIndicator)indicator);
            CompletableFuture<? extends T> fallbackResolveFuture = ExternalResolveUtils.onPooledThread(fallbackResolver, (ProgressIndicator)indicator);
            Object result = null;
            try {
                result = CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(mainResolveFuture, (long)mainResolverTimeoutMs, (String)"main resolver");
            }
            catch (ExecutionException ex2) {
                ExternalResolveUtils.rethrowIfNeeded(ex2);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex2.getMessage(), (Throwable)ex2);
            }
            catch (TimeoutException ex2) {
                // empty catch block
            }
            if (!(result == null || result instanceof Object[] && ((Object[])result).length <= 0)) {
                ex2 = result;
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(CompletableFuture.anyOf(mainResolveFuture, fallbackResolveFuture), (String)"main or fallback resolver");
            }
            catch (ExecutionException ex3) {
                ExternalResolveUtils.rethrowIfNeeded(ex3);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex3.getMessage(), (Throwable)ex3);
            }
            result = ExternalResolveUtils.takeNonNullAndNotEmpty(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            if (result != null) {
                ex2 = result;
                return (T)ex2;
            }
            if (acceptNullFromMainResolver && CidrConcurrentUtilsKt.isCompletedNormally(mainResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture);
                return (T)ex2;
            }
            if (acceptNullFromFallbackResolver != false && CidrConcurrentUtilsKt.isCompletedNormally(fallbackResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture);
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(CompletableFuture.allOf(mainResolveFuture, fallbackResolveFuture), (String)"main and fallback resolver");
            }
            catch (ExecutionException ex4) {
                ExternalResolveUtils.rethrowIfNeeded(ex4);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex4.getMessage(), (Throwable)ex4);
            }
            Object object = ExternalResolveUtils.takeNonNullAndNotEmpty(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            return (T)object;
        }
        finally {
            indicator.cancel();
        }
    }

    public static void assertFoundSameSymbol(@NotNull Project project, @Nullable OCSymbol clangSymbol, @NotNull Supplier<OCSymbol> clionResolver) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(13);
        }
        if (clionResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(14);
        }
    }

    public static void assertFoundSameElement(@Nullable PsiElement clangElement, @NotNull Supplier<PsiElement> clionResolver) {
        if (clionResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(15);
        }
    }

    @Nullable
    private static <T> T takeNonNullAndNotEmpty(@Nullable T first, @Nullable T second) {
        return first != null && (!(first instanceof Object[]) || ((Object[])first).length > 0) ? first : second;
    }

    private static void rethrowIfNeeded(@NotNull ExecutionException ex) {
        if (ex == null) {
            ExternalResolveUtils.$$$reportNull$$$0(16);
        }
        Throwable thr = ex.getCause();
        while (thr instanceof ExecutionException) {
            thr = thr.getCause();
        }
        if (thr instanceof ControlFlowException) {
            ExceptionUtil.rethrow((Throwable)thr);
        }
    }

    private static Predicate<OCSymbol> getSymbolsFilter(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(17);
        }
        if (ref instanceof OCReferenceElement) {
            return sym -> sym != null && !(sym instanceof OCFunctionSymbol);
        }
        if (ref instanceof OCOperatorReference) {
            return sym -> sym instanceof OCFunctionSymbol && ((OCFunctionSymbol)sym).isCppOperator();
        }
        return sym -> true;
    }

    @Nullable
    private static OCSymbol chooseBestSymbol(@NotNull List<PsiElement> elements, @NotNull PsiReference ref) {
        Optional<OCSymbol> firstOperatorOrNone;
        if (elements == null) {
            ExternalResolveUtils.$$$reportNull$$$0(18);
        }
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(19);
        }
        if (ref instanceof OCReferenceElement) {
            Optional<OCSymbol> firstSymOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst();
            if (firstSymOrNone.isPresent()) {
                OCClassSymbol definitionSymbolSymbol;
                OCInterfaceSymbol interfaceSymbol;
                OCSymbol firstSymbol = firstSymOrNone.get();
                if (firstSymbol instanceof OCStructSymbol) {
                    OCSymbol ctor = ExternalResolveUtils.runClionOverloadResolutionForStruct((OCReferenceElement)ref, (OCStructSymbol)firstSymbol);
                    if (ctor != null) {
                        return ctor;
                    }
                } else if (firstSymbol instanceof OCInterfaceSymbol && (interfaceSymbol = (OCInterfaceSymbol)firstSymbol).isPredeclaration() && (definitionSymbolSymbol = interfaceSymbol.getDefinitionSymbol(((OCReferenceElement)ref).getProject())) != null) {
                    return definitionSymbolSymbol;
                }
                return firstSymbol;
            }
        } else if (ref instanceof OCOperatorReference && (firstOperatorOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst()).isPresent()) {
            return firstOperatorOrNone.get();
        }
        return ExternalResolveUtils.toSymbolStream(elements).filter(sym -> sym != null).findFirst().orElse(null);
    }

    @NotNull
    private static Stream<OCSymbol> toSymbolStream(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            ExternalResolveUtils.$$$reportNull$$$0(20);
        }
        Stream<OCSymbol> stream = elements.stream().filter(element -> element instanceof OCSymbolDeclarator).map(element -> ((OCSymbolDeclarator)element).getSymbol());
        if (stream == null) {
            ExternalResolveUtils.$$$reportNull$$$0(21);
        }
        return stream;
    }

    private static boolean canDoExternalResolve(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(22);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(ref.getElement().getProject())) {
            return false;
        }
        return !OCElementUtil.isPartOfMacroSubstitution(ref.getElement());
    }

    public static boolean canDoExternalResolveRelaxed(@NotNull Project project) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(23);
        }
        if (PluginUtils.hasAppCode()) {
            return false;
        }
        int resolveProhibitedValue = ourResolveProhibited.get();
        if (resolveProhibitedValue > 0) {
            return false;
        }
        assert (resolveProhibitedValue == 0) : "Unexpected resolve prohibited value";
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        return !OCExternalResolver.EP_NAME.getExtensionList().isEmpty();
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiReference ref) {
        PsiElement refElement;
        PsiFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(24);
        }
        if ((file = (refElement = ref.getElement()).getContainingFile()) == null) {
            return null;
        }
        int offset = ref.getRangeInElement().getStartOffset() + refElement.getTextOffset();
        return ExternalResolveUtils.doExternalResolve(file, offset);
    }

    @NotNull
    private static List<PsiElement> handleResolvedList(@NotNull List<OCExternalResolver.Resolved> resolvedList, @NotNull Project project, @NotNull String url) {
        if (resolvedList == null) {
            ExternalResolveUtils.$$$reportNull$$$0(25);
        }
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(26);
        }
        if (url == null) {
            ExternalResolveUtils.$$$reportNull$$$0(27);
        }
        if (resolvedList.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ExternalResolveUtils.$$$reportNull$$$0(28);
            }
            return list;
        }
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (OCExternalResolver.Resolved resolved : resolvedList) {
            PsiElement elem = ExternalResolveUtils.toPsi(project, resolved, url);
            if (elem == null) continue;
            psiElements.add(elem);
        }
        ArrayList<PsiElement> arrayList = psiElements;
        if (arrayList == null) {
            ExternalResolveUtils.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(30);
        }
        return ExternalResolveUtils.doExternalResolveImpl(file, r -> r.resolve(file, offset));
    }

    @Nullable
    private static List<PsiElement> doExternalTypeResolve(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(31);
        }
        return ExternalResolveUtils.doExternalResolveImpl(file, r -> r.resolveType(file, offset));
    }

    @Nullable
    private static List<PsiElement> doExternalResolveImpl(@NotNull PsiFile file, @NotNull Function<OCExternalResolver, List<OCExternalResolver.Resolved>> resolveFun) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(32);
        }
        if (resolveFun == null) {
            ExternalResolveUtils.$$$reportNull$$$0(33);
        }
        String url = file.getViewProvider().getVirtualFile().getUrl();
        Project project = file.getProject();
        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
            List<PsiElement> psiElements;
            List<OCExternalResolver.Resolved> resolvedList = resolveFun.apply(resolver);
            if (ContainerUtil.isEmpty(resolvedList) || (psiElements = ExternalResolveUtils.handleResolvedList(resolvedList, project, url)).isEmpty()) continue;
            return psiElements;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getRefFile(@NotNull PsiReference ref) {
        PsiElement refElement;
        PsiFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(34);
        }
        if ((file = (refElement = ref.getElement()).getContainingFile()) == null) {
            return null;
        }
        return file.getViewProvider().getVirtualFile();
    }

    @Nullable
    public static Pair<PsiFile, Integer> toLocation(@NotNull Project project, @NotNull OCExternalResolver.Resolved sym, @NotNull String requestFileUrl) {
        String path;
        VirtualFile targetVirtualFile;
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(35);
        }
        if (sym == null) {
            ExternalResolveUtils.$$$reportNull$$$0(36);
        }
        if (requestFileUrl == null) {
            ExternalResolveUtils.$$$reportNull$$$0(37);
        }
        if ((targetVirtualFile = CidrLangUtil.findBestFile((Project)project, (String)(path = sym.file.getPath()), (int)sym.line, (int)sym.column, vf -> OCSearchScope.isInProjectSourcesOrLibraries(project, vf))) == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(targetVirtualFile);
        if (document == null) {
            return null;
        }
        PsiFile targetPsiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (targetPsiFile == null) {
            return null;
        }
        if (!CidrLangUtil.isAcceptablePosition((Document)document, (int)sym.line, (int)sym.column)) {
            StringBuilder message = new StringBuilder("Requested line ").append(sym.line).append(" of ").append(document.getLineCount()).append(" in ").append(targetVirtualFile.getUrl()).append(" when looking for resolved ").append(sym);
            message.append("; ");
            message.append("request file was ").append(requestFileUrl);
            throw new IndexOutOfBoundsException(message.toString());
        }
        int offset = document.getLineStartOffset(sym.line) + sym.column;
        return Pair.create((Object)targetPsiFile, (Object)offset);
    }

    @Nullable
    public static PsiElement toPsi(@NotNull Project project, @NotNull OCExternalResolver.Resolved sym, @NotNull String requestFileUrl) {
        Pair<PsiFile, Integer> location;
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(38);
        }
        if (sym == null) {
            ExternalResolveUtils.$$$reportNull$$$0(39);
        }
        if (requestFileUrl == null) {
            ExternalResolveUtils.$$$reportNull$$$0(40);
        }
        if ((location = ExternalResolveUtils.toLocation(project, sym, requestFileUrl)) == null) {
            return null;
        }
        return ExternalResolveUtils.findAppropriateElement((PsiFile)location.getFirst(), (Integer)location.getSecond());
    }

    @Nullable
    public static PsiElement findAppropriateElement(@NotNull PsiFile file, int offset) {
        Object object;
        String idName;
        PsiElement clangElement;
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(41);
        }
        if ((clangElement = file.findElementAt(offset)) == null) {
            if (offset == 0) {
                return file;
            }
            return null;
        }
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)clangElement, OCMacroCall.class);
        if (macroCall != null && clangElement instanceof LeafPsiElement && ((LeafPsiElement)clangElement).getElementType() == OCTokenTypes.IDENTIFIER && !StringUtil.isEmpty((String)(idName = OCElementUtil.getIdentifierName(clangElement)))) {
            object = PsiTreeUtil.findChildrenOfType((PsiElement)macroCall.getNextSibling(), ForeignLeafPsiElement.class).iterator();
            while (object.hasNext()) {
                ForeignLeafPsiElement foreignLeaf = (ForeignLeafPsiElement)object.next();
                if (foreignLeaf.getElementType() != OCTokenTypes.IDENTIFIER || !idName.contentEquals(OCElementUtil.getIdentifierName(clangElement))) continue;
                clangElement = foreignLeaf;
                break;
            }
        }
        if (clangElement instanceof OCSymbolDeclarator) {
            return clangElement;
        }
        if (clangElement.getParent() instanceof OCSymbolDeclarator) {
            return clangElement.getParent();
        }
        if (clangElement instanceof LeafPsiElement && OCTokenTypes.KEYWORDS.contains(((LeafPsiElement)clangElement).getElementType()) && (object = clangElement.getParent()) instanceof OCDeclaration) {
            OCDeclaration decl = (OCDeclaration)object;
            List<OCDeclarator> declarators = decl.getDeclarators();
            PsiElement bestElement = null;
            for (OCDeclarator declarator : declarators) {
                if (bestElement == null) {
                    bestElement = declarator;
                    continue;
                }
                if (!declarator.getTextRange().contains(offset)) continue;
                bestElement = declarator;
            }
            if (bestElement == null && decl.getTypeElement() != null) {
                OCTypeElement typeElement = decl.getTypeElement();
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCSymbolDeclarator)) continue;
                    bestElement = child;
                    break;
                }
            }
            return bestElement != null ? bestElement : clangElement;
        }
        return clangElement;
    }

    @Nullable
    public static PsiElement clangdCompletionItem2PsiElement(@NotNull Project project, @NotNull ClangdBridgeCompletionItem item) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(42);
        }
        if (item == null) {
            ExternalResolveUtils.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (item.getFromFile() == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)item.getFromFile()));
        if (virtualFile == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiManager.getProject()).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        int offset = item.getFromFileOffset();
        if (offset < 0) {
            return null;
        }
        try {
            String rawContent = new String(virtualFile.contentsToByteArray(), virtualFile.getCharset());
            LineColumn lineCol = StringUtil.offsetToLineColumn((CharSequence)rawContent, (int)offset);
            if (lineCol != null) {
                offset = StringUtil.lineColToOffset((CharSequence)document.getCharsSequence(), (int)lineCol.line, (int)lineCol.column);
            }
        }
        catch (IOException ignored) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        return ExternalResolveUtils.findAppropriateElement(psiFile, offset);
    }

    @Nullable
    private static OCSymbol runClionOverloadResolutionForStruct(@NotNull OCReferenceElement referenceElement, @NotNull OCStructSymbol clangSymbol) {
        Ref argumentsRef;
        Ref argsRef;
        OCStructType type;
        if (referenceElement == null) {
            ExternalResolveUtils.$$$reportNull$$$0(44);
        }
        if (clangSymbol == null) {
            ExternalResolveUtils.$$$reportNull$$$0(45);
        }
        if ((type = new OCStructType(clangSymbol)).isEnum() || type.isEnumClass()) {
            return null;
        }
        OCResolveContext context = OCResolveContext.forPsi(referenceElement);
        if (!OCReferenceElementImpl.findArgumentsFromContext(referenceElement, context, (Ref<List<OCExpression>>)(argsRef = Ref.create()), (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
            return null;
        }
        return OCReferenceElementImpl.resolveToConstructors(referenceElement, Collections.singleton(clangSymbol), type, (OCArgumentsList)argumentsRef.get(), context);
    }

    @NotNull
    private static String toMessageWithRef(@NotNull Throwable original, @NotNull PsiReference ref) {
        String string;
        if (original == null) {
            ExternalResolveUtils.$$$reportNull$$$0(46);
        }
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(47);
        }
        try {
            PsiElement element = ref.getElement();
            PsiFile file = element.getContainingFile();
            string = "When resolving " + OCElementUtil.getElementDebugName(element) + " at " + file.getName() + ":" + (element.getTextOffset() + ref.getRangeInElement().getStartOffset()) + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ExternalResolveUtils.$$$reportNull$$$0(49);
            }
            return string2;
        }
        if (string == null) {
            ExternalResolveUtils.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        String string;
        if (original == null) {
            ExternalResolveUtils.$$$reportNull$$$0(50);
        }
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(51);
        }
        try {
            string = "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ExternalResolveUtils.$$$reportNull$$$0(53);
            }
            return string2;
        }
        if (string == null) {
            ExternalResolveUtils.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static <T> CompletableFuture<T> onPooledThread(@NotNull Callable<? extends T> task2, @NotNull ProgressIndicator indicator) {
        if (task2 == null) {
            ExternalResolveUtils.$$$reportNull$$$0(54);
        }
        if (indicator == null) {
            ExternalResolveUtils.$$$reportNull$$$0(55);
        }
        CompletableFuture result = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> ReadAction.run(() -> {
            try {
                ProgressManager.checkCanceled();
                result.complete(task2.call());
            }
            catch (Throwable thr) {
                result.completeExceptionally(thr);
            }
        }), indicator));
        CompletableFuture completableFuture = result;
        if (completableFuture == null) {
            ExternalResolveUtils.$$$reportNull$$$0(56);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 28, 29, 48, 49, 52, 53, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 30: 
            case 31: 
            case 32: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryResolver";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackResolver";
                break;
            }
            case 13: 
            case 23: 
            case 26: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clionResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: 
            case 28: 
            case 29: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ExternalResolveUtils";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedList";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveFun";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sym";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestFileUrl";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangSymbol";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ExternalResolveUtils";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toSymbolStream";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "handleResolvedList";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithRef";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithOffset";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "onPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbols";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCombined";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findInParallel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assertFoundSameSymbol";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "assertFoundSameElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rethrowIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsFilter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "chooseBestSymbol";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toSymbolStream";
                break;
            }
            case 21: 
            case 28: 
            case 29: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 56: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canDoExternalResolve";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canDoExternalResolveRelaxed";
                break;
            }
            case 24: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doExternalResolve";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "handleResolvedList";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doExternalTypeResolve";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doExternalResolveImpl";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRefFile";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toLocation";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toPsi";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateElement";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "clangdCompletionItem2PsiElement";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runClionOverloadResolutionForStruct";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithRef";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithOffset";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "onPooledThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 28, 29, 48, 49, 52, 53, 56 -> new IllegalStateException(string);
        };
    }
}

