/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.ResolveSession;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAnnotator
extends OCVisitor
implements Annotator {
    public static final Key<Object> ALWAYS_ANNOTATE = Key.create((String)"ALWAYS_ANNOTATE");
    public static final String CIDR_DIAG = "CIDR";
    static final NotNullLazyKey<ResolveSession, AnnotationSession> RESOLVE_SESSION = NotNullLazyKey.createLazyKey((String)"RESOLVE_SESSION", holder -> new ResolveSession(holder.getFile()));
    @Nullable
    private AnnotationHolder myHolder;
    private PsiElement myAnnotatingElement;

    @NotNull
    public static List<OCAnnotatorHelper> getAnnotatorHelpers() {
        List list = OCAnnotatorHelper.EP_NAME.getExtensionList();
        if (list == null) {
            OCAnnotator.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            OCAnnotator.$$$reportNull$$$0(2);
        }
        this.annotate(psiElement, holder, OCAnnotator.getResolveSession(holder));
    }

    public static ResolveSession getResolveSession(@Nullable AnnotationHolder holder) {
        return holder == null ? null : (ResolveSession)((Object)RESOLVE_SESSION.getValue((UserDataHolder)holder.getCurrentAnnotationSession()));
    }

    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @NotNull ResolveSession resolveSession) {
        OCFile ocFile;
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(3);
        }
        if (resolveSession == null) {
            OCAnnotator.$$$reportNull$$$0(4);
        }
        if ((ocFile = OCLanguageUtils.asOCFile(resolveSession.getFile())) == null || psiElement.getContainingFile() != ocFile) {
            return;
        }
        Project project = ocFile.getProject();
        if (!OCAnnotator.isAnnotated(project, ocFile.getVirtualFile())) {
            return;
        }
        this.myHolder = holder;
        this.myAnnotatingElement = psiElement;
        ocFile.runWithResolveSession(resolveSession, () -> {
            try {
                if (this.isEnabled(ocFile)) {
                    this.myAnnotatingElement.accept((PsiElementVisitor)this);
                }
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                this.myHolder = null;
                this.myAnnotatingElement = null;
            }
        });
    }

    protected boolean isEnabled(@NotNull PsiFile file) {
        if (file == null) {
            OCAnnotator.$$$reportNull$$$0(5);
        }
        return true;
    }

    public static boolean isAnnotated(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(6);
        }
        return OCAnnotator.doIsAnnotated(project, file, true);
    }

    public static boolean isAnnotatedAsUserCode(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(7);
        }
        return OCAnnotator.doIsAnnotated(project, file, false);
    }

    private static boolean doIsAnnotated(@NotNull Project project, @Nullable VirtualFile file, boolean includingLibraries) {
        if (project == null) {
            OCAnnotator.$$$reportNull$$$0(8);
        }
        if (file == null || !OCLanguageUtils.isSupported((VirtualFile)file)) {
            return false;
        }
        if (project.getUserData(ALWAYS_ANNOTATE) != null) {
            return true;
        }
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance(project);
        return includingLibraries ? scopeService.isInProjectSourcesOrLibraries(file) : scopeService.isInProjectSources(file);
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file, @NotNull TextRange range, @Nullable String problemID, @NotNull Class<? extends OCInspection> inspectionClass) {
        OCClangMessageDescriptor descriptor;
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(9);
        }
        if (inspectionClass == null) {
            OCAnnotator.$$$reportNull$$$0(10);
        }
        if (problemID == null) {
            return null;
        }
        String inspectionId = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionId == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionId, suppressionGroup, file, range);
    }

    @NotNull
    public static ProblemHighlightType getProblemHighlightType(@NotNull HighlightSeverity highlightSeverity, @NotNull ProblemHighlightType defaultHighlightType) {
        if (highlightSeverity == null) {
            OCAnnotator.$$$reportNull$$$0(11);
        }
        if (defaultHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(12);
        }
        ProblemHighlightType highlightType = defaultHighlightType;
        if (!highlightSeverity.equals((Object)HighlightSeverity.WARNING)) {
            if (highlightSeverity.equals((Object)HighlightSeverity.ERROR)) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.INFORMATION)) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.WEAK_WARNING)) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
        }
        ProblemHighlightType problemHighlightType = highlightType;
        if (problemHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(13);
        }
        return problemHighlightType;
    }

    public boolean highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
            return true;
        }
        return false;
    }

    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(14);
        }
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(key).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSession";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatorHelpers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedAsUserCode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doIsAnnotated";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProblemGroup";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProblemHighlightType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> new IllegalArgumentException(string);
        };
    }
}

