/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCHeaderFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    public static final Set<String> LOOK_LIKE_OC_FILE_BUT_ARE_NOT = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("y", "yy", "ypp", "y++", "yxx", "l", "ll", "lpp", "l++", "lxx", "dlg", "log", "td", "pkg"));

    public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        IElementType tt;
        if (file == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(0);
        }
        if (firstBytes == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(1);
        }
        if (firstCharsIfText == null) {
            return null;
        }
        FileType type = OCHeaderFileTypeDetector.detectWithHelpers(file);
        if (type != FileTypes.UNKNOWN) {
            return type;
        }
        String extension = file.getExtension();
        if (extension != null && LOOK_LIKE_OC_FILE_BUT_ARE_NOT.contains(extension)) {
            return null;
        }
        if (extension == null && FileUtil.isHashBangLine((CharSequence)firstCharsIfText, (String)"")) {
            return null;
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        int endOffset = Math.min(this.getDesiredContentPrefixLength(), firstCharsIfText.length());
        lexer.start(firstCharsIfText, 0, endOffset, 0);
        boolean atNewLine = true;
        boolean wasDirective = false;
        int identsInSequence = 0;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == TokenType.BAD_CHARACTER) {
                lexer.advance();
                if (lexer.getTokenType() == null) break;
                return null;
            }
            if (OCTokenTypes.COMMENTS.contains(tt)) {
                identsInSequence = 0;
            } else if (OCTokenTypes.WHITESPACES.contains(tt)) {
                if (lexer.getTokenText().contains("\n")) {
                    atNewLine = true;
                }
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                if (++identsInSequence > 7) {
                    return null;
                }
                atNewLine = false;
            } else {
                if (OCTokenTypes.DIRECTIVES.contains(tt) && tt != OCTokenTypes.EMPTY_DIRECTIVE && atNewLine) {
                    wasDirective = true;
                    break;
                }
                atNewLine = false;
                identsInSequence = 0;
            }
            lexer.advance();
        }
        return wasDirective ? OCLanguageUtils.getBaseFileType() : null;
    }

    public int getDesiredContentPrefixLength() {
        return 8192;
    }

    @Nullable
    private static FileType detectWithHelpers(@NotNull VirtualFile file) {
        if (file == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(2);
        }
        return (FileType)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            for (OCFileTypeHelper each : OCFileTypeHelper.EP_NAME.getExtensionsIfPointIsRegistered()) {
                FileType type = each.getFileType(file);
                if (type == FileTypes.UNKNOWN) continue;
                return type;
            }
            return FileTypes.UNKNOWN;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBytes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectWithHelpers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

