/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentGroupImpl;
import com.jetbrains.cidr.doxygen.comment.DoxygenCommentTagImpl;
import com.jetbrains.cidr.doxygen.comment.DxCommentProcessorUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DxCommentProcessor {
    public static final Set<String> PLAIN_TAGS = Set.of(DoxygenCmd.BRIEF.toString());
    final PsiElement element;
    private static final Result NONE = new Result(null, true);

    public DxCommentProcessor(@Nullable PsiElement element) {
        this.element = element;
    }

    @NotNull
    public DoxygenCommentGroupImpl getCommentGroup() {
        List<PsiNamedElement> params;
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentFor(this.element);
        DoxygenCommentGroupImpl.Builder builder = DxCommentProcessor.process(comments);
        PsiElement curElement = this.element;
        if (curElement instanceof OCDeclarator) {
            curElement = curElement.getParent();
        }
        if (curElement instanceof OCCallable && (params = ((OCCallable)curElement).getParameters()) != null) {
            for (PsiNamedElement param : params) {
                List<PsiComment> paramComments;
                DoxygenCommentGroupImpl paramGroup;
                String name = param.getName();
                if ("<unnamed>".equals(name) || (paramGroup = DxCommentProcessor.process(paramComments = DxCommentProcessorUtil.findOCCommentFor((PsiElement)param)).build()).isEmpty()) continue;
                builder.addTag(new DoxygenCommentTagImpl("param", paramGroup.getOptions(), name, paramGroup.getDescription()));
            }
        }
        DoxygenCommentGroupImpl doxygenCommentGroupImpl = builder.build();
        if (doxygenCommentGroupImpl == null) {
            DxCommentProcessor.$$$reportNull$$$0(0);
        }
        return doxygenCommentGroupImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DoxygenCommentGroupImpl.Builder process(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            DxCommentProcessor.$$$reportNull$$$0(1);
        }
        boolean isOptionFound = false;
        DoxygenCommentGroupImpl.Builder builder = new DoxygenCommentGroupImpl.Builder();
        Comment comment = new Comment(comments);
        PsiElement element = comment.getFistChild();
        while (element != null) {
            block10: {
                IElementType type = element.getNode().getElementType();
                if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START) {
                    builder.addText("");
                } else {
                    Result result;
                    StringBuilder description;
                    if (type == DxTypes.DOC_COMMENT_DATA) {
                        description = new StringBuilder();
                        result = DxCommentProcessor.processDocData(comment, element, description);
                        element = result.element;
                        builder.addText(description.toString());
                        continue;
                    }
                    if (type == DxTypes.TAG_OPTION) {
                        if (!isOptionFound) {
                            isOptionFound = true;
                            builder.addOptions(element.getNode());
                            break block10;
                        } else {
                            description = new StringBuilder();
                            result = DxCommentProcessor.processDocData(comment, element, description);
                            element = result.element;
                            builder.addText(description.toString());
                            continue;
                        }
                    }
                    if (type == DxTypes.DOC_TAG) {
                        Result result2 = DxCommentProcessor.processTag(comment, element, builder);
                        element = result2.element;
                        continue;
                    }
                }
            }
            element = comment.nextSibling(element);
        }
        DoxygenCommentGroupImpl.Builder builder2 = builder;
        if (builder2 == null) {
            DxCommentProcessor.$$$reportNull$$$0(2);
        }
        return builder2;
    }

    @NotNull
    private static Result processDocData(@NotNull Comment comment, @Nullable PsiElement element, @NotNull StringBuilder description) {
        if (comment == null) {
            DxCommentProcessor.$$$reportNull$$$0(3);
        }
        if (description == null) {
            DxCommentProcessor.$$$reportNull$$$0(4);
        }
        if (element == null) {
            Result result = NONE;
            if (result == null) {
                DxCommentProcessor.$$$reportNull$$$0(5);
            }
            return result;
        }
        IElementType type = element.getNode().getElementType();
        if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
            String text = element.getText().trim();
            description.append(text);
            return DxCommentProcessor.processDocData(comment, comment.nextSibling(element), description);
        }
        while (element != null) {
            type = element.getNode().getElementType();
            if (type == DxTypes.DOC_TAG) {
                return new Result(element, true);
            }
            if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
                return DxCommentProcessor.processDocData(comment, element, description);
            }
            if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START || type == TokenType.WHITE_SPACE) {
                if (description.length() == 0 || !StringUtil.isWhiteSpace((char)description.charAt(description.length() - 1))) {
                    description.append(" ");
                }
                Result result = DxCommentProcessor.processWS(comment, element);
                if (!result.proceed) {
                    Result result2 = result;
                    if (result2 == null) {
                        DxCommentProcessor.$$$reportNull$$$0(6);
                    }
                    return result2;
                }
                element = result.element;
                continue;
            }
            element = comment.nextSibling(element);
        }
        Result result = NONE;
        if (result == null) {
            DxCommentProcessor.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    private static Result processTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull DoxygenCommentGroupImpl.Builder builder) {
        DxDocTag tag;
        String name;
        if (comment == null) {
            DxCommentProcessor.$$$reportNull$$$0(8);
        }
        if (element == null) {
            DxCommentProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            DxCommentProcessor.$$$reportNull$$$0(10);
        }
        if (DoxygenCmd.SURROUND_TAGS.containsKey(name = (tag = (DxDocTag)element).getName())) {
            element = DxCommentProcessor.processSurroundTag(comment, element, builder);
            return new Result(element, true);
        }
        if (DoxygenCmd.SURROUND_TAGS.containsValue(name)) {
            element = comment.nextSibling(element);
            return new Result(element, true);
        }
        DoxygenCommentTagImpl curTag = new DoxygenCommentTagImpl(tag);
        builder.addTag(curTag);
        element = comment.nextSibling(element);
        while (element != null) {
            Result result;
            CharSequence description;
            IElementType type = element.getNode().getElementType();
            if (type == DxTypes.DOC_COMMENT_DATA || type == DxTypes.TAG_OPTION) {
                description = new StringBuilder();
                result = DxCommentProcessor.processDocData(comment, element, (StringBuilder)description);
                curTag.addText(((StringBuilder)description).toString());
                element = result.element;
                if (result.proceed) continue;
                Result result2 = result;
                if (result2 == null) {
                    DxCommentProcessor.$$$reportNull$$$0(11);
                }
                return result2;
            }
            if (type == DxTypes.DOC_TAG) {
                if (!PLAIN_TAGS.contains(name) && DoxygenCmd.SURROUND_TAGS.containsKey(((DxDocTag)element).getName())) {
                    element = DxCommentProcessor.processSurroundTag(comment, element, curTag);
                    continue;
                }
                return new Result(element, true);
            }
            if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START || type == TokenType.WHITE_SPACE) {
                description = curTag.getDescription();
                if (((String)description).length() == 0 || !StringUtil.isWhiteSpace((char)((String)description).charAt(((String)description).length() - 1))) {
                    curTag.addText(" ");
                }
                result = DxCommentProcessor.processWS(comment, element);
                element = result.element;
                if (result.proceed) continue;
                Result result3 = result;
                if (result3 == null) {
                    DxCommentProcessor.$$$reportNull$$$0(12);
                }
                return result3;
            }
            element = comment.nextSibling(element);
        }
        Result result = NONE;
        if (result == null) {
            DxCommentProcessor.$$$reportNull$$$0(13);
        }
        return result;
    }

    @Nullable
    private static PsiElement processSurroundTag(@NotNull Comment comment, @NotNull PsiElement element, @NotNull ComplexItemBuilder builder) {
        if (comment == null) {
            DxCommentProcessor.$$$reportNull$$$0(14);
        }
        if (element == null) {
            DxCommentProcessor.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            DxCommentProcessor.$$$reportNull$$$0(16);
        }
        DoxygenCommentTagImpl tag = new DoxygenCommentTagImpl((DxDocTag)element);
        String stopName = DoxygenCmd.SURROUND_TAGS.get(tag.getName());
        builder.addTag(tag);
        StringBuilder description = new StringBuilder();
        element = comment.nextSibling(element);
        while (element != null) {
            String text = element.getText();
            IElementType type = element.getNode().getElementType();
            if (type == TokenType.WHITE_SPACE) {
                int count = StringUtil.getLineBreakCount((CharSequence)text);
                if (count > 0 && text.contains("*")) {
                    for (int i = 0; i < count; ++i) {
                        if (description.length() <= 0) continue;
                        description.append("\n");
                    }
                } else {
                    description.append(text);
                }
            } else if (type == DxTypes.EOF_DOC_COMMENT_START || type == DxTypes.DOC_COMMENT_START) {
                if (description.length() > 0) {
                    description.append("\n");
                }
            } else {
                if (type == DxTypes.DOC_TAG && stopName.equals(((DxDocTag)element).getName()) || type == DxTypes.DOC_COMMENT_END) break;
                description.append(text);
            }
            element = comment.nextSibling(element);
        }
        String descriptionText = StringUtil.trimTrailing((String)description.toString());
        tag.addText(StringUtil.trimStart((String)descriptionText, (String)"\n"));
        if (element != null) {
            return comment.nextSibling(element);
        }
        return null;
    }

    @NotNull
    private static Result processWS(@NotNull Comment comment, @NotNull PsiElement element) {
        if (comment == null) {
            DxCommentProcessor.$$$reportNull$$$0(17);
        }
        if (element == null) {
            DxCommentProcessor.$$$reportNull$$$0(18);
        }
        int breaks = 0;
        while (element != null) {
            IElementType type = element.getNode().getElementType();
            if (type == TokenType.WHITE_SPACE) {
                breaks += StringUtil.getLineBreakCount((CharSequence)element.getText());
            } else {
                if (type != DxTypes.DOC_COMMENT_START && type != DxTypes.EOF_DOC_COMMENT_START) break;
                ++breaks;
            }
            element = comment.nextSibling(element);
        }
        boolean proceed = breaks <= 1;
        return new Result(element, proceed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 8, 9, 10, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentGroup";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processDocData";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processTag";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDocData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processTag";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processSurroundTag";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processWS";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 8, 9, 10, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    private static class Comment {
        private int idx;
        private final List<PsiComment> comments;

        Comment(@NotNull List<PsiComment> comments) {
            if (comments == null) {
                Comment.$$$reportNull$$$0(0);
            }
            this.idx = 0;
            this.comments = comments;
        }

        @Nullable
        public PsiElement getFistChild() {
            return this.getFirstElementChild(0);
        }

        @Nullable
        private PsiElement getFirstElementChild(int index) {
            DxDocComment docComment;
            if (index < this.comments.size() && (docComment = DoxygenUtil.convertToDoxygen(this.comments.get(index))) != null) {
                return docComment.getFirstChild();
            }
            return null;
        }

        public PsiElement nextSibling(@NotNull PsiElement element) {
            PsiElement next;
            if (element == null) {
                Comment.$$$reportNull$$$0(1);
            }
            if ((next = element.getNextSibling()) == null) {
                return this.getFirstElementChild(++this.idx);
            }
            return next;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessor$Comment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextSibling";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Result {
        public final PsiElement element;
        public final boolean proceed;

        Result(PsiElement element, boolean proceed) {
            this.element = element;
            this.proceed = proceed;
        }
    }
}

