/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.util.registry.Registry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrCatchTestUtil {
    @NonNls
    public static final String NULL_TAG_PRESENTATION_NAME = "non-tagged";
    private static final Pattern TAG = Pattern.compile("(\\[[^\\[\\]]*])");
    private static final Pattern TAGS_VALIDATION = Pattern.compile("(?:\\[[^\\[\\]]*]\\s*)*");

    @Contract(value="null -> true")
    public static boolean isValidStringOfTags(@Nullable String tagsInLine) {
        if (tagsInLine == null || tagsInLine.equals(NULL_TAG_PRESENTATION_NAME)) {
            return true;
        }
        return TAGS_VALIDATION.matcher(tagsInLine.trim()).matches();
    }

    @NotNull
    public static Set<String> splitTags(@Nullable String tags) {
        if (tags == null || tags.equals(NULL_TAG_PRESENTATION_NAME)) {
            Set<String> set = Collections.singleton(NULL_TAG_PRESENTATION_NAME);
            if (set == null) {
                CidrCatchTestUtil.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = TAG.matcher(tags);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            CidrCatchTestUtil.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static int getInternalCatchVersion() {
        return Integer.min(2, Integer.max(0, Registry.intValue((String)"cidr.test.framework.catch.default.version", (int)1) - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestUtil", "splitTags"));
    }
}

