/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestListParserAndHolder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.execution.testing.tcatch.CatchTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchBundle;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCommandLineState;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLinker;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask,
CidrTestListParserAndHolder<CidrCatchTestLinker> {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = connection -> new CidrCatchTestRunConfigurationData((CidrTestRunConfiguration)connection);
    @NlsSafe
    public static final String FRAMEWORK_ID = "Catch Test";
    private volatile transient ArrayList<CidrCatchTestLinker> myLinkers;
    static final String TAG_PREFIX = "      ";
    static final String TEST_CONTINUE_PREFIX = "    ";
    static final String TEST_PREFIX = "  ";

    public CidrCatchTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myLinkers = null;
    }

    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        String string = this.myTestName;
        if (string == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void checkData() throws RuntimeConfigurationException {
        Project project = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn((Project)project)) {
            return;
        }
        if (this.myTestName == null && this.myTestSuite == null) {
            return;
        }
        Set<String> configTags = CidrCatchTestUtil.splitTags(this.myTestSuite);
        int tagGrammarCount = configTags.size();
        if (!CidrCatchTestUtil.isValidStringOfTags(this.myTestSuite)) {
            throw new RuntimeConfigurationError(CidrCatchBundle.message("catch.notValidTags", tagGrammarCount + 1, this.myTestSuite));
        }
        CidrTestLanguageSupport lang = CatchTestLanguageSupport.getInstance();
        if (!((Boolean)OCTestExecution.executeWithCachedValuesFast(() -> lang.hasTestElement(project, this.myTestSuite != null ? this.myTestSuite : "non-tagged", this.myTestName))).booleanValue()) {
            throw new RuntimeConfigurationError(this.myTestName == null ? CidrCatchBundle.message("catch.noTestsWithTags", tagGrammarCount, this.myTestSuite) : (this.myTestSuite == null ? CidrExecutionBundle.message((String)"test.testNotFound", (Object[])new Object[]{this.myTestName}) : CidrCatchBundle.message("catch.testNotFound", this.myTestName, tagGrammarCount, this.myTestSuite)));
        }
    }

    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        if (env == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        return new CidrCatchTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (executor == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(4);
        }
        if (target == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        return new CidrCatchTestConsoleProperties((RunConfiguration)this.myConfiguration, executor, target);
    }

    public synchronized List<CidrCatchTestLinker> getTestListCopy() {
        return this.myLinkers == null ? null : new ArrayList<CidrCatchTestLinker>(this.myLinkers);
    }

    public synchronized void clean() {
        this.myLinkers = null;
    }

    public synchronized void parse(@NotNull ProcessOutput output) {
        if (output == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        this.myLinkers = CidrCatchTestRunConfigurationData.parseOutputToLinkers(output.getStdout());
    }

    @NotNull
    private static ArrayList<CidrCatchTestLinker> parseOutputToLinkers(@NotNull String programOutputWithListOfTests) {
        if (programOutputWithListOfTests == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        ArrayList<CidrCatchTestLinker> ret = new ArrayList<CidrCatchTestLinker>();
        StringBuffer testName = new StringBuffer();
        String tags = null;
        Runnable storeTestInfo = () -> {
            if (testName.length() != 0) {
                ret.add(CidrCatchTestLinker.create(testName.toString()));
                testName.setLength(0);
            }
        };
        for (String line : StringUtil.splitByLinesDontTrim((String)programOutputWithListOfTests)) {
            if (line.startsWith(TAG_PREFIX)) {
                tags = line.substring(TAG_PREFIX.length());
                continue;
            }
            if (line.startsWith(TEST_CONTINUE_PREFIX)) {
                char ch;
                String nextTestNameLine = line.substring(TEST_CONTINUE_PREFIX.length());
                int testNameLength = testName.length();
                if (testNameLength > 0 && ("])}>.:;*+-=&/\\".indexOf(ch = testName.charAt(testNameLength - 1)) < 0 || testNameLength > 1 && testName.charAt(testNameLength - 2) == ' ')) {
                    boolean needSpace = true;
                    int nextTestNameLineLength = nextTestNameLine.length();
                    if (nextTestNameLineLength > 0) {
                        ch = nextTestNameLine.charAt(nextTestNameLineLength - 1);
                        char chS = nextTestNameLine.charAt(0);
                        boolean bl = needSpace = "[({<|".indexOf(ch) < 0 && "[({<|".indexOf(chS) < 0;
                    }
                    if (needSpace) {
                        testName.append(" ");
                    }
                }
                testName.append(nextTestNameLine);
                continue;
            }
            if (line.startsWith(TEST_PREFIX)) {
                storeTestInfo.run();
                testName.append(line.substring(TEST_PREFIX.length()));
                continue;
            }
            storeTestInfo.run();
        }
        storeTestInfo.run();
        ArrayList<CidrCatchTestLinker> arrayList = ret;
        if (arrayList == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programOutputWithListOfTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOutputToLinkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseOutputToLinkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }
}

