/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestIndexProvider;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestConstants;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestElements;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLinker;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrCatchTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static CidrCatchTestFramework getInstance() {
        return (CidrCatchTestFramework)CidrCatchTestFramework.getInstance(CidrCatchTestFramework.class);
    }

    public CidrCatchTestFramework() {
        super("Catch Test", new Class[]{OCMacroCall.class, OCDeclarator.class, OCFunctionDefinition.class});
    }

    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(0);
        }
        Map map = CidrTestIndexProvider.INSTANCE.gatherTestLinks(file, "catch");
        if (map == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(2);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = CidrCatchTestFramework.getFrameworkVersionUsingImportedMacro((PsiFile)file, (String)"INTERNAL_CATCH_TEST");
        if (cidrTestFrameworkVersion == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(3);
        }
        return cidrTestFrameworkVersion;
    }

    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ",";
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(4);
        }
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project, new OCSymbolKind[]{OCSymbolKind.FUNCTION_DECLARATION});
    }

    @Nullable
    public CidrTestScopeElement generateVirtualTestScopeElement(String suitePath, String testPath, @NotNull String testSource) {
        if (testSource == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(5);
        }
        return "catch".equals(testSource) ? CidrTestScopeElementImpl.createTestScopeElementForSuiteAndTest((String)suitePath, (String)testPath, this.getGenerator()) : null;
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return "catch://";
    }

    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        if (element == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(6);
        }
        return this.getTestObjectFromTestHolder(element, CidrCatchTestConstants.CATCH_TEST_MACRO_NAMES);
    }

    @Nullable
    protected CidrTestScopeElement createFileTestObjectIfPossible(@NotNull PsiFile file) {
        if (file == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(7);
        }
        return CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> "[#" + file.getVirtualFile().getNameWithoutExtension() + "]");
    }

    @NotNull
    public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function = CidrCatchTestElements.getGenerator();
        if (function == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(8);
        }
        return function;
    }

    @NotNull
    protected String getTestUrl(@NotNull CidrTestScopeElement element) {
        if (element == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(9);
        }
        String string = this.getProtocolPrefix() + CidrCatchTestLinker.getLocationWrapperIfNeed(element.getTestPath());
        if (string == null) {
            CidrCatchTestFramework.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestFramework";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSource";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestObjectsDirectly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameworkVersionDirectly";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestObjectsDirectly";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkVersionDirectly";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateVirtualTestScopeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractTest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileTestObjectIfPossible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 8, 10 -> new IllegalStateException(string);
        };
    }
}

