/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.radler.protocol.RadSymbolsHost;
import com.jetbrains.cidr.radler.util.MeasureSummary;
import com.jetbrains.rd.framework.IIdentities;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.model.DiagnosticsModel_PregeneratedKt;
import com.jetbrains.rider.model.RadMeasurements;
import com.jetbrains.rider.model.RadNamedTimeSpan;
import com.jetbrains.rider.model.RadResolveReferencesParams;
import com.jetbrains.rider.model.RadResolveReferencesProgressParams;
import com.jetbrains.rider.model.RadResolveReferencesStage;
import com.jetbrains.rider.model.RadResolveReferencesWorkAmountParams;
import com.jetbrains.rider.model.RadSymbolsModel_PregeneratedKt;
import com.jetbrains.rider.model.RdMemoryUsageIndicator;
import com.jetbrains.rider.model.RdMemoryUsageState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001ah\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u001a\b\u0002\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u00102\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u0010H\u0001\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a'\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0004\b%\u0010&\u001a \u0010'\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006*"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "ourSessionIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "measureResolve", "Lcom/jetbrains/cidr/radler/util/MeasureSummary;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "withIncludes", "", "threads", "", "workAmountCallback", "Lkotlin/Function2;", "Lcom/jetbrains/rider/model/RadResolveReferencesStage;", "", "progressCallback", "", "correctNativeMeasurements", "Lcom/jetbrains/rider/model/RadMeasurements;", "origMeasurements", "rssPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "getMemoryUsageRequesterV1", "Ljava/lang/Runnable;", "pid", "", "peakMemoryBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "getMemoryUsageRequesterV2", "timeout", "Lkotlin/time/Duration;", "getMemoryUsageRequesterV2-8Mi8wO0", "(JJLjava/util/concurrent/atomic/AtomicLong;)Ljava/lang/Runnable;", "runMemoryWatchdog", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadMeasurementUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadMeasurementUtil.kt\ncom/jetbrains/cidr/radler/util/RadMeasurementUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 5 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 6 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n1611#2,9:175\n1863#2:184\n1864#2:186\n1620#2:187\n295#2,2:191\n1#3:185\n1#3:211\n39#4,3:188\n43#4:205\n79#5,5:193\n113#5,7:198\n284#6,5:206\n14#7:212\n*S KotlinDebug\n*F\n+ 1 RadMeasurementUtil.kt\ncom/jetbrains/cidr/radler/util/RadMeasurementUtilKt\n*L\n62#1:175,9\n62#1:184\n62#1:186\n62#1:187\n82#1:191,2\n62#1:185\n126#1:211\n64#1:188,3\n64#1:205\n99#1:193,5\n99#1:198,7\n126#1:206,5\n27#1:212\n*E\n"})
public final class RadMeasurementUtilKt {
    @NotNull
    private static final Logger log;
    @NotNull
    private static final AtomicInteger ourSessionIdGenerator;
    private static final Pattern rssPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public static final MeasureSummary measureResolve(@NotNull Iterable<? extends VirtualFile> files, @NotNull Project project, boolean withIncludes, int threads, @NotNull Function2<? super RadResolveReferencesStage, ? super Integer, Unit> workAmountCallback2, @NotNull Function2<? super RadResolveReferencesStage, ? super String, Unit> progressCallback2) {
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(workAmountCallback2, (String)"workAmountCallback");
        Intrinsics.checkNotNullParameter(progressCallback2, (String)"progressCallback");
        Solution solution = SolutionHostExtensionsKt.getSolution((Project)project);
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        Iterable $this$mapNotNull$iv = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, files, (Project)project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)it, (Project)project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List ids = (List)destination$iv$iv;
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Long pid;
            Object v2;
            RdMemoryUsageIndicator rdIndicator;
            AtomicLong peakWorkingSet;
            int thisSessionId;
            Lifetime lt;
            block9: {
                void $this$firstOrNull$iv;
                lt = def$iv.getLifetime();
                boolean bl = false;
                thisSessionId = ourSessionIdGenerator.incrementAndGet();
                RadSymbolsHost.Companion.getInstance(project).addResolveReferencesWorkAmountListener(lt, (Function1<? super RadResolveReferencesWorkAmountParams, Unit>)((Function1)arg_0 -> RadMeasurementUtilKt.measureResolve$lambda$10$lambda$3(thisSessionId, workAmountCallback2, arg_0)));
                RadSymbolsHost.Companion.getInstance(project).addResolveReferencesProgressListener(lt, (Function1<? super RadResolveReferencesProgressParams, Unit>)((Function1)arg_0 -> RadMeasurementUtilKt.measureResolve$lambda$10$lambda$4(thisSessionId, progressCallback2, arg_0)));
                peakWorkingSet = new AtomicLong(0L);
                rdIndicator = DiagnosticsModel_PregeneratedKt.getDiagnosticsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getMemoryUsageIndicator();
                element$iv$iv$iv = (Iterable)ProtocolManager.Companion.getInstance().getProtocolHostsFlow();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IProtocolHostWithBackend host = (IProtocolHostWithBackend)element$iv;
                    boolean bl4 = false;
                    IIdentities iIdentities = host.getProtocol().getIdentity();
                    IProtocol iProtocol = solution.getProtocol();
                    Intrinsics.checkNotNull((Object)iProtocol);
                    if (!(iIdentities == iProtocol.getIdentity())) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            IProtocolHostWithBackend iProtocolHostWithBackend = v2;
            if (iProtocolHostWithBackend != null) {
                IProtocolHostWithBackend it = iProtocolHostWithBackend;
                boolean bl = false;
                Object object = it.getResharperProcess();
                v4 = object != null && (object = object.getResharperProcessHandler()) != null && (object = object.getProcess()) != null ? Long.valueOf(((Process)object).pid()) : null;
            } else {
                v4 = pid = null;
            }
            if (pid != null && (SystemInfoRt.isLinux || SystemInfoRt.isMac)) {
                log.info("Starting memory watchdog");
                RadMeasurementUtilKt.runMemoryWatchdog(pid, lt, peakWorkingSet);
            } else {
                log.info("Fallback to indicator");
                rdIndicator.getState().advise(lt, arg_0 -> RadMeasurementUtilKt.measureResolve$lambda$10$lambda$8(peakWorkingSet, arg_0));
            }
            log.info("RadMeasurements started");
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            RadMeasurements result$iv$iv = (RadMeasurements)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)RadSymbolsModel_PregeneratedKt.getRadSymbolsModel((Solution)solution).getResolveReferences()), (Object)new RadResolveReferencesParams(thisSessionId, ids, threads, withIncludes), (long)0L, (int)2, null);
            iProtocolHostWithBackend = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            RadMeasurements measurements = (RadMeasurements)iProtocolHostWithBackend.component1();
            long timeTaken = iProtocolHostWithBackend.component2-UwyO8pc();
            log.info("RadMeasurements finished");
            MeasureSummary measureSummary = new MeasureSummary(RadMeasurementUtilKt.correctNativeMeasurements(measurements), timeTaken, peakWorkingSet.get(), ids.size(), threads, null);
            return measureSummary;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    public static /* synthetic */ MeasureSummary measureResolve$default(Iterable iterable, Project project, boolean bl, int n, Function2 function2, Function2 function22, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 8;
        }
        if ((n2 & 0x10) != 0) {
            function2 = RadMeasurementUtilKt::measureResolve$lambda$0;
        }
        if ((n2 & 0x20) != 0) {
            function22 = RadMeasurementUtilKt::measureResolve$lambda$1;
        }
        return RadMeasurementUtilKt.measureResolve(iterable, project, bl, n, (Function2<? super RadResolveReferencesStage, ? super Integer, Unit>)function2, (Function2<? super RadResolveReferencesStage, ? super String, Unit>)function22);
    }

    private static final RadMeasurements correctNativeMeasurements(RadMeasurements origMeasurements) {
        ArrayList<RadNamedTimeSpan> correctedOps = new ArrayList<RadNamedTimeSpan>();
        for (RadNamedTimeSpan op : origMeasurements.getOperations()) {
            long correctedDuration = DurationKt.toDuration((long)(Duration.toLong-impl((long)op.getDuration-UwyO8pc(), (DurationUnit)DurationUnit.NANOSECONDS) * (long)100), (DurationUnit)DurationUnit.NANOSECONDS);
            correctedOps.add(new RadNamedTimeSpan(op.getTitle(), correctedDuration, null));
        }
        return new RadMeasurements((List)correctedOps, origMeasurements.getFilesNumber(), origMeasurements.getRefsNumber(), origMeasurements.getUnresolved());
    }

    private static final Runnable getMemoryUsageRequesterV1(long pid, AtomicLong peakMemoryBytes) {
        return () -> RadMeasurementUtilKt.getMemoryUsageRequesterV1$lambda$13(pid, peakMemoryBytes);
    }

    private static final Runnable getMemoryUsageRequesterV2-8Mi8wO0(long pid, long timeout, AtomicLong peakMemoryBytes) {
        return () -> RadMeasurementUtilKt.getMemoryUsageRequesterV2_8Mi8wO0$lambda$15(pid, peakMemoryBytes, timeout);
    }

    private static final void runMemoryWatchdog(long pid, Lifetime lifetime, AtomicLong peakMemoryBytes) {
        Runnable requestState = RadMeasurementUtilKt.getMemoryUsageRequesterV2-8Mi8wO0(pid, DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS), peakMemoryBytes);
        ScheduledFuture<?> future = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(requestState, 1000L, 3000L, TimeUnit.MILLISECONDS);
        lifetime.onTermination(() -> RadMeasurementUtilKt.runMemoryWatchdog$lambda$16(future));
    }

    private static final Unit measureResolve$lambda$0(RadResolveReferencesStage radResolveReferencesStage, int n) {
        Intrinsics.checkNotNullParameter((Object)radResolveReferencesStage, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit measureResolve$lambda$1(RadResolveReferencesStage radResolveReferencesStage, String string) {
        Intrinsics.checkNotNullParameter((Object)radResolveReferencesStage, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit measureResolve$lambda$10$lambda$3(int $thisSessionId, Function2 $workAmountCallback, RadResolveReferencesWorkAmountParams it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getSessionId() == $thisSessionId) {
            $workAmountCallback.invoke((Object)it.getStage(), (Object)it.getAmount());
            log.info("new work amount = [" + it.getStage() + ", " + it.getAmount() + "]");
        }
        return Unit.INSTANCE;
    }

    private static final Unit measureResolve$lambda$10$lambda$4(int $thisSessionId, Function2 $progressCallback, RadResolveReferencesProgressParams it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getSessionId() == $thisSessionId) {
            $progressCallback.invoke((Object)it.getStage(), (Object)it.getFilePath());
            log.info("progress = [" + it.getStage() + ", " + it.getFilePath() + "]");
        }
        return Unit.INSTANCE;
    }

    private static final long measureResolve$lambda$10$lambda$8$lambda$7(long prevWS, long newWS) {
        return Math.max(prevWS, newWS);
    }

    private static final Unit measureResolve$lambda$10$lambda$8(AtomicLong $peakWorkingSet, RdMemoryUsageState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $peakWorkingSet.accumulateAndGet(it.getWorkingSet(), RadMeasurementUtilKt::measureResolve$lambda$10$lambda$8$lambda$7);
        log.info("Peak memory = " + $peakWorkingSet.get());
        return Unit.INSTANCE;
    }

    private static final long getMemoryUsageRequesterV1$lambda$13$lambda$12$lambda$11(long prevWS, long newWS) {
        return Math.max(prevWS, newWS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getMemoryUsageRequesterV1$lambda$13(long $pid, AtomicLong $peakMemoryBytes) {
        if (log.isTraceEnabled()) {
            log.trace("measuring backend (pid=" + $pid + ") memory via /proc/" + $pid + "/status");
        }
        try {
            File $this$useLines_u24default$iv = new File("/proc/" + $pid + "/status");
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines_u24default$iv;
            int n = 8192;
            Object object2 = object;
            object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                for (String line : it) {
                    Matcher m;
                    if (log.isTraceEnabled()) {
                        log.trace("status line: " + line);
                    }
                    if (!(m = rssPattern.matcher(line)).matches()) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("found RSS: " + line);
                    }
                    String rss = m.group(1);
                    Intrinsics.checkNotNull((Object)rss);
                    long rssNum = Long.parseLong(rss) * (long)1024;
                    $peakMemoryBytes.accumulateAndGet(rssNum, RadMeasurementUtilKt::getMemoryUsageRequesterV1$lambda$13$lambda$12$lambda$11);
                    break;
                }
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Throwable thr) {
            log.error("exception happened when measuring backend (pid=" + $pid + ") memory v1", thr);
        }
    }

    private static final long getMemoryUsageRequesterV2_8Mi8wO0$lambda$15$lambda$14(long prevWS, long newWS) {
        return Math.max(prevWS, newWS);
    }

    private static final void getMemoryUsageRequesterV2_8Mi8wO0$lambda$15(long $pid, AtomicLong $peakMemoryBytes, long $timeout) {
        if (log.isTraceEnabled()) {
            log.trace("measuring backend (pid=" + $pid + ") memory via ps and grep");
        }
        try {
            String[] stringArray = new String[]{"ps", "-p", String.valueOf($pid), "-o", "rss="};
            Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String line = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
            Intrinsics.checkNotNull((Object)line);
            String rss = ((Object)StringsKt.trim((CharSequence)line)).toString();
            long rssNum = Long.parseLong(rss) * (long)1024;
            $peakMemoryBytes.accumulateAndGet(rssNum, RadMeasurementUtilKt::getMemoryUsageRequesterV2_8Mi8wO0$lambda$15$lambda$14);
            if (!process.waitFor(Duration.toLong-impl((long)$timeout, (DurationUnit)DurationUnit.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                process.destroy();
                return;
            }
        }
        catch (Throwable thr) {
            log.error("exception happened when measuring backend (pid=" + $pid + ") memory v2", thr);
        }
    }

    private static final Unit runMemoryWatchdog$lambda$16(ScheduledFuture $future) {
        $future.cancel(true);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadMeasurements.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        ourSessionIdGenerator = new AtomicInteger(0);
        rssPattern = Pattern.compile("VmRSS:\\s+([0-9]+)\\s+kB.*");
    }
}

