/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestNoIndexSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.radler.protocol.RadCacheState;
import com.jetbrains.cidr.radler.testing.RadTestElement;
import com.jetbrains.cidr.radler.testing.RadTestLanguageSupportKt;
import com.jetbrains.cidr.radler.testing.RadTestPsiElement;
import com.jetbrains.cidr.radler.util.RdCallUtilKt;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.cpp.fileType.psi.CppFile;
import com.jetbrains.rider.model.RadCacheStateModel_PregeneratedKt;
import com.jetbrains.rider.model.RadFindTestParams;
import com.jetbrains.rider.model.RadTestElementModel;
import com.jetbrains.rider.model.RadTestFramework;
import com.jetbrains.rider.model.RadTestLocation;
import com.jetbrains.rider.model.RadUnitTestsModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u001fj\b\u0012\u0004\u0012\u00020\u0018` 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0004J6\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0%0$2\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0%0$0'H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/radler/testing/RadTestLanguageSupport;", "Lcom/jetbrains/cidr/execution/testing/CidrTestLanguageSupport;", "framework", "Lcom/jetbrains/rider/model/RadTestFramework;", "separator", "", "<init>", "(Lcom/jetbrains/rider/model/RadTestFramework;Ljava/lang/String;)V", "getFramework", "()Lcom/jetbrains/rider/model/RadTestFramework;", "getSeparator", "()Ljava/lang/String;", "myProtocolPrefix", "getProtocolPrefix", "getPatternSeparatorInCommandLine", "getProjectSourcesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "findTestObject", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "element", "Lcom/intellij/psi/PsiElement;", "createAllFileTests", "getElementsInFile", "", "createTestElement", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "test", "Lcom/jetbrains/rider/model/RadTestElementModel;", "getLocationSafe", "", "Lcom/intellij/execution/Location;", "findLocationsInScope", "Lcom/intellij/openapi/util/Computable;", "isIndexing", "areSymbolsLoaded", "getLocationCacheModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "intellij.rider.plugins.clion.radler"})
public abstract class RadTestLanguageSupport
implements CidrTestLanguageSupport {
    @NotNull
    private final RadTestFramework framework;
    @NotNull
    private final String separator;
    @NotNull
    private final String myProtocolPrefix;

    public RadTestLanguageSupport(@NotNull RadTestFramework framework, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        this.framework = framework;
        this.separator = separator;
        this.myProtocolPrefix = RadTestLanguageSupportKt.toURLSchema(this.framework) + "://";
    }

    @NotNull
    public final RadTestFramework getFramework() {
        return this.framework;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public String getProtocolPrefix() {
        return this.myProtocolPrefix;
    }

    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return this.separator;
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return globalSearchScope;
    }

    public boolean isAvailable(@Nullable PsiFile file) {
        return CidrTestNoIndexSupport.findCachedTestObject((PsiElement)((PsiElement)file), (String)this.myProtocolPrefix) != null || file != null && file instanceof CppFile && !this.getElementsInFile(file).isEmpty();
    }

    @Nullable
    public CidrTestScopeElement findTestObject(@Nullable PsiElement element) {
        CidrTestScopeElement findCachedTestObject = CidrTestNoIndexSupport.findCachedTestObject((PsiElement)element, (String)this.myProtocolPrefix);
        if (findCachedTestObject != null) {
            return findCachedTestObject;
        }
        if (element instanceof PsiFile) {
            return this.createAllFileTests((PsiFile)element);
        }
        if (!(element instanceof RadTestPsiElement) || ((RadTestPsiElement)element).getTest().getFramework() != this.framework) {
            return null;
        }
        return new RadTestElement((RadTestPsiElement)element);
    }

    @NotNull
    protected CidrTestScopeElement createAllFileTests(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CidrTestScopeElement cidrTestScopeElement = CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> RadTestLanguageSupport.createAllFileTests$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)cidrTestScopeElement, (String)"createTestScopeElementForFile(...)");
        return cidrTestScopeElement;
    }

    @NotNull
    public Collection<? extends CidrTestScopeElement> getElementsInFile(@NotNull PsiFile file) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)virtualFile, (Project)project2));
        if (projectModelEntity == null || (n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)project2)) == null) {
            return new ArrayList();
        }
        int fileId = n;
        List list = (List)RdCallUtilKt.callSomehow(RadUnitTestsModel_PregeneratedKt.getRadUnitTestsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project2)).getFindTests(), new RadFindTestParams(this.framework, Integer.valueOf(fileId), null, null, false, false, 60, null), ApplicationProtocolKt.getProtocol((Project)project2));
        if (list == null) {
            return new ArrayList();
        }
        List elements = list;
        ArrayList<RadTestElement> cidrElements = new ArrayList<RadTestElement>();
        for (RadTestElementModel e : elements) {
            if (e.getLocations() == null) continue;
            List list2 = e.getLocations();
            Intrinsics.checkNotNull((Object)list2);
            for (RadTestLocation l : list2) {
                if (l.getFile() != fileId) continue;
                cidrElements.add(new RadTestElement(new RadTestPsiElement(file, e, RangeUtilKt.toIdeaRange((RdTextRange)l.getRange()))));
            }
        }
        return cidrElements;
    }

    @NotNull
    protected final ArrayList<CidrTestScopeElement> createTestElement(@NotNull Project project, @NotNull RadTestElementModel test) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psi = psiManager;
        WorkspaceModel pm = WorkspaceModel.Companion.getInstance(project);
        ArrayList<CidrTestScopeElement> testScopes = new ArrayList<CidrTestScopeElement>();
        if (test.getLocations() != null) {
            List list = test.getLocations();
            Intrinsics.checkNotNull((Object)list);
            for (RadTestLocation l : list) {
                ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)pm, (int)l.getFile());
                if (projectModelEntity != null && (projectModelEntity = projectModelEntity.getUrl()) != null) {
                    PsiFile file;
                    if ((projectModelEntity = VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectModelEntity)) == null || psi.findFile((VirtualFile)projectModelEntity) == null) continue;
                    testScopes.add(new RadTestElement(new RadTestPsiElement(file, test, RangeUtilKt.toIdeaRange((RdTextRange)l.getRange()))));
                }
            }
        }
        return testScopes;
    }

    @NotNull
    public List<Location<PsiElement>> getLocationSafe(@NotNull Project project, @NotNull Computable<List<Location<PsiElement>>> findLocationsInScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(findLocationsInScope, (String)"findLocationsInScope");
        Object object = findLocationsInScope.compute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    public boolean isIndexing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)RadCacheStateModel_PregeneratedKt.getRadCacheStateModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).isIdle()));
    }

    public boolean areSymbolsLoaded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RadCacheState cache = RadCacheState.Companion.getInstance(project);
        return cache.isInitialUpdateFinished() && cache.isIdle();
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IOptProperty modificationCount = RadUnitTestsModel_PregeneratedKt.getRadUnitTestsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getModificationCount();
        return () -> RadTestLanguageSupport.getLocationCacheModificationTracker$lambda$1(modificationCount);
    }

    private static final String createAllFileTests$lambda$0(PsiFile $file) {
        return "all-tests(" + $file.getVirtualFile().getUrl() + ")";
    }

    private static final long getLocationCacheModificationTracker$lambda$1(IOptProperty $modificationCount) {
        return ((Number)InterfacesKt.valueOrDefault((IOptProperty)$modificationCount, (Object)0L)).longValue();
    }
}

