/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.testing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.testing.CidrHighlighterNotifierService;
import com.jetbrains.cidr.radler.testing.RadTestElement;
import com.jetbrains.cidr.radler.testing.RadTestGutterHandlerKt;
import com.jetbrains.cidr.radler.testing.RadTestPsiElement;
import com.jetbrains.cidr.radler.testing.TestLineMarkerContributor;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rider.intentions.ImportantNonMergableGutterMark;
import com.jetbrains.rider.model.RadTestElementModel;
import com.jetbrains.rider.model.RadUnitTestHighlighter;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/radler/testing/RadTestGutterHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/psi/PsiFile;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rider.plugins.clion.radler"})
public final class RadTestGutterHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;

    public RadTestGutterHandler(@NotNull Project project, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof RadUnitTestHighlighter;
    }

    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                if (!(model instanceof RadUnitTestHighlighter)) {
                    return;
                }
                if (((RadUnitTestHighlighter)model).getTest() == null) break block4;
                RadTestElementModel radTestElementModel = ((RadUnitTestHighlighter)model).getTest();
                Intrinsics.checkNotNull((Object)radTestElementModel);
                if (RadTestGutterHandlerKt.access$isRadFrameworkPluginEnabled(radTestElementModel.getFramework())) break block5;
            }
            return;
        }
        RadTestElementModel radTestElementModel = ((RadUnitTestHighlighter)model).getTest();
        Intrinsics.checkNotNull((Object)radTestElementModel);
        String testUrl = RadTestElement.Companion.getCidrTestPath(radTestElementModel);
        CidrHighlighterNotifierService cidrHighlighterNotifierService = CidrHighlighterNotifierService.getInstance((Project)this.project);
        TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)highlighter));
        Intrinsics.checkNotNull((Object)textRange);
        cidrHighlighterNotifierService.fireLineMarkCreated(testUrl, textRange);
        Icon icon = TestLineMarkerContributor.Companion.getTestStateIcon(testUrl, this.project);
        RadTestElementModel radTestElementModel2 = ((RadUnitTestHighlighter)model).getTest();
        Intrinsics.checkNotNull((Object)radTestElementModel2);
        TextRange textRange2 = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)highlighter));
        Intrinsics.checkNotNull((Object)textRange2);
        LineMarkerInfo lineMarkerInfo = RunLineMarkerProvider.createLineMarker((PsiElement)((PsiElement)new RadTestPsiElement(this.file, radTestElementModel2, textRange2)), (Icon)icon, (List)CollectionsKt.listOf((Object)RunLineMarkerContributor.withExecutorActions((Icon)icon)));
        Intrinsics.checkNotNullExpressionValue((Object)lineMarkerInfo, (String)"createLineMarker(...)");
        LineMarkerInfo lineMarker = lineMarkerInfo;
        highlighter.setGutterIconRenderer((GutterIconRenderer)new ImportantNonMergableGutterMark((LineMarkerInfo<PsiElement>)lineMarker, testUrl, this){
            private final GutterIconRenderer originalRenderer;
            final /* synthetic */ String $testUrl;
            final /* synthetic */ RadTestGutterHandler this$0;
            {
                this.$testUrl = $testUrl;
                this.this$0 = $receiver;
                super($lineMarker);
                this.originalRenderer = $lineMarker.createGutterRenderer();
            }

            public final GutterIconRenderer getOriginalRenderer() {
                return this.originalRenderer;
            }

            public Icon getIcon() {
                return TestLineMarkerContributor.Companion.getTestStateIcon(this.$testUrl, this.this$0.getProject());
            }

            public AnAction getClickAction() {
                return this.originalRenderer.getClickAction();
            }

            public boolean isNavigateAction() {
                return this.originalRenderer.isNavigateAction();
            }

            public ActionGroup getPopupMenuActions() {
                return this.originalRenderer.getPopupMenuActions();
            }

            public GutterIconRenderer.Alignment getAlignment() {
                return GutterIconRenderer.Alignment.LEFT;
            }
        });
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
    }

    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter);
    }

    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RadUnitTestHighlighter cfr_ignored_0 = (RadUnitTestHighlighter)model;
        return (HighlighterModel)new RadUnitTestHighlighter(((RadUnitTestHighlighter)model).getTest(), model.getLayer(), model.isExactRange(), model.getDocumentVersion(), false, false, false, model.getTextToHighlight(), model.getTextAttributesKey(), model.getId(), model.getProperties(), startOffset, endOffset);
    }
}

