/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.symbols;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationProducer;
import com.jetbrains.cidr.radler.symbols.RadMainPsiElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rider.intentions.ImportantNonMergableGutterMark;
import com.jetbrains.rider.model.RadMainRunnerHighlighter;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/radler/symbols/RadMainGutterHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/psi/PsiFile;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadRunMainMarkerModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadRunMainMarkerModelSupport.kt\ncom/jetbrains/cidr/radler/symbols/RadMainGutterHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1755#2,3:103\n*S KotlinDebug\n*F\n+ 1 RadRunMainMarkerModelSupport.kt\ncom/jetbrains/cidr/radler/symbols/RadMainGutterHandler\n*L\n40#1:103,3\n*E\n"})
public final class RadMainGutterHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;

    public RadMainGutterHandler(@NotNull Project project, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof RadMainRunnerHighlighter;
    }

    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        boolean hasExecutableTarget;
        block5: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            if (!(model instanceof RadMainRunnerHighlighter)) {
                return;
            }
            List list = CidrTargetRunConfigurationProducer.getInstances((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstances(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CidrTargetRunConfigurationProducer it = (CidrTargetRunConfigurationProducer)element$iv;
                    boolean bl = false;
                    List list2 = it.getExecutableTargetsForFile(this.file);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutableTargetsForFile(...)");
                    boolean bl2 = !((Collection)list2).isEmpty();
                    if (!bl2) continue;
                    v1 = true;
                    break block5;
                }
                v1 = hasExecutableTarget = false;
            }
        }
        if (!hasExecutableTarget) {
            return;
        }
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Run");
        Icon icon2 = icon;
        TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)highlighter));
        Intrinsics.checkNotNull((Object)textRange);
        LineMarkerInfo lineMarkerInfo = RunLineMarkerProvider.createLineMarker((PsiElement)((PsiElement)new RadMainPsiElement(this.file, textRange)), (Icon)icon2, (List)CollectionsKt.listOf((Object)new RunLineMarkerContributor.Info(icon2, ExecutorAction.Companion.getActions$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null), null)));
        Intrinsics.checkNotNullExpressionValue((Object)lineMarkerInfo, (String)"createLineMarker(...)");
        LineMarkerInfo lineMarker = lineMarkerInfo;
        highlighter.setGutterIconRenderer((GutterIconRenderer)new ImportantNonMergableGutterMark((LineMarkerInfo<PsiElement>)lineMarker){
            private final GutterIconRenderer originalRenderer;
            {
                this.originalRenderer = $lineMarker.createGutterRenderer();
            }

            public final GutterIconRenderer getOriginalRenderer() {
                return this.originalRenderer;
            }

            public AnAction getClickAction() {
                return this.originalRenderer.getClickAction();
            }

            public boolean isNavigateAction() {
                return this.originalRenderer.isNavigateAction();
            }

            public ActionGroup getPopupMenuActions() {
                return this.originalRenderer.getPopupMenuActions();
            }

            public GutterIconRenderer.Alignment getAlignment() {
                return GutterIconRenderer.Alignment.LEFT;
            }
        });
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
    }

    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter);
    }

    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RadMainRunnerHighlighter cfr_ignored_0 = (RadMainRunnerHighlighter)model;
        return (HighlighterModel)new RadMainRunnerHighlighter(((RadMainRunnerHighlighter)model).getComment(), model.getLayer(), model.isExactRange(), model.getDocumentVersion(), false, false, false, model.getTextToHighlight(), model.getTextAttributesKey(), model.getId(), model.getProperties(), startOffset, endOffset);
    }
}

