/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesProvider;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.radler.projectmodel.ExtractedPreprocessorInfo;
import com.jetbrains.cidr.radler.projectmodel.PreprocessorFeatures;
import com.jetbrains.cidr.radler.projectmodel.RadDefinesParser;
import com.jetbrains.cidr.radler.projectmodel.RadProjectModelHost;
import com.jetbrains.cidr.radler.util.RdCollectionUtilKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rider.cpp.fileType.CppFileType;
import com.jetbrains.rider.model.RadCompilerKind;
import com.jetbrains.rider.model.RadCoroutineMode;
import com.jetbrains.rider.model.RadGnuNullUnderlyingType;
import com.jetbrains.rider.model.RadLanguageDialect;
import com.jetbrains.rider.model.RadLanguageKind;
import com.jetbrains.rider.model.RadLanguageStandard;
import com.jetbrains.rider.model.RadProjectModel;
import com.jetbrains.rider.model.RadProjectModel_PregeneratedKt;
import com.jetbrains.rider.model.RadSizeTUnderlyingType;
import com.jetbrains.rider.model.RadSourceFileSettings;
import com.jetbrains.rider.model.RadTargetArchitecture;
import com.jetbrains.rider.model.RadToolsetSettings;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 p2\u00020\u0001:\u0004mnopB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0007J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ2\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u001c\u0010\"\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0$\u0012\u0006\u0012\u0004\u0018\u00010%0#H\u0086@\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001eH\u0086@\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020(H\u0007J\b\u0010/\u001a\u00020(H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u000102H\u0002J$\u00103\u001a\u0004\u0018\u00010\u00122\u0006\u00104\u001a\u0002022\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108H\u0002JN\u00109\u001a\u00020(2\"\u0010:\u001a\u001e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020<0;j\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020<`=2\u0016\u0010>\u001a\u0012\u0012\u0004\u0012\u0002080?j\b\u0012\u0004\u0012\u000208`@2\b\u0010A\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u000206H\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010\u00122\u0006\u0010E\u001a\u0002062\u0006\u0010G\u001a\u00020HH\u0002J\u0012\u0010I\u001a\u00020J2\b\u0010I\u001a\u0004\u0018\u00010KH\u0002J\u0014\u0010L\u001a\u00020\u00192\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014J\u0016\u0010N\u001a\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0012\u0010Q\u001a\u00020\u001b2\b\u0010I\u001a\u0004\u0018\u00010KH\u0002J(\u0010R\u001a\u00020\u001b2\b\u0010I\u001a\u0004\u0018\u00010K2\u0006\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J^\u0010V\u001a\u00020W2\u0014\u0010X\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030Z\u0012\u0002\b\u00030Y2\u0006\u0010S\u001a\u00020T2\u0006\u0010[\u001a\u00020\u001b2\u0006\u0010\\\u001a\u00020\u001b2\u0006\u0010]\u001a\u00020\u001b2\u0006\u0010^\u001a\u00020\u001b2\u0006\u0010_\u001a\u00020\u001b2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0002J&\u0010d\u001a\u00020\u001e2\u0014\u0010e\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030Z\u0012\u0002\b\u00030Y2\u0006\u0010b\u001a\u00020cH\u0002J \u0010f\u001a\u00020g2\u0006\u0010S\u001a\u00020T2\u0006\u0010`\u001a\u00020a2\u0006\u0010[\u001a\u00020\u001bH\u0002J\u0018\u0010h\u001a\u00020g2\u0006\u0010`\u001a\u00020a2\u0006\u0010[\u001a\u00020\u001bH\u0002J\u0012\u0010i\u001a\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020lH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00160\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0014\u0012\u0004\u0012\u00020\u00190\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cppProject", "Lcom/jetbrains/rider/model/RadProjectModel;", "projectSyncQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "initialLoadScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "frontendVersion", "Ljava/util/concurrent/atomic/AtomicLong;", "backendVersion", "toolsetSettingsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSettingsKey;", "Lcom/jetbrains/rider/model/RadToolsetSettings;", "definesCache", "", "", "Lcom/jetbrains/cidr/radler/projectmodel/ExtractedPreprocessorInfo;", "dependenciesPathsCache", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$DependenciesPaths;", "isProjectLoaded", "", "isProjectSynced", "getSyncedVersion", "", "()Ljava/lang/Long;", "withSyncedProject", "T", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onBackendReload", "", "version", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleInitialProjectSync", "scheduleProjectSync", "isInitialLoad", "flushQueue", "sendProjectsToBackend", "getFallbackToolsetSettings", "fallbackConfig", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getToolsetSettingsForLanguageKind", "config", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "source", "Lcom/intellij/openapi/vfs/VirtualFile;", "sendDiffUpdate", "sources", "Ljava/util/HashMap;", "Lcom/jetbrains/rider/model/RadSourceFileSettings;", "Lkotlin/collections/HashMap;", "headers", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "fallback", "getProjectContentRoots", "convertLanguage", "Lcom/jetbrains/rider/model/RadLanguageKind;", "language", "convertSettings", "input", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings;", "compilerKind", "Lcom/jetbrains/rider/model/RadCompilerKind;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "extractDependenciesPaths", "inputHeadersSearchPaths", "extractCoroutineMode", "Lcom/jetbrains/rider/model/RadCoroutineMode;", "compilerFlags", "hasClangExtensions", "hasMSVCExtensions", "preprocessorFeatures", "Lcom/jetbrains/cidr/radler/projectmodel/PreprocessorFeatures;", "flags", "extractLanguageDialect", "Lcom/jetbrains/rider/model/RadLanguageDialect;", "compilerFeatures", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "msExtensions", "gnuExtensions", "gnuCompatible", "clangExtensions", "nonDefaultCoroutines", "targetArchitecture", "Lcom/jetbrains/rider/model/RadTargetArchitecture;", "provider", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$RadCompilerFeaturesProvider;", "packSupportedTypeTraits", "features", "getUnderlyingSizeType", "Lcom/jetbrains/rider/model/RadSizeTUnderlyingType;", "getUnderlyingSizeTypeFromArch", "languageStandard", "Lcom/jetbrains/rider/model/RadLanguageStandard;", "standard", "Lcom/jetbrains/cidr/lang/OCLanguageStandard;", "Listener", "DependenciesPaths", "RadCompilerFeaturesProvider", "Companion", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 6 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,759:1\n68#2,4:760\n68#2,4:780\n68#2,4:785\n68#2,4:789\n14#2:808\n13409#3,2:764\n3829#3:766\n4344#3,2:767\n1557#4:769\n1628#4,3:770\n1557#4:773\n1628#4,3:774\n1812#4,3:777\n1815#4:784\n39#5,3:793\n43#5:807\n18#6,4:796\n50#6,7:800\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost\n*L\n167#1:760,4\n678#1:780,4\n142#1:785,4\n146#1:789,4\n756#1:808\n379#1:764,2\n397#1:766\n397#1:767,2\n398#1:769\n398#1:770,3\n438#1:773\n438#1:774,3\n675#1:777,3\n675#1:784\n259#1:793,3\n259#1:807\n262#1:796,4\n262#1:800,7\n*E\n"})
public final class RadProjectModelHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RadProjectModel cppProject;
    @NotNull
    private final MergingUpdateQueue projectSyncQueue;
    @NotNull
    private final AtomicBoolean initialLoadScheduled;
    @NotNull
    private final AtomicLong frontendVersion;
    @NotNull
    private final AtomicLong backendVersion;
    @NotNull
    private final ConcurrentMap<CompilerSettingsKey, RadToolsetSettings> toolsetSettingsCache;
    @NotNull
    private final ConcurrentMap<List<String>, ExtractedPreprocessorInfo> definesCache;
    @NotNull
    private final ConcurrentMap<List<HeadersSearchPath>, DependenciesPaths> dependenciesPathsCache;
    @NotNull
    private static final Logger logger;

    public RadProjectModelHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cppProject = RadProjectModel_PregeneratedKt.getRadProjectModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        this.projectSyncQueue = new MergingUpdateQueue("updatingProjectQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, false).setRestartTimerOnAdd(false);
        this.initialLoadScheduled = new AtomicBoolean(false);
        this.frontendVersion = new AtomicLong(0L);
        this.backendVersion = new AtomicLong(0L);
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        this.toolsetSettingsCache = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakValueMap(...)");
        this.definesCache = concurrentMap2;
        ConcurrentMap concurrentMap3 = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"createConcurrentWeakValueMap(...)");
        this.dependenciesPathsCache = concurrentMap3;
        this.projectSyncQueue.setPassThrough(false);
    }

    public final boolean isProjectLoaded() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.cppProject.getLoaded())) && this.initialLoadScheduled.get();
    }

    @RequiresReadLock
    public final boolean isProjectSynced() {
        return this.getSyncedVersion() != null;
    }

    @RequiresReadLock
    @Nullable
    public final Long getSyncedVersion() {
        ThreadingAssertions.assertReadAccess();
        long backendVersion = this.backendVersion.get();
        long frontendVersion = this.frontendVersion.get();
        return backendVersion == frontendVersion ? Long.valueOf(backendVersion) : null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object withSyncedProject(@NotNull Function1<? super Continuation<? super T>, ? extends Object> var1_1, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof withSyncedProject.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RadProjectModelHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.withSyncedProject(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attempts = new Ref.IntRef();
                maxAttempts = 50;
lbl15:
                // 4 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = action;
                    $continuation.L$2 = attempts;
                    $continuation.L$3 = null;
                    $continuation.I$0 = maxAttempts;
                    $continuation.label = 1;
                    v0 = RadProjectModelHost.withSyncedProject$getVersionOrWait(this, $continuation);
                    if (v0 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl33
                    break;
                }
            }
            case 1: {
                maxAttempts = $continuation.I$0;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                this = (RadProjectModelHost)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                v1 = (Long)v0;
                if (v1 != null) ** GOTO lbl36
                ** GOTO lbl15
lbl36:
                // 1 sources

                versionBefore = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = action;
                $continuation.L$2 = attempts;
                $continuation.I$0 = maxAttempts;
                $continuation.J$0 = versionBefore;
                $continuation.label = 2;
                v2 = action.invoke($continuation);
                if (v2 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl55
            }
            case 2: {
                versionBefore = $continuation.J$0;
                maxAttempts = $continuation.I$0;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                this = (RadProjectModelHost)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                result = v2;
                var8_10 = attempts.element;
                attempts.element = var8_10 + 1;
                if (!(attempts.element <= maxAttempts)) {
                    $i$a$-require-RadProjectModelHost$withSyncedProject$2 = false;
                    var9_13 = "Possible infinite loop detected, project model was updated " + maxAttempts + " times while we were trying to execute the action. Check that your action doesn't trigger project model update in any way";
                    throw new IllegalArgumentException(var9_13.toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = action;
                $continuation.L$2 = attempts;
                $continuation.L$3 = result;
                $continuation.I$0 = maxAttempts;
                $continuation.J$0 = versionBefore;
                $continuation.label = 3;
                v3 = RadProjectModelHost.withSyncedProject$getVersionOrWait(this, $continuation);
                if (v3 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl83
            }
            case 3: {
                versionBefore = $continuation.J$0;
                maxAttempts = $continuation.I$0;
                result = $continuation.L$3;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                this = (RadProjectModelHost)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl83:
                // 2 sources

                v4 = (Long)v3;
                if (v4 != null) ** GOTO lbl86
                ** GOTO lbl15
lbl86:
                // 1 sources

                versionAfter = v4;
                if (versionBefore == versionAfter) ** break;
                ** continue;
                $this$trace$iv = RadProjectModelHost.logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var13_16 = $this$trace$iv;
                    $i$a$-trace-RadProjectModelHost$withSyncedProject$3 = false;
                    var13_16.trace("Action executed in " + attempts.element + " (of " + maxAttempts + " possible) with version " + versionAfter);
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object onBackendReload(long version, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.writeAction(() -> RadProjectModelHost.onBackendReload$lambda$5(this, version), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void scheduleInitialProjectSync() {
        boolean isInitialLoad = this.initialLoadScheduled.compareAndSet(false, true);
        this.scheduleProjectSync(isInitialLoad);
    }

    private final void scheduleProjectSync() {
        if (this.initialLoadScheduled.get()) {
            this.scheduleProjectSync(false);
        }
    }

    private final void scheduleProjectSync(boolean isInitialLoad) {
        logger.info("Scheduling C++ project model sync" + (isInitialLoad ? " (initial load)" : ""));
        this.projectSyncQueue.queue(Update.Companion.create((Object)("DoProjectSync(" + isInitialLoad + ")"), () -> RadProjectModelHost.scheduleProjectSync$lambda$9(this, isInitialLoad)));
    }

    @TestOnly
    public final void flushQueue() {
        logger.info("Flushing C++ project model queue");
        this.projectSyncQueue.flush();
    }

    private final void sendProjectsToBackend() {
        Object configuration2;
        HashSet sources = new HashSet();
        List list = OCWorkspace.getInstance((Project)this.project).getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
        List configurations = list;
        for (Object configuration2 : configurations) {
            sources.addAll(configuration2.getSources());
        }
        HashMap<VirtualFile, RadSourceFileSettings> newSources = new HashMap<VirtualFile, RadSourceFileSettings>();
        Iterator iterator = sources.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        configuration2 = iterator;
        while (configuration2.hasNext()) {
            OCLanguageKind languageKind;
            OCResolveConfiguration configuration3;
            Object e = configuration2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            VirtualFile source = (VirtualFile)e;
            if (OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)source, (Project)this.project) == null || configuration3.getDeclaredLanguageKind(source) == null) continue;
            RadToolsetSettings toolsetSettings = this.getToolsetSettingsForLanguageKind(configuration3, languageKind, source);
            if (toolsetSettings == null) {
                logger.warn("Could not convert compiler settings to R++ format for " + (VirtualFile)source);
                continue;
            }
            Map map = newSources;
            String string = configuration3.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            RadSourceFileSettings radSourceFileSettings = new RadSourceFileSettings(toolsetSettings, string);
            map.put(source, radSourceFileSettings);
        }
        HashSet<VirtualFile> newHeaders = new HashSet<VirtualFile>();
        for (VirtualFile file : OCExplicitSourcesSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.project)) {
            if (!(file.getFileType() instanceof CppFileType) || newSources.containsKey(file)) continue;
            newHeaders.add(file);
        }
        OCResolveConfiguration fallbackConfig = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)this.project, (Collection)((Collection)configurations)).first;
        RadToolsetSettings newFallback = this.getFallbackToolsetSettings(fallbackConfig);
        if (newFallback == null) {
            logger.info("refusing to send headers without the fallback configuration");
            newHeaders.clear();
        }
        this.sendDiffUpdate(newSources, newHeaders, newFallback);
    }

    private final RadToolsetSettings getFallbackToolsetSettings(OCResolveConfiguration fallbackConfig) {
        RadToolsetSettings radToolsetSettings;
        block3: {
            if (fallbackConfig == null) {
                return null;
            }
            for (Object kind : new Object[]{CLanguageKind.CPP, CLanguageKind.C, CUDALanguageKind.CUDA}) {
                boolean bl = false;
                radToolsetSettings = this.getToolsetSettingsForLanguageKind(fallbackConfig, (OCLanguageKind)kind, null);
                if (radToolsetSettings == null) {
                    continue;
                }
                break block3;
            }
            radToolsetSettings = null;
        }
        return radToolsetSettings;
    }

    private final RadToolsetSettings getToolsetSettingsForLanguageKind(OCResolveConfiguration config, OCLanguageKind languageKind, VirtualFile source) {
        OCCompilerSettings oCCompilerSettings = config.getCompilerSettings(languageKind, source);
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerSettings, (String)"getCompilerSettings(...)");
        OCCompilerSettings compilerSettings = oCCompilerSettings;
        CompilerSettingsKey cachingKey = compilerSettings.getCachingKey();
        return cachingKey != null ? this.toolsetSettingsCache.computeIfAbsent(compilerSettings.getCachingKey(), arg_0 -> RadProjectModelHost.getToolsetSettingsForLanguageKind$lambda$12(arg_0 -> RadProjectModelHost.getToolsetSettingsForLanguageKind$lambda$11(this, languageKind, compilerSettings, arg_0), arg_0)) : this.convertSettings(languageKind, compilerSettings);
    }

    private final void sendDiffUpdate(HashMap<VirtualFile, RadSourceFileSettings> sources, HashSet<VirtualFile> headers, RadToolsetSettings fallback) {
        long frontendVersion = this.frontendVersion.get();
        logger.info("Sending updates, project model has " + sources.size() + " sources and " + headers.size() + " headers (version: " + frontendVersion + ")");
        RdCollectionUtilKt.replaceAll(this.cppProject.getSourceFiles(), SequencesKt.map((Sequence)MapsKt.asSequence((Map)sources), RadProjectModelHost::sendDiffUpdate$lambda$13));
        RdCollectionUtilKt.replaceAll(this.cppProject.getHeaderFiles(), SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)headers), RadProjectModelHost::sendDiffUpdate$lambda$14));
        if (!Intrinsics.areEqual((Object)fallback, (Object)this.cppProject.getFallback().getValue())) {
            this.cppProject.getFallback().set((Object)fallback);
        }
        RdCollectionUtilKt.replaceAll(this.cppProject.getSourceRoots(), (Iterable)this.getProjectContentRoots());
        Object object = ProjectImpl.PROJECT_PATH.get((UserDataHolder)this.project);
        Intrinsics.checkNotNull((Object)object);
        Path path = ((Path)object).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        String baseProjectPath = NioPathUtil.toCanonicalPath((Path)path);
        this.cppProject.getVersion().set((Object)frontendVersion);
        IOptProperty iOptProperty = this.cppProject.getName();
        String string = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        iOptProperty.set((Object)string);
        this.cppProject.getBasePath().set((Object)baseProjectPath);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = fileEditorManager.getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = fileEditorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor;
            FileEditor it = (FileEditor)element$iv;
            boolean bl = false;
            if (!(it instanceof TextEditor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TextEditor)it).getEditor(), (String)"getEditor(...)");
            if (!CodeFoldingManagerImpl.isAsyncFoldingUpdater((Editor)editor)) continue;
            FrontendEditorFoldingModelAdapter.Companion.setReloadingState(editor);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Sending " + IPrintableKt.printToString((Object)this.cppProject));
        }
        InterfacesKt.fire((ISignal)((ISignal)this.cppProject.getMustReload()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getProjectContentRoots() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)this.project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile element$iv$iv;
            element$iv$iv = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    private final RadLanguageKind convertLanguage(OCLanguageKind language) {
        RadLanguageKind radLanguageKind;
        OCLanguageKind oCLanguageKind = language;
        if (oCLanguageKind == CLanguageKind.C) {
            radLanguageKind = RadLanguageKind.C;
        } else if (oCLanguageKind == CLanguageKind.CPP) {
            radLanguageKind = RadLanguageKind.Cpp;
        } else if (oCLanguageKind == CUDALanguageKind.CUDA) {
            radLanguageKind = RadLanguageKind.Cpp;
        } else if (oCLanguageKind == CLanguageKind.OBJ_C) {
            logger.warn("Unsupported language: " + language + ", falling back to C");
            radLanguageKind = RadLanguageKind.C;
        } else if (oCLanguageKind == CLanguageKind.OBJ_CPP) {
            logger.warn("Unsupported language: " + language + ", falling back to Cpp");
            radLanguageKind = RadLanguageKind.Cpp;
        } else {
            radLanguageKind = null;
        }
        return radLanguageKind;
    }

    /*
     * WARNING - void declaration
     */
    private final RadToolsetSettings convertSettings(OCLanguageKind language, OCCompilerSettings input) {
        CidrCompilerSwitches compilerSwitches;
        CidrCompilerSwitches cidrCompilerSwitches;
        OCCompilerKind compilerKind;
        RadTargetArchitecture radTargetArchitecture;
        Short sizeOfSizeT;
        void $this$mapTo$iv$iv;
        OCLanguageStandard languageStandard;
        RadLanguageKind languageKind = this.convertLanguage(language);
        if (languageKind == null) {
            logger.warn("Unsupported language " + language);
            return null;
        }
        Object object = input.getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD);
        OCLanguageStandard oCLanguageStandard = languageStandard = object instanceof OCLanguageStandard ? (OCLanguageStandard)object : null;
        if (languageStandard == null) {
            logger.info("No language standard found");
            return null;
        }
        object = this.dependenciesPathsCache.computeIfAbsent(input.getHeadersSearchPaths(), arg_0 -> RadProjectModelHost.convertSettings$lambda$19(arg_0 -> RadProjectModelHost.convertSettings$lambda$18(this, arg_0), arg_0));
        List<String> includePaths = ((DependenciesPaths)object).component1();
        List<String> frameworkPaths = ((DependenciesPaths)object).component2();
        List list = input.getImplicitIncludes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImplicitIncludes(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtil.toSystemDependentName((String)it.getPath()));
        }
        List implicitIncludes = (List)destination$iv$iv;
        Short s = sizeOfSizeT = (Short)input.getCompilerFeatures().get(OCCompilerFeatures.TypeSize.POINTER);
        boolean bl = s != null ? s == 4 : false;
        if (bl) {
            radTargetArchitecture = RadTargetArchitecture.X86;
        } else {
            Short s2 = sizeOfSizeT;
            boolean bl2 = s2 != null ? s2 == 8 : false;
            if (bl2) {
                radTargetArchitecture = RadTargetArchitecture.AMD64;
            } else {
                logger.warn("R# can only handle size_t of size 4 or 8, CLion requests " + sizeOfSizeT + ". Assuming 4 instead.");
                radTargetArchitecture = RadTargetArchitecture.X86;
            }
        }
        RadTargetArchitecture targetArchitecture = radTargetArchitecture;
        ExtractedPreprocessorInfo extractedPreprocessorInfo = this.definesCache.computeIfAbsent(input.getPreprocessorDefines(), arg_0 -> RadProjectModelHost.convertSettings$lambda$22(RadProjectModelHost::convertSettings$lambda$21, arg_0));
        Object $i$f$mapTo22 = input.getCompilerFeatures().get(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND);
        OCCompilerKind oCCompilerKind = $i$f$mapTo22 instanceof OCCompilerKind ? (OCCompilerKind)$i$f$mapTo22 : null;
        if (oCCompilerKind == null) {
            oCCompilerKind = compilerKind = input.getCompilerKind();
        }
        if ((cidrCompilerSwitches = (iterator = input.getCompilerFeatures().get(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS)) instanceof CidrCompilerSwitches ? (CidrCompilerSwitches)iterator : null) == null) {
            cidrCompilerSwitches = input.getCompilerSwitches();
        }
        CidrCompilerSwitches cidrCompilerSwitches2 = compilerSwitches = cidrCompilerSwitches;
        List list2 = cidrCompilerSwitches2 != null ? cidrCompilerSwitches2.getList(CidrCompilerSwitches.Format.RAW) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List compilerFlags = list2;
        boolean gnuCompatible = compilerKind instanceof ClangClCompilerKind || extractedPreprocessorInfo.getFeatures().getHasGnuC();
        boolean gnuExtensions = gnuCompatible && !extractedPreprocessorInfo.getFeatures().getHasStrictAnsi();
        boolean msvcExtensions = this.hasMSVCExtensions(compilerKind, extractedPreprocessorInfo.getFeatures(), compilerFlags);
        boolean clangExtensions = this.hasClangExtensions(compilerKind);
        RadCoroutineMode coroutineMode = this.extractCoroutineMode(compilerFlags);
        Map map = input.getCompilerFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getCompilerFeatures(...)");
        RadCompilerFeaturesProvider provider = new RadCompilerFeaturesProvider(map, msvcExtensions, gnuExtensions, gnuCompatible, languageStandard);
        Map map2 = input.getCompilerFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getCompilerFeatures(...)");
        RadLanguageDialect languageDialect = this.extractLanguageDialect(map2, extractedPreprocessorInfo.getFeatures(), msvcExtensions, gnuExtensions, gnuCompatible, clangExtensions, coroutineMode != RadCoroutineMode.Default, targetArchitecture, provider);
        RadLanguageStandard radLanguageStandard = this.languageStandard(languageStandard);
        List<String> list3 = extractedPreprocessorInfo.getPredefinedMacros();
        RadCompilerKind radCompilerKind = this.compilerKind(compilerKind);
        return new RadToolsetSettings(languageKind, radCompilerKind, includePaths, frameworkPaths, targetArchitecture, coroutineMode, implicitIncludes, radLanguageStandard, list3, languageDialect);
    }

    private final RadCompilerKind compilerKind(OCCompilerKind compilerKind) {
        OCCompilerKind oCCompilerKind = compilerKind;
        return Intrinsics.areEqual((Object)oCCompilerKind, (Object)GCCCompilerKind.INSTANCE) ? RadCompilerKind.GCC : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangCompilerKind.INSTANCE) ? RadCompilerKind.Clang : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangClCompilerKind.INSTANCE) ? RadCompilerKind.ClangCl : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)MSVCCompilerKind.INSTANCE) ? RadCompilerKind.MSVC : RadCompilerKind.Unknown)));
    }

    @NotNull
    public final DependenciesPaths extractDependenciesPaths(@NotNull List<HeadersSearchPath> inputHeadersSearchPaths) {
        Intrinsics.checkNotNullParameter(inputHeadersSearchPaths, (String)"inputHeadersSearchPaths");
        ArrayList includePaths = new ArrayList(inputHeadersSearchPaths.size());
        ArrayList<String> frameworkPaths = new ArrayList<String>(inputHeadersSearchPaths.size());
        ArrayList<String> builtinIncludePaths = new ArrayList<String>(inputHeadersSearchPaths.size());
        for (HeadersSearchPath searchPath : inputHeadersSearchPaths) {
            if (searchPath.isRecursive()) {
                logger.warn("Skipping a framework or recursive include path " + searchPath.getPath());
                continue;
            }
            if (searchPath.isFrameworksSearchPath()) {
                frameworkPaths.add(FileUtil.toSystemDependentName((String)searchPath.getPath()));
                continue;
            }
            ArrayList<String> targetList = searchPath.isBuiltInHeaders() ? builtinIncludePaths : includePaths;
            targetList.add(FileUtil.toSystemDependentName((String)searchPath.getPath()));
        }
        includePaths.addAll(builtinIncludePaths);
        return new DependenciesPaths(includePaths, (List<String>)frameworkPaths);
    }

    private final RadCoroutineMode extractCoroutineMode(List<String> compilerFlags) {
        return compilerFlags.contains("-fcoroutines-ts") || compilerFlags.contains("-fcoroutines") || compilerFlags.contains("/await") ? RadCoroutineMode.Experimental : (compilerFlags.contains("/await:strict") ? RadCoroutineMode.Strict : RadCoroutineMode.Default);
    }

    private final boolean hasClangExtensions(OCCompilerKind compilerKind) {
        return compilerKind instanceof ClangClCompilerKind || compilerKind instanceof ClangCompilerKind || compilerKind instanceof AppleClangCompilerKind;
    }

    private final boolean hasMSVCExtensions(OCCompilerKind compilerKind, PreprocessorFeatures preprocessorFeatures, List<String> flags) {
        if (compilerKind instanceof MSVCCompilerKind || compilerKind instanceof ClangClCompilerKind) {
            return true;
        }
        if (!(compilerKind instanceof ClangCompilerKind)) {
            return false;
        }
        if (flags.contains("-fms-extensions")) {
            return true;
        }
        return preprocessorFeatures.getHasWinMacro() && !preprocessorFeatures.getHasMingwMacro();
    }

    private final RadLanguageDialect extractLanguageDialect(Map<OCCompilerFeatures.Type<?>, ?> compilerFeatures, PreprocessorFeatures preprocessorFeatures, boolean msExtensions, boolean gnuExtensions, boolean gnuCompatible, boolean clangExtensions, boolean nonDefaultCoroutines, RadTargetArchitecture targetArchitecture, RadCompilerFeaturesProvider provider) {
        RadSizeTUnderlyingType underlyingSizeType = this.getUnderlyingSizeType(preprocessorFeatures, targetArchitecture, msExtensions);
        RadGnuNullUnderlyingType underlyingNullType = switch (WhenMappings.$EnumSwitchMapping$0[targetArchitecture.ordinal()]) {
            case 1 -> RadGnuNullUnderlyingType.INT;
            case 2 -> RadGnuNullUnderlyingType.LONG;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean hasCoroutines = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_COROUTINES) || nonDefaultCoroutines;
        long supportedTypeTraits = this.packSupportedTypeTraits(compilerFeatures, provider);
        boolean bl = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.HAS_BUILTIN);
        boolean bl2 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.HAS_FEATURE);
        boolean bl3 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.HAS_EXTENSION);
        boolean bl4 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        boolean bl5 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.MS_TRADITIONAL_PREPROCESSOR);
        boolean bl6 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE);
        boolean bl7 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.C_NULLPTR);
        boolean bl8 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.C_AUTO_TYPE);
        boolean bl9 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.C_CONSTEXPR);
        boolean bl10 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.BUILTIN_SOURCE_LOCATION);
        boolean bl11 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.BUILTIN_BIT_CAST);
        short s = RadProjectModelHost.extractLanguageDialect$typeSize(compilerFeatures, provider, OCCompilerFeatures.TypeSize.LONG);
        short s2 = RadProjectModelHost.extractLanguageDialect$typeSize(compilerFeatures, provider, OCCompilerFeatures.TypeSize.WCHAR_T);
        boolean bl12 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_TYPE_INFO_IN_GLOBAL_NAMESPACE);
        boolean bl13 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_MS_ALLOW_BINDING_RVALUE_TO_LVALUE_REFERENCE);
        boolean bl14 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED);
        boolean bl15 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS);
        boolean bl16 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BUILTIN_WCHAR);
        boolean bl17 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_EXCEPTIONS);
        boolean bl18 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR16);
        boolean bl19 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR32);
        boolean bl20 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_AUTO_TYPE);
        boolean bl21 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_NOEXCEPT);
        boolean bl22 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_EXPLICIT_CONVERSION_OPERATORS);
        boolean bl23 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_DELEGATING_CONSTRUCTORS);
        boolean bl24 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_DEFAULTED_AND_DELETED_FUNCTIONS);
        boolean bl25 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL);
        boolean bl26 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS);
        boolean bl27 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_NULLPTR);
        boolean bl28 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT);
        boolean bl29 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_LAMBDAS);
        boolean bl30 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS);
        boolean bl31 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_USER_LITERALS);
        boolean bl32 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_ATTRIBUTES);
        boolean bl33 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CONSTEXPR);
        boolean bl34 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_HAS_IMPLICIT_CONST_ON_CONSTEXPR_MEMBER);
        boolean bl35 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BINARY_LITERALS);
        boolean bl36 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION);
        boolean bl37 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS);
        boolean bl38 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_STRING_BUILTINS);
        boolean bl39 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_STRUCTURED_BINDINGS);
        boolean bl40 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CTAD);
        boolean bl41 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_GUARANTEED_COPY_ELISION);
        boolean bl42 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_AGGREGATES_WITH_BASE_CLASSES);
        boolean bl43 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_INLINE_VARIABLES);
        boolean bl44 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CONSTEXPR_IF);
        boolean bl45 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_IF_INITIALIZERS);
        boolean bl46 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_NESTED_NAMESPACES);
        boolean bl47 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_HAS_AUTO_WITH_LIST_INIT_FIX);
        boolean bl48 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BUILTIN_IS_CONSTANT_EVALUATED);
        boolean bl49 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_OBJECT_TEMPLATE_PARAMETERS);
        boolean bl50 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CONSTEVAL);
        boolean bl51 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CONSTINIT);
        boolean bl52 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_USING_ENUM);
        boolean bl53 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_DEFAULT_CONSTRUCTIBLE_AND_ASSIGNABLE_STATELESS_LAMBDAS);
        boolean bl54 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_THREE_WAY_COMPARISON);
        boolean bl55 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CTAD_FOR_AGGREGATES_AND_TYPE_ALIASES);
        boolean bl56 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_PROHIBIT_AGGREGATES_WITH_USER_DECLARED_CONSTRUCTORS);
        boolean bl57 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_AGGREGATE_PAREN_INIT);
        boolean bl58 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_RANGE_FOR_INITIALIZERS);
        boolean bl59 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR8);
        boolean bl60 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CONCEPTS);
        boolean bl61 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CPP_20_STRUCTURED_BINDINGS);
        boolean bl62 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_CPP_20_TEMPLATE_FUNCTIONS_DISAMBIGUATION);
        boolean bl63 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.CXX_EXPLICIT_THIS_PARAMETER);
        boolean bl64 = RadProjectModelHost.extractLanguageDialect$flag(compilerFeatures, provider, OCCompilerFeatures.Feature.EXPERIMENTAL_LIBRARY);
        return new RadLanguageDialect(bl, bl2, bl3, msExtensions, gnuExtensions, gnuCompatible, bl4, clangExtensions, bl5, bl6, bl7, bl8, bl9, bl11, bl10, underlyingSizeType, s, s2, underlyingNullType, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, bl20, bl21, bl22, bl23, bl24, bl25, bl26, bl27, bl28, bl29, bl30, bl31, bl32, bl33, bl34, bl35, bl36, bl37, bl38, bl39, bl40, bl41, bl42, bl43, bl44, bl45, bl46, bl47, bl48, bl49, bl50, bl51, bl52, bl53, bl54, bl55, bl56, bl57, bl58, bl59, hasCoroutines, bl60, bl61, bl62, bl63, supportedTypeTraits, bl64);
    }

    /*
     * WARNING - void declaration
     */
    private final long packSupportedTypeTraits(Map<OCCompilerFeatures.Type<?>, ?> features, RadCompilerFeaturesProvider provider) {
        void $this$foldIndexed$iv;
        logger.assertTrue(EntriesMappings.entries$0.size() <= 64, RadProjectModelHost::packSupportedTypeTraits$lambda$23);
        Iterable iterable = (Iterable)EntriesMappings.entries$0;
        long initial$iv = 0L;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void acc;
            void typeTrait;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OCCompilerFeatures.TypeTrait typeTrait2 = (OCCompilerFeatures.TypeTrait)element$iv;
            long l = accumulator$iv;
            int idx = n;
            boolean bl = false;
            boolean supportsTrait = Intrinsics.areEqual((Object)features.getOrDefault(typeTrait, typeTrait.compute((OCCompilerFeaturesProvider)provider)), (Object)true);
            long bit = supportsTrait ? 1L : 0L;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace(typeTrait.name() + " is " + (bit == 1L ? "enabled" : "disabled"));
            }
            accumulator$iv = acc | bit << idx;
        }
        return accumulator$iv;
    }

    private final RadSizeTUnderlyingType getUnderlyingSizeType(PreprocessorFeatures preprocessorFeatures, RadTargetArchitecture targetArchitecture, boolean msExtensions) {
        RadSizeTUnderlyingType radSizeTUnderlyingType = preprocessorFeatures.getSizeTUnderlyingType();
        if (radSizeTUnderlyingType == null) {
            radSizeTUnderlyingType = this.getUnderlyingSizeTypeFromArch(targetArchitecture, msExtensions);
        }
        return radSizeTUnderlyingType;
    }

    private final RadSizeTUnderlyingType getUnderlyingSizeTypeFromArch(RadTargetArchitecture targetArchitecture, boolean msExtensions) {
        return switch (WhenMappings.$EnumSwitchMapping$0[targetArchitecture.ordinal()]) {
            case 1 -> RadSizeTUnderlyingType.UNSIGNED;
            case 2 -> {
                if (msExtensions) {
                    yield RadSizeTUnderlyingType.UNSIGNED_LONGLONG;
                }
                yield RadSizeTUnderlyingType.UNSIGNED_LONG;
            }
            default -> RadSizeTUnderlyingType.UNSIGNED_LONGLONG;
        };
    }

    private final RadLanguageStandard languageStandard(OCLanguageStandard standard) {
        return switch (WhenMappings.$EnumSwitchMapping$1[standard.ordinal()]) {
            case 1 -> RadLanguageStandard.Cpp98;
            case 2 -> RadLanguageStandard.Cpp11;
            case 3 -> RadLanguageStandard.Cpp14;
            case 4 -> RadLanguageStandard.Cpp17;
            case 5 -> RadLanguageStandard.Cpp20;
            case 6 -> RadLanguageStandard.Cpp23;
            case 7 -> RadLanguageStandard.C89;
            case 8 -> RadLanguageStandard.C99;
            case 9 -> RadLanguageStandard.C11;
            case 10 -> RadLanguageStandard.C17;
            case 11 -> RadLanguageStandard.C23;
            default -> null;
        };
    }

    private static final Pair withSyncedProject$getVersionOrWait$lambda$0(RadProjectModelHost this$0) {
        return TuplesKt.to((Object)this$0.backendVersion.get(), (Object)this$0.frontendVersion.get());
    }

    /*
     * Unable to fully structure code
     */
    private static final Object withSyncedProject$getVersionOrWait(RadProjectModelHost var0, Continuation<? super Long> $completion) {
        if (!($completion instanceof withSyncedProject.getVersionOrWait.1)) ** GOTO lbl-1000
        var12_2 = $completion;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RadProjectModelHost.access$withSyncedProject$getVersionOrWait(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, withSyncedProject$getVersionOrWait$lambda$0(com.jetbrains.cidr.radler.projectmodel.RadProjectModelHost ), ()Lkotlin/Pair;)((RadProjectModelHost)this$0), (Continuation)$continuation);
                if (v0 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if ((backendVersion = ((Number)(var2_5 = (Pair)v0).component1()).longValue()) == (frontendVersion = ((Number)var2_5.component2()).longValue())) {
                    $this$trace$iv = RadProjectModelHost.logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var10_12 = $this$trace$iv;
                        $i$a$-trace-RadProjectModelHost$withSyncedProject$getVersionOrWait$3 = false;
                        var10_12.trace("Versions are in sync: " + backendVersion);
                    }
                    return Boxing.boxLong((long)backendVersion);
                }
                $this$trace$iv = RadProjectModelHost.logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var10_13 = $this$trace$iv;
                    $i$a$-trace-RadProjectModelHost$withSyncedProject$getVersionOrWait$4 = false;
                    var10_13.trace("Versions are not in sync: backend (" + backendVersion + ") != frontend (" + frontendVersion + ")");
                }
                $continuation.label = 2;
                v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                if (v1 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit onBackendReload$lambda$5(RadProjectModelHost this$0, long $version) {
        this$0.backendVersion.set($version);
        logger.info("Backend project reloaded (version: " + $version + ")");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleProjectSync$lambda$9$lambda$8(RadProjectModelHost this$0, boolean $isInitialLoad) {
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            IScheduler iScheduler = ApplicationProtocolKt.getProtocol((Project)this$0.project).getScheduler();
            Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
            ((IRdDispatcher)iScheduler).allowBackgroundThreadAndSuppressPumping(lifetime);
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            this$0.sendProjectsToBackend();
            long projectSyncTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            logger.info("C++ project model synced in " + Duration.toString-impl((long)projectSyncTime) + ($isInitialLoad ? " (initial load)" : ""));
            if ($isInitialLoad && !BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this$0.cppProject.getLoaded()))) {
                this$0.cppProject.getLoaded().set((Object)true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    private static final void scheduleProjectSync$lambda$9(RadProjectModelHost this$0, boolean $isInitialLoad) {
        ApplicationKt.getApplication().runReadAction(() -> RadProjectModelHost.scheduleProjectSync$lambda$9$lambda$8(this$0, $isInitialLoad));
    }

    private static final RadToolsetSettings getToolsetSettingsForLanguageKind$lambda$11(RadProjectModelHost this$0, OCLanguageKind $languageKind, OCCompilerSettings $compilerSettings, CompilerSettingsKey compilerSettingsKey) {
        return this$0.convertSettings($languageKind, $compilerSettings);
    }

    private static final RadToolsetSettings getToolsetSettingsForLanguageKind$lambda$12(Function1 $tmp0, Object p0) {
        return (RadToolsetSettings)$tmp0.invoke(p0);
    }

    private static final Pair sendDiffUpdate$lambda$13(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)((VirtualFile)it.getKey()).getPath(), it.getValue());
    }

    private static final String sendDiffUpdate$lambda$14(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final DependenciesPaths convertSettings$lambda$18(RadProjectModelHost this$0, List it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.extractDependenciesPaths(it);
    }

    private static final DependenciesPaths convertSettings$lambda$19(Function1 $tmp0, Object p0) {
        return (DependenciesPaths)$tmp0.invoke(p0);
    }

    private static final ExtractedPreprocessorInfo convertSettings$lambda$21(List it) {
        Intrinsics.checkNotNull((Object)it);
        return RadDefinesParser.INSTANCE.extractMacroDefinitions(it);
    }

    private static final ExtractedPreprocessorInfo convertSettings$lambda$22(Function1 $tmp0, Object p0) {
        return (ExtractedPreprocessorInfo)$tmp0.invoke(p0);
    }

    private static final boolean extractLanguageDialect$flag(Map<OCCompilerFeatures.Type<?>, ?> $compilerFeatures, RadCompilerFeaturesProvider $provider, OCCompilerFeatures.Feature feature) {
        return Intrinsics.areEqual((Object)$compilerFeatures.getOrDefault(feature, feature.compute((OCCompilerFeaturesProvider)$provider)), (Object)true);
    }

    private static final short extractLanguageDialect$typeSize(Map<OCCompilerFeatures.Type<?>, ?> $compilerFeatures, RadCompilerFeaturesProvider $provider, OCCompilerFeatures.TypeSize feature) {
        short s;
        Short s2 = $compilerFeatures.getOrDefault(feature, feature.compute((OCCompilerFeaturesProvider)$provider));
        Short s3 = s2 instanceof Short ? s2 : null;
        if (s3 != null) {
            s = s3;
        } else {
            Short s4 = feature.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)s4, (String)"getDefault(...)");
            s = ((Number)s4).shortValue();
        }
        return s;
    }

    private static final String packSupportedTypeTraits$lambda$23() {
        return "Found more than 64 type traits";
    }

    public static final /* synthetic */ Object access$withSyncedProject$getVersionOrWait(RadProjectModelHost this$0, Continuation $completion) {
        return RadProjectModelHost.withSyncedProject$getVersionOrWait(this$0, (Continuation<? super Long>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadProjectModelHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadProjectModelHost.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,759:1\n31#2,2:760\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion\n*L\n757#1:760,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadProjectModelHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RadProjectModelHost> serviceClass$iv = RadProjectModelHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RadProjectModelHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$DependenciesPaths;", "", "includePaths", "", "", "frameworkPaths", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getIncludePaths", "()Ljava/util/List;", "getFrameworkPaths", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.clion.radler"})
    public static final class DependenciesPaths {
        @NotNull
        private final List<String> includePaths;
        @NotNull
        private final List<String> frameworkPaths;

        public DependenciesPaths(@NotNull List<String> includePaths, @NotNull List<String> frameworkPaths) {
            Intrinsics.checkNotNullParameter(includePaths, (String)"includePaths");
            Intrinsics.checkNotNullParameter(frameworkPaths, (String)"frameworkPaths");
            this.includePaths = includePaths;
            this.frameworkPaths = frameworkPaths;
        }

        @NotNull
        public final List<String> getIncludePaths() {
            return this.includePaths;
        }

        @NotNull
        public final List<String> getFrameworkPaths() {
            return this.frameworkPaths;
        }

        @NotNull
        public final List<String> component1() {
            return this.includePaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.frameworkPaths;
        }

        @NotNull
        public final DependenciesPaths copy(@NotNull List<String> includePaths, @NotNull List<String> frameworkPaths) {
            Intrinsics.checkNotNullParameter(includePaths, (String)"includePaths");
            Intrinsics.checkNotNullParameter(frameworkPaths, (String)"frameworkPaths");
            return new DependenciesPaths(includePaths, frameworkPaths);
        }

        public static /* synthetic */ DependenciesPaths copy$default(DependenciesPaths dependenciesPaths, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = dependenciesPaths.includePaths;
            }
            if ((n & 2) != 0) {
                list2 = dependenciesPaths.frameworkPaths;
            }
            return dependenciesPaths.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "DependenciesPaths(includePaths=" + this.includePaths + ", frameworkPaths=" + this.frameworkPaths + ")";
        }

        public int hashCode() {
            int result = ((Object)this.includePaths).hashCode();
            result = result * 31 + ((Object)this.frameworkPaths).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DependenciesPaths)) {
                return false;
            }
            DependenciesPaths dependenciesPaths = (DependenciesPaths)other;
            if (!Intrinsics.areEqual(this.includePaths, dependenciesPaths.includePaths)) {
                return false;
            }
            return Intrinsics.areEqual(this.frameworkPaths, dependenciesPaths.frameworkPaths);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<OCCompilerFeatures.TypeTrait> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])OCCompilerFeatures.TypeTrait.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "markProjectAsDirty", "", "reason", "", "selectedResolveConfigurationChanged", "workspaceChanged", "event", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener$OCWorkspaceEvent;", "workspaceInitializationFinished", "success", "", "after", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "rootsChanged", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "hasInterestingEvents", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,759:1\n1755#2,3:760\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener\n*L\n224#1:760,3\n*E\n"})
    public static final class Listener
    implements OCWorkspaceListener,
    BulkFileListener,
    ModuleRootListener {
        @NotNull
        private final Project project;

        public Listener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private final void markProjectAsDirty(String reason) {
            long version = Companion.getInstance(this.project).frontendVersion.incrementAndGet();
            logger.info(reason + " (version: " + version + ", has WA: " + ApplicationKt.getApplication().isWriteAccessAllowed() + ")");
        }

        public void selectedResolveConfigurationChanged() {
            this.markProjectAsDirty("Processing changed resolve configuration");
            ActionsKt.invokeLater$default(null, () -> Listener.selectedResolveConfigurationChanged$lambda$0(this), (int)1, null);
        }

        public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.markProjectAsDirty("Processing changed workspace");
            ActionsKt.invokeLater$default(null, () -> Listener.workspaceChanged$lambda$1(this), (int)1, null);
        }

        public void workspaceInitializationFinished(boolean success) {
            this.markProjectAsDirty("Processing initialized workspace");
            ActionsKt.invokeLater$default(null, () -> Listener.workspaceInitializationFinished$lambda$2(this), (int)1, null);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (this.hasInterestingEvents(events)) {
                this.markProjectAsDirty("Processing VFS change");
                Companion.getInstance(this.project).scheduleProjectSync();
            }
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.markProjectAsDirty("Processing project root change event");
            ActionsKt.invokeLater$default(null, () -> Listener.rootsChanged$lambda$3(this), (int)1, null);
        }

        private final boolean hasInterestingEvents(List<? extends VFileEvent> events) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = events;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VFileEvent it = (VFileEvent)element$iv;
                        boolean bl2 = false;
                        VFileEvent vFileEvent = it;
                        if (vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileDeleteEvent) {
                            VirtualFile virtualFile = it.getFile();
                            if (virtualFile == null) {
                                return true;
                            }
                            VirtualFile file = virtualFile;
                            return file.isDirectory() || OCLanguageUtilsBase.isSupported((VirtualFile)file);
                        }
                        if (vFileEvent instanceof VFilePropertyChangeEvent) {
                            return ((VFilePropertyChangeEvent)it).getFile().isDirectory() && Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)it).getPropertyName(), (Object)"name");
                        }
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) {
                            logger.warn("Unhandled file change event " + it);
                            return false;
                        }
                        if (!false) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final Unit selectedResolveConfigurationChanged$lambda$0(Listener this$0) {
            Companion.getInstance(this$0.project).scheduleInitialProjectSync();
            return Unit.INSTANCE;
        }

        private static final Unit workspaceChanged$lambda$1(Listener this$0) {
            Companion.getInstance(this$0.project).scheduleProjectSync();
            return Unit.INSTANCE;
        }

        private static final Unit workspaceInitializationFinished$lambda$2(Listener this$0) {
            Companion.getInstance(this$0.project).scheduleInitialProjectSync();
            return Unit.INSTANCE;
        }

        private static final Unit rootsChanged$lambda$3(Listener this$0) {
            Companion.getInstance(this$0.project).scheduleProjectSync();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001BB\u0012\u0019\u0010\u0002\u001a\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u000f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$RadCompilerFeaturesProvider;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeaturesProvider;", "compilerFeatures", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "Lorg/jetbrains/annotations/NotNull;", "msExtensions", "", "gnuExtensions", "isGnuCompatible", "languageStandard", "Lcom/jetbrains/cidr/lang/OCLanguageStandard;", "<init>", "(Ljava/util/Map;ZZZLcom/jetbrains/cidr/lang/OCLanguageStandard;)V", "nullValue", "", "Ljava/util/concurrent/ConcurrentHashMap;", "getCompilerFeature", "T", "feature", "(Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;)Ljava/lang/Object;", "areGNUExtensionsEnabled", "isGNUCompatible", "areMSExtensionsEnabled", "getLanguageStandard", "intellij.rider.plugins.clion.radler"})
    public static final class RadCompilerFeaturesProvider
    implements OCCompilerFeaturesProvider {
        private final boolean msExtensions;
        private final boolean gnuExtensions;
        private final boolean isGnuCompatible;
        @NotNull
        private final OCLanguageStandard languageStandard;
        @NotNull
        private final Object nullValue;
        @NotNull
        private final ConcurrentHashMap<OCCompilerFeatures.Type<?>, Object> compilerFeatures;

        public RadCompilerFeaturesProvider(@NotNull Map<OCCompilerFeatures.Type<?>, ?> compilerFeatures, boolean msExtensions, boolean gnuExtensions, boolean isGnuCompatible, @NotNull OCLanguageStandard languageStandard) {
            Intrinsics.checkNotNullParameter(compilerFeatures, (String)"compilerFeatures");
            Intrinsics.checkNotNullParameter((Object)languageStandard, (String)"languageStandard");
            this.msExtensions = msExtensions;
            this.gnuExtensions = gnuExtensions;
            this.isGnuCompatible = isGnuCompatible;
            this.languageStandard = languageStandard;
            this.nullValue = new Object();
            this.compilerFeatures = new ConcurrentHashMap(compilerFeatures);
        }

        @Nullable
        public <T> T getCompilerFeature(@NotNull OCCompilerFeatures.Type<T> feature) {
            Intrinsics.checkNotNullParameter(feature, (String)"feature");
            Object result = this.compilerFeatures.get(feature);
            if (result == null) {
                result = feature.compute((OCCompilerFeaturesProvider)this);
                if (result == null) {
                    result = this.nullValue;
                }
                this.compilerFeatures.putIfAbsent(feature, result);
            }
            return (T)(result == this.nullValue ? null : result);
        }

        public boolean areGNUExtensionsEnabled() {
            return this.gnuExtensions;
        }

        public boolean isGNUCompatible() {
            return this.isGnuCompatible;
        }

        public boolean areMSExtensionsEnabled() {
            return this.msExtensions;
        }

        @NotNull
        public OCLanguageStandard getLanguageStandard() {
            return this.languageStandard;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RadTargetArchitecture.values().length];
            try {
                nArray[RadTargetArchitecture.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RadTargetArchitecture.AMD64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OCLanguageStandard.values().length];
            try {
                nArray[OCLanguageStandard.CPP98.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP11.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP14.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP17.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP20.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP23.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C89.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C99.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C11.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C17.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C23.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

