/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.radler.projectmodel.RadResolveConfigurationProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadLanguageKindCalculatorHelper;", "Lcom/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorHelper;", "<init>", "()V", "getLanguageByPsiFile", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "file", "Lcom/intellij/psi/PsiFile;", "getSpecifiedLanguage", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLanguageByExtension", "name", "", "calculateLanguageKind", "resolveConfig", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "virtualFile", "intellij.rider.plugins.clion.radler"})
public final class RadLanguageKindCalculatorHelper
implements OCLanguageKindCalculatorHelper {
    @NotNull
    public OCLanguageKind getLanguageByPsiFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.calculateLanguageKind(file);
    }

    @Nullable
    public OCLanguageKind getSpecifiedLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public OCLanguageKind getLanguageByExtension(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return OCFileTypeHelpers.getLanguageKind((String)name);
    }

    private final OCLanguageKind calculateLanguageKind(PsiFile file) {
        VirtualFile vf = file.getVirtualFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)vf);
        OCResolveConfiguration resolveConfig = RadResolveConfigurationProvider.Util.INSTANCE.getResolveConfigurationOrFallback(project, vf);
        return this.calculateLanguageKind(resolveConfig, vf);
    }

    private final OCLanguageKind calculateLanguageKind(OCResolveConfiguration resolveConfig, VirtualFile virtualFile) {
        OCResolveConfiguration oCResolveConfiguration = resolveConfig;
        if (oCResolveConfiguration == null || (oCResolveConfiguration = oCResolveConfiguration.getDeclaredLanguageKind(virtualFile)) == null) {
            OCResolveConfiguration oCResolveConfiguration2 = resolveConfig;
            OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.findLanguageKind((Set)(oCResolveConfiguration2 != null ? oCResolveConfiguration2.getEnabledLanguageKinds() : null), (String)virtualFile.getName(), (boolean)false);
            oCResolveConfiguration = oCLanguageKind;
            Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind, (String)"findLanguageKind(...)");
        }
        return oCResolveConfiguration;
    }
}

