/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.radler.RadBundle;
import com.jetbrains.cidr.radler.util.MeasureSummary;
import com.jetbrains.cidr.radler.util.RadMeasurementUtilKt;
import com.jetbrains.rider.cpp.fileType.CppFileType;
import com.jetbrains.rider.cpp.fileType.CppHeaderFileType;
import com.jetbrains.rider.cpp.fileType.CppSourceFileType;
import com.jetbrains.rider.model.RadNamedTimeSpan;
import com.jetbrains.rider.model.RadResolveReferencesStage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)H\u0016\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadMeasureResolveInspection;", "Lcom/intellij/codeInspection/GlobalInspectionTool;", "<init>", "()V", "isEnabled", "", "ROOTS", "", "commandUseRootsScope", "commandCollectReachableFiles", "commandLogResultsPath", "threadNumber", "", "withIncludes", "customScopePath", "progressLogPath", "myCollectingReachableFilesJob", "Lcom/intellij/codeInspection/ex/JobDescriptor;", "myResolvingReferencesJob", "myStage2JobMap", "", "Lcom/jetbrains/rider/model/RadResolveReferencesStage;", "getGroupDisplayName", "getDisplayName", "getStaticDescription", "isReadActionNeeded", "isEnabledByDefault", "isGraphNeeded", "runInspection", "", "scope", "Lcom/intellij/analysis/AnalysisScope;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "globalContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getAdditionalJobs", "", "()[Lcom/intellij/codeInspection/ex/JobDescriptor;", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadMeasureResolveInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadMeasureResolveInspection.kt\ncom/jetbrains/cidr/radler/inspections/RadMeasureResolveInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1863#2,2:202\n*S KotlinDebug\n*F\n+ 1 RadMeasureResolveInspection.kt\ncom/jetbrains/cidr/radler/inspections/RadMeasureResolveInspection\n*L\n123#1:202,2\n*E\n"})
public final class RadMeasureResolveInspection
extends GlobalInspectionTool {
    private final boolean isEnabled = Intrinsics.areEqual((Object)System.getProperty("nova.measurement.enabled", "false"), (Object)"true");
    @NotNull
    private final String ROOTS;
    private final boolean commandUseRootsScope = Intrinsics.areEqual((Object)System.getProperty("nova.measurement.use.roots.scope", "false"), (Object)"true");
    private final boolean commandCollectReachableFiles = Intrinsics.areEqual((Object)System.getProperty("nova.measurement.collect.reachable.files", "false"), (Object)"true");
    @NotNull
    private final String commandLogResultsPath;
    private int threadNumber;
    private boolean withIncludes;
    @NotNull
    private String customScopePath;
    @NotNull
    private String progressLogPath;
    @NotNull
    private final JobDescriptor myCollectingReachableFilesJob;
    @NotNull
    private final JobDescriptor myResolvingReferencesJob;
    @NotNull
    private final Map<RadResolveReferencesStage, JobDescriptor> myStage2JobMap;

    public RadMeasureResolveInspection() {
        this.ROOTS = "ROOTS";
        String string = System.getProperty("nova.measurement.log.results.path", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.commandLogResultsPath = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.threadNumber = 16;
        this.customScopePath = "";
        this.progressLogPath = "";
        this.myCollectingReachableFilesJob = new JobDescriptor("Collecting Reachable Files");
        this.myResolvingReferencesJob = new JobDescriptor("Resolving References");
        Pair[] pairArray = new Pair[]{new Pair((Object)RadResolveReferencesStage.CollectingReachableFiles, (Object)this.myCollectingReachableFilesJob), new Pair((Object)RadResolveReferencesStage.ResolvingReferences, (Object)this.myResolvingReferencesJob)};
        this.myStage2JobMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = RadBundle.message("inspections.group.bestpractice", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = RadBundle.message("inspection.measure.resolve.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getStaticDescription() {
        String string = RadBundle.message("inspection.measure.resolve.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isReadActionNeeded() {
        return false;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!this.isEnabled) {
            CidrLogService.LOG.warn(((Object)((Object)this)).getClass().getSimpleName() + " is disabled by default. Forgot to add -Dnova.measurement.enabled=true to the VM options?");
            return;
        }
        if (this.commandUseRootsScope) {
            this.customScopePath = this.ROOTS;
        }
        if (this.commandCollectReachableFiles) {
            this.withIncludes = true;
        }
        List scopeFiles = null;
        if (StringsKt.isBlank((CharSequence)this.customScopePath)) {
            Object[] objectArray = new CppFileType[]{CppSourceFileType.INSTANCE, CppHeaderFileType.INSTANCE};
            Set acceptableFiles = SetsKt.setOf((Object[])objectArray);
            CommonProcessors.CollectProcessor<VirtualFile> collector2 = new CommonProcessors.CollectProcessor<VirtualFile>((Set<? extends CppFileType>)acceptableFiles){
                final /* synthetic */ Set<CppFileType> $acceptableFiles;
                {
                    this.$acceptableFiles = $acceptableFiles;
                }

                protected boolean accept(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return CollectionsKt.contains((Iterable)this.$acceptableFiles, (Object)file.getFileType());
                }
            };
            scope.accept((Processor)collector2);
            Collection collection = collector2.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
            scopeFiles = CollectionsKt.toList((Iterable)collection);
        } else if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.customScopePath)).toString(), (Object)this.ROOTS)) {
            Set set = ClangLanguageServiceUtils.getProjectRoots((Project)globalContext.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getProjectRoots(...)");
            scopeFiles = CollectionsKt.toList((Iterable)set);
        } else {
            ArrayList targetFiles = new ArrayList();
            FilesKt.forEachLine$default((File)new File(this.customScopePath), null, arg_0 -> RadMeasureResolveInspection.runInspection$lambda$2(targetFiles, arg_0), (int)1, null);
            scopeFiles = targetFiles;
        }
        Iterable $this$forEach$iv = this.myStage2JobMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobDescriptor it = (JobDescriptor)element$iv;
            boolean bl = false;
            it.setTotalAmount(scopeFiles.size());
        }
        MeasureSummary measurements = null;
        OutputStreamWriter progressWriter = !StringsKt.isBlank((CharSequence)this.progressLogPath) ? new OutputStreamWriter(new FileOutputStream(this.progressLogPath)) : null;
        Object object = progressWriter;
        Throwable throwable = null;
        try {
            OutputStreamWriter maybeProgressWriter = (OutputStreamWriter)object;
            boolean bl = false;
            Function2<RadResolveReferencesStage, Integer, Unit> workAmountCallback2 = new Function2<RadResolveReferencesStage, Integer, Unit>(this){
                final /* synthetic */ RadMeasureResolveInspection this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke(RadResolveReferencesStage stage, int workAmount) {
                    Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                    V v = RadMeasureResolveInspection.access$getMyStage2JobMap$p(this.this$0).get(stage);
                    Intrinsics.checkNotNull(v);
                    ((JobDescriptor)v).setTotalAmount(workAmount);
                }
            };
            Function2<RadResolveReferencesStage, String, Unit> progressCallback2 = new Function2<RadResolveReferencesStage, String, Unit>(this, globalContext, maybeProgressWriter){
                final /* synthetic */ RadMeasureResolveInspection this$0;
                final /* synthetic */ GlobalInspectionContext $globalContext;
                final /* synthetic */ OutputStreamWriter $maybeProgressWriter;
                {
                    this.this$0 = $receiver;
                    this.$globalContext = $globalContext;
                    this.$maybeProgressWriter = $maybeProgressWriter;
                }

                public void invoke(RadResolveReferencesStage stage, String path) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        V v = RadMeasureResolveInspection.access$getMyStage2JobMap$p(this.this$0).get(stage);
                        Intrinsics.checkNotNull(v);
                        JobDescriptor jobDescriptor = (JobDescriptor)v;
                        this.$globalContext.incrementJobDoneAmount(jobDescriptor, jobDescriptor.getDoneAmount() + "/" + jobDescriptor.getTotalAmount() + " (" + new File(path).getName() + ")");
                        OutputStreamWriter outputStreamWriter = this.$maybeProgressWriter;
                        if (outputStreamWriter == null) break block0;
                        outputStreamWriter.append(stage + " (" + jobDescriptor.getDoneAmount() + "/" + jobDescriptor.getTotalAmount() + "): " + path + "\n");
                    }
                }
            };
            Iterable iterable = scopeFiles;
            Project project = globalContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            measurements = RadMeasurementUtilKt.measureResolve(iterable, project, this.withIncludes, this.threadNumber, (Function2<? super RadResolveReferencesStage, ? super Integer, Unit>)((Function2)workAmountCallback2), (Function2<? super RadResolveReferencesStage, ? super String, Unit>)((Function2)progressCallback2));
            maybeProgressWriter = Unit.INSTANCE;
        }
        catch (Throwable maybeProgressWriter) {
            throwable = maybeProgressWriter;
            throw maybeProgressWriter;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        CidrLogService.LOG.info(((Object)((Object)this)).getClass().getSimpleName() + ": " + measurements);
        Notifications.Bus.notify((Notification)new Notification(((Object)((Object)this)).getClass().getSimpleName(), "Measurement", measurements.toString(), NotificationType.WARNING), (Project)globalContext.getProject());
        if (!StringsKt.isBlank((CharSequence)this.commandLogResultsPath)) {
            object = new FileWriter(this.commandLogResultsPath);
            throwable = null;
            try {
                FileWriter resultsWriter = (FileWriter)object;
                boolean bl = false;
                resultsWriter.write("TotalTime = " + Duration.toLong-impl((long)measurements.getDuration-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS) + "\n");
                resultsWriter.write("TotalMemory = " + measurements.getPeakMemoryBytes() + "\n");
                resultsWriter.write("ProcessedFiles = " + measurements.getNativeMeasurements().getFilesNumber() + "\n");
                for (RadNamedTimeSpan m : measurements.getNativeMeasurements().getOperations()) {
                    resultsWriter.write(m.getTitle() + " = " + Duration.toLong-impl((long)m.getDuration-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS) + "\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"threadNumber", (String)"Thread number", (int)1, (int)Runtime.getRuntime().availableProcessors()), OptPane.string((String)"customScopePath", (String)"Scope file", (StringValidator)StringValidator.of((String)"customScopeValidator", arg_0 -> RadMeasureResolveInspection.getOptionsPane$lambda$6(this, arg_0))), OptPane.string((String)"progressLogPath", (String)"Progress log", (StringValidator)StringValidator.of((String)"customScopeValidator", RadMeasureResolveInspection::getOptionsPane$lambda$7)), OptPane.checkbox((String)"withIncludes", (String)"Collect headers from include graph", (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public JobDescriptor[] getAdditionalJobs() {
        return (JobDescriptor[])UtilKt.toArray(this.myStage2JobMap.values(), (Object[])new JobDescriptor[0]);
    }

    private static final Unit runInspection$lambda$2(ArrayList $targetFiles, String line) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            char[] cArray = new char[]{';'};
            List targetAndEntry = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (targetAndEntry.size() != 2) break block2;
            Path path = NioPathUtil.toNioPathOrNull((String)((String)CollectionsKt.first((List)targetAndEntry)));
            if (path != null) {
                Path path2;
                Path path3 = path2 = path;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(path3);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it = virtualFile2 = virtualFile;
                    boolean bl2 = false;
                    $targetFiles.add(it);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final String getOptionsPane$lambda$6(RadMeasureResolveInspection this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.isBlank((CharSequence)value) ? null : (Intrinsics.areEqual((Object)value, (Object)this$0.ROOTS) ? null : (new File(value).exists() ? null : "Should be either a path to a target-entry input file or the \"" + this$0.ROOTS + "\" constant"));
    }

    private static final String getOptionsPane$lambda$7(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            Path asPath = Path.of(value, new String[0]);
            Intrinsics.checkNotNull((Object)asPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(asPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(asPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    return asPath + " is a directory";
                }
            }
            Path path = asPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Path path2 = path;
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                return "Directory " + asPath.getParent() + " doesn't exist";
            }
            return null;
        }
        catch (InvalidPathException e) {
            return e.getMessage();
        }
    }

    public static final /* synthetic */ Map access$getMyStage2JobMap$p(RadMeasureResolveInspection $this) {
        return $this.myStage2JobMap;
    }
}

