/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.inspections;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.radler.inspections.RadInspectionUtil;
import com.jetbrains.cidr.radler.inspections.RadInspectionsToolProvider;
import com.jetbrains.cidr.radler.inspections.RadSeveritiesProviderKt;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.SuggestionSeveritiesProvider;
import com.jetbrains.rider.model.IssueSeverity;
import com.jetbrains.rider.model.RunInspectionsModel;
import com.jetbrains.rider.model.RunInspectionsModel_PregeneratedKt;
import com.jetbrains.rider.model.SeverityInfo;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadInspectionsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "syncInspectionSeverities", "Lcom/jetbrains/rd/framework/IRdTask;", "", "inspectionProfile", "Lcom/intellij/codeInspection/InspectionProfile;", "getSeverity", "Lcom/jetbrains/rider/model/IssueSeverity;", "inspectionName", "", "myBackendTypoInspections", "", "Companion", "RadProfileChangeListener", "RadInspectionExtListener", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadInspectionsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadInspectionsHost.kt\ncom/jetbrains/cidr/radler/inspections/RadInspectionsHost\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n13409#2,2:88\n1863#3,2:90\n14#4:92\n*S KotlinDebug\n*F\n+ 1 RadInspectionsHost.kt\ncom/jetbrains/cidr/radler/inspections/RadInspectionsHost\n*L\n34#1:88,2\n41#1:90,2\n28#1:92\n*E\n"})
public final class RadInspectionsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> myBackendTypoInspections;
    @NotNull
    private static final Logger LOG;

    public RadInspectionsHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object[] objectArray = new String[]{"StringLiteralTypo", "CommentTypo", "IdentifierTypo"};
        this.myBackendTypoInspections = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final IRdTask<Unit> syncInspectionSeverities(@Nullable InspectionProfile inspectionProfile) {
        List inspectionSeverities = new ArrayList();
        Object $this$forEach$iv = new RadInspectionsToolProvider().getInspectionClasses();
        boolean $i$f$forEach = false;
        int n = ((Class<? extends LocalInspectionTool>[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            String inspectionName;
            Class<? extends LocalInspectionTool> element$iv;
            Class<? extends LocalInspectionTool> inspectionClass = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (OCInspectionUtil.getInspectionShortName(inspectionClass) == null) continue;
            inspectionSeverities.add(new SeverityInfo(inspectionName, this.getSeverity(inspectionName, this.project, inspectionProfile)));
        }
        $this$forEach$iv = this.myBackendTypoInspections;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String inspectionName = (String)element$iv;
            boolean bl = false;
            inspectionSeverities.add(new SeverityInfo(inspectionName, IssueSeverity.DoNotShow));
        }
        return RunInspectionsModel_PregeneratedKt.getRunInspectionsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getChangeSeverities().start(this.getServiceLifetime(), (Object)inspectionSeverities);
    }

    public static /* synthetic */ IRdTask syncInspectionSeverities$default(RadInspectionsHost radInspectionsHost, InspectionProfile inspectionProfile, int n, Object object) {
        if ((n & 1) != 0) {
            inspectionProfile = null;
        }
        return radInspectionsHost.syncInspectionSeverities(inspectionProfile);
    }

    private final IssueSeverity getSeverity(String inspectionName, Project project, InspectionProfile inspectionProfile) {
        IssueSeverity issueSeverity;
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity((String)inspectionName, (InspectionProfile)inspectionProfile, null, (Project)project, null);
        if (highlightSeverity == null) {
            return IssueSeverity.DoNotShow;
        }
        HighlightSeverity ideaSeverity = highlightSeverity;
        HighlightSeverity highlightSeverity2 = ideaSeverity;
        if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)HighlightSeverity.INFORMATION)) {
            issueSeverity = IssueSeverity.Info;
        } else if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)HighlightSeverity.WARNING) || Intrinsics.areEqual((Object)highlightSeverity2, (Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
            issueSeverity = IssueSeverity.Warning;
        } else if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)HighlightSeverity.WEAK_WARNING)) {
            issueSeverity = IssueSeverity.Suggestion;
        } else if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)HighlightSeverity.ERROR)) {
            issueSeverity = IssueSeverity.Error;
        } else if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)RadSeveritiesProviderKt.getHINT_SEVERITY())) {
            issueSeverity = IssueSeverity.Hint;
        } else if (Intrinsics.areEqual((Object)highlightSeverity2, (Object)SuggestionSeveritiesProvider.Companion.getSUGGESTION_SEVERITY())) {
            issueSeverity = IssueSeverity.Suggestion;
        } else {
            LOG.warn("Unknown IDEA severity: " + ideaSeverity.getName());
            issueSeverity = IssueSeverity.DoNotShow;
        }
        return issueSeverity;
    }

    static /* synthetic */ IssueSeverity getSeverity$default(RadInspectionsHost radInspectionsHost, String string, Project project, InspectionProfile inspectionProfile, int n, Object object) {
        if ((n & 4) != 0) {
            inspectionProfile = null;
        }
        return radInspectionsHost.getSeverity(string, project, inspectionProfile);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadInspectionsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadInspectionsHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "getInstance", "Lcom/jetbrains/cidr/radler/inspections/RadInspectionsHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadInspectionsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadInspectionsHost.kt\ncom/jetbrains/cidr/radler/inspections/RadInspectionsHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n31#2,2:88\n*S KotlinDebug\n*F\n+ 1 RadInspectionsHost.kt\ncom/jetbrains/cidr/radler/inspections/RadInspectionsHost$Companion\n*L\n29#1:88,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        @NotNull
        public final RadInspectionsHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RadInspectionsHost> serviceClass$iv = RadInspectionsHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RadInspectionsHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadInspectionsHost$RadInspectionExtListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RunInspectionsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.clion.radler"})
    public static final class RadInspectionExtListener
    implements SolutionExtListener<RunInspectionsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull RunInspectionsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getDisableInspection().set(null, null, arg_0 -> RadInspectionExtListener.extensionCreated$lambda$0(session, arg_0));
            model.getEditInspectionSettings().set(null, null, arg_0 -> RadInspectionExtListener.extensionCreated$lambda$1(session, arg_0));
            RadInspectionsHost.syncInspectionSeverities$default(Companion.getInstance(session.getProject()), null, 1, null);
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, String inspectionId) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            RadInspectionUtil.Companion.setInspectionEnabled(inspectionId, false, $session.getProject());
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientProjectSession $session, String inspectionId) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            RadInspectionUtil.Companion.editInspectionSettings(inspectionId, $session.getProject());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadInspectionsHost$RadProfileChangeListener;", "Lcom/intellij/profile/ProfileChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "profileChanged", "", "profile", "Lcom/intellij/codeInspection/InspectionProfile;", "intellij.rider.plugins.clion.radler"})
    public static final class RadProfileChangeListener
    implements ProfileChangeAdapter {
        @NotNull
        private final Project project;

        public RadProfileChangeListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void profileChanged(@NotNull InspectionProfile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)this.project);
            if (Intrinsics.areEqual((Object)profileManager.getCurrentProfile(), (Object)profile)) {
                RadInspectionsHost.syncInspectionSeverities$default(Companion.getInstance(this.project), null, 1, null);
            }
        }
    }
}

