/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.inspections;

import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.jetbrains.cidr.radler.inspections.RadTextAttributesKeyProcessor;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import com.jetbrains.rider.daemon.generated.ReSharperAttributesIds;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/radler/inspections/RadHighlighterAttributeCustomizer;", "Lcom/jetbrains/rdclient/highlighting/FrontendHighlighterAttributeCustomizer;", "<init>", "()V", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "externalName", "", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "attributeId", "intellij.rider.plugins.clion.radler"})
public final class RadHighlighterAttributeCustomizer
implements FrontendHighlighterAttributeCustomizer {
    @Nullable
    public TextAttributes getTextAttributes(@NotNull String externalName) {
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        TextAttributesKey textAttributesKey = RadTextAttributesKeyProcessor.Companion.getExternalName2Key().get(externalName);
        if (textAttributesKey == null) {
            return null;
        }
        TextAttributesKey attributeKey = textAttributesKey;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        return scheme.getAttributes(attributeKey);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey(@NotNull EditorColorsScheme scheme, @NotNull String externalName, @NotNull String attributeId) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        Intrinsics.checkNotNullParameter((Object)attributeId, (String)"attributeId");
        if (Intrinsics.areEqual((Object)attributeId, (Object)ReSharperAttributesIds.INSTANCE.getDEAD_CODE())) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        TextAttributesKey textAttributesKey = RadTextAttributesKeyProcessor.Companion.getAttributeId2Key().get(attributeId);
        if (textAttributesKey == null) {
            textAttributesKey = RadTextAttributesKeyProcessor.Companion.getExternalName2Key().get(externalName);
        }
        return textAttributesKey;
    }
}

