/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.cidr.radler.format.RadProjectWizardFormatter;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "log", "", "message", "", "createClangFormatConfigurationIfNeed", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadProjectWizardFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/jetbrains/cidr/radler/format/RadProjectWizardFormatterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n14#2:160\n*S KotlinDebug\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/jetbrains/cidr/radler/format/RadProjectWizardFormatterKt\n*L\n34#1:160\n*E\n"})
public final class RadProjectWizardFormatterKt {
    @NotNull
    private static final Logger logger;

    private static final void log(String message) {
        logger.warn(message);
    }

    private static final void createClangFormatConfigurationIfNeed(Project project) {
        Optional optional = ExternalFormatProcessor.findExternalFormatter((String)"ClangFormat");
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findExternalFormatter(...)");
        ExternalFormatProcessor externalFormatProcessor = (ExternalFormatProcessor)OptionalsKt.getOrNull((Optional)optional);
        if (externalFormatProcessor == null) {
            return;
        }
        ExternalFormatProcessor extFormatProcessor = externalFormatProcessor;
        try {
            Class<?> clazz = extFormatProcessor.getClass().getClassLoader().loadClass("com.jetbrains.clangFormat.settings.ClangFormatSettings");
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<com.intellij.psi.codeStyle.CustomCodeStyleSettings>");
            Class<?> clangFormatSettingsClass = clazz;
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)project).getCustomSettings(clangFormatSettingsClass);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            CustomCodeStyleSettings cfSettings = customCodeStyleSettings;
            Object object = clangFormatSettingsClass.getDeclaredField("ENABLED").get(cfSettings);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            if (((Boolean)object).booleanValue()) {
                extFormatProcessor.createConfiguration(project);
            }
            RadProjectWizardFormatterKt.log(".clang-format is created");
        }
        catch (Throwable ex) {
            RadProjectWizardFormatterKt.log("Error while creating ClangFormat configuration: " + ex);
        }
    }

    public static final /* synthetic */ void access$log(String message) {
        RadProjectWizardFormatterKt.log(message);
    }

    public static final /* synthetic */ void access$createClangFormatConfigurationIfNeed(Project project) {
        RadProjectWizardFormatterKt.createClangFormatConfigurationIfNeed(project);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadProjectWizardFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadProjectWizardFormatterKt.logger = logger;
    }
}

