/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.format;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.cpp.fileType.psi.CppFile;
import com.jetbrains.rider.model.RadDocumentRange;
import com.jetbrains.rider.model.RadFormatterModel_PregeneratedKt;
import com.jetbrains.rider.model.RadStringRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/radler/format/RadExternalFormatter;", "Lcom/intellij/psi/codeStyle/ExternalFormatProcessor;", "<init>", "()V", "activeForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "format", "Lcom/intellij/openapi/util/TextRange;", "source", "range", "canChangeWhiteSpacesOnly", "keepLineBreaks", "enableBulkUpdate", "cursorOffset", "", "indent", "", "lineStartOffset", "doFormat", "", "project", "Lcom/intellij/openapi/project/Project;", "getId", "intellij.rider.plugins.clion.radler"})
public final class RadExternalFormatter
implements ExternalFormatProcessor {
    public boolean activeForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof CppFile;
    }

    @NotNull
    public TextRange format(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate, int cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.doFormat(project, source, range, enableBulkUpdate);
        return range;
    }

    @Nullable
    public String indent(@NotNull PsiFile source, int lineStartOffset) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return null;
    }

    private final void doFormat(Project project, PsiFile source, TextRange range, boolean enableBulkUpdate) {
        if (!(source instanceof CppFile)) {
            return;
        }
        RdLanguage language = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)((Language)CppLanguage.INSTANCE));
        IdeBackend backend = IdeBackend.Companion.getInstance(project);
        VirtualFile virtualFile = ((CppFile)source).getVirtualFile();
        if (virtualFile == null) {
            String string = ((CppFile)source).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RadStringRange request = new RadStringRange(string, null, RangeUtilKt.toRdTextRange((TextRange)range), language);
            String text = (String)IRdCall.DefaultImpls.sync$default((IRdCall)((IRdCall)RadFormatterModel_PregeneratedKt.getRadFormatterModel((Solution)backend.getSolution()).getDoFormatText()), (Object)request, null, (int)2, null);
            Document document = ((CppFile)source).getViewProvider().getDocument();
            if (document != null) {
                document.setText((CharSequence)text);
            }
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document2, (Project)project);
        if (rdDocumentId == null) {
            return;
        }
        RdDocumentId editableEntityId = rdDocumentId;
        RadDocumentRange request = new RadDocumentRange(editableEntityId, RangeUtilKt.toRdTextRange((TextRange)range), language);
        RadFormatterModel_PregeneratedKt.getRadFormatterModel((Solution)backend.getSolution()).getDoFormatDocument().start(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Object)request);
    }

    @NotNull
    public String getId() {
        return "cpp";
    }
}

