/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.daemon.OCFileWideHighlighter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.radler.clangd.RadClangIdeFacadeImpl;
import com.jetbrains.cidr.radler.clangd.RadMockObfuscator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadClangdBridgeImpl
implements ClangdBridgeInterface {
    public boolean isClangdOnlyMode() {
        return false;
    }

    public boolean isClangdKindSupported(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ClangLanguageService.Kind kind) {
        if (kind == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(0);
        }
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case ClangLanguageService.Kind.Clangd, ClangLanguageService.Kind.StatelessIndexer -> true;
            case ClangLanguageService.Kind.Indexer -> false;
        };
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        if (registrar == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(1);
        }
        OurClangTidyInspectionsViaClangdAnnotatorPassFactory ignored = new OurClangTidyInspectionsViaClangdAnnotatorPassFactory(registrar, reparsingPassId);
    }

    @NotNull
    public List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        if (project == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(2);
        }
        List list = CommonClangTidyUtil.getDefaultFileExtensions();
        if (list == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isSupported(@NotNull VirtualFile vf) {
        if (vf == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(4);
        }
        return OCLanguageUtilsBase.isSupported((VirtualFile)vf);
    }

    public boolean isClangdShowErrors(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(5);
        }
        if (vf == null || OCFileWideHighlighter.getSourceFileKind((Project)project, (VirtualFile)vf).isOutOfProject()) {
            ClangdSettings settings = ClangdSettings.getInstance((Project)project);
            return settings != null && settings.isClangdShowErrors();
        }
        return false;
    }

    @NotNull
    public List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        boolean hasFileNotFoundErrors;
        if (file == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(6);
        }
        if (trustworthiness == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(7);
        }
        if (diags == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(8);
        }
        if ((hasFileNotFoundErrors = ContainerUtil.exists(diags, RadClangdBridgeImpl::isFileNotFoundDiagnostic)) && (trustworthiness.hasNoCompilationCommand() || trustworthiness.isCompilationCommandGuessed())) {
            List list = ContainerUtil.filter(diags, diag -> {
                if (diag.getSeverity() == HighlightSeverity.ERROR) {
                    ClangErrorsAnnotatorPass.reportSuppressed((PsiFile)file, (ClangDiagnostic)diag);
                    return false;
                }
                return true;
            });
            if (list == null) {
                RadClangdBridgeImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<ClangDiagnostic> list = diags;
        if (list == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean isSourceFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(11);
        }
        return OCFileTypeHelpers.isSourceFile((String)vf.getName());
    }

    public boolean isHeaderFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(12);
        }
        return OCFileTypeHelpers.isHeaderFile((String)vf.getName());
    }

    public boolean getParameterHints(@NotNull Project project) {
        if (project == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(13);
        }
        return false;
    }

    public void setParameterHints(@NotNull Project project, boolean enabled) {
        if (project == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(14);
        }
    }

    public boolean getParameterInfo() {
        return false;
    }

    public boolean getNavigation() {
        return false;
    }

    public boolean getClangErrorsAndWarnings() {
        return false;
    }

    public boolean getCompletion() {
        return false;
    }

    public boolean getMatchPP() {
        return false;
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection() {
        return ClazyInspection.class;
    }

    @Nullable
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        return null;
    }

    public boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(15);
        }
        if (vf == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(16);
        }
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex index = rootManager.getFileIndex();
        return OCExplicitSourcesSearchScope.isInExplicitProjectSources((ProjectFileIndex)index, (VirtualFile)vf);
    }

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String warningName) {
        if (file == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(17);
        }
        if (range == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(18);
        }
        if (warningName == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(19);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull String descriptor, @NotNull ClangLanguageService.Kind forKind) {
        if (descriptor == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(21);
        }
        if (forKind == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(22);
        }
        return forKind == ClangLanguageService.Kind.Indexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new RadClangIdeFacadeImpl(descriptor);
    }

    @NotNull
    public Obfuscator createObfuscator() {
        return new RadMockObfuscator();
    }

    private static boolean isFileNotFoundDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            RadClangdBridgeImpl.$$$reportNull$$$0(23);
        }
        return diag.getCode() != null && diag.getCode().contentEquals("pp_file_not_found");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/radler/clangd/RadClangdBridgeImpl";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diags";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forKind";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/radler/clangd/RadClangdBridgeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDiagnostics";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClangdKindSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotatorPassFactories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClangdShowErrors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterDiagnostics";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSourceFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setParameterHints";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createClangIdeFacade";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFileNotFoundDiagnostic";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 20 -> new IllegalStateException(string);
        };
    }
}

