/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyResolveInfoProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/radler/clangd/RadClangTidyResolveInfoProvider;", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyResolveInfoProvider;", "<init>", "()V", "getResolveInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "isInProjectSources", "", "intellij.rider.plugins.clion.radler"})
public final class RadClangTidyResolveInfoProvider
extends ClangTidyResolveInfoProvider {
    @Nullable
    public ClangUtils.ResolveInfo getResolveInfo(@NotNull PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)file.getVirtualFile(), (Project)project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = configuration.getDeclaredLanguageKind(file.getVirtualFile());
        if (oCLanguageKind == null) {
            oCLanguageKind = (OCLanguageKind)CLanguageKind.CPP;
        }
        OCLanguageKind languageKind = oCLanguageKind;
        return new ClangUtils.ResolveInfo(configuration, file.getVirtualFile(), languageKind, false);
    }

    public boolean isInProjectSources(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Boolean)ActionsKt.runReadAction(() -> RadClangTidyResolveInfoProvider.isInProjectSources$lambda$0(file));
    }

    private static final boolean isInProjectSources$lambda$0(PsiFile $file) {
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = $file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, virtualFile).isInProject();
    }
}

