/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.documentation.ClangDocumentationUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Hover;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u00070\t\u00a2\u0006\u0002\b\u001c2\u000b\u0010\u001d\u001a\u00070\t\u00a2\u0006\u0002\b\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/radler/clangd/ClangOffsetDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "hover", "Lorg/eclipse/lsp4j/Hover;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "elementName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/eclipse/lsp4j/Hover;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getHover", "()Lorg/eclipse/lsp4j/Hover;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getElementName", "()Ljava/lang/String;", "createPointer", "Lcom/intellij/model/Pointer;", "computeDocumentationHint", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "wrapDocInHtmlIfNecessary", "Lorg/jetbrains/annotations/Nls;", "doc", "intellij.rider.plugins.clion.radler"})
final class ClangOffsetDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final Project project;
    @NotNull
    private final Hover hover;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final String elementName;

    public ClangOffsetDocumentationTarget(@NotNull Project project, @NotNull Hover hover, @NotNull VirtualFile file, @NlsSafe @NotNull String elementName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hover, (String)"hover");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        this.project = project;
        this.hover = hover;
        this.file = file;
        this.elementName = elementName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Hover getHover() {
        return this.hover;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final String getElementName() {
        return this.elementName;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public String computeDocumentationHint() {
        String string = ClangDocumentationUtilsKt.format((Hover)this.hover, (Project)this.project);
        Intrinsics.checkNotNull((Object)string);
        return this.wrapDocInHtmlIfNecessary(string);
    }

    @NotNull
    public DocumentationResult computeDocumentation() {
        String string = ClangDocumentationUtilsKt.format((Hover)this.hover, (Project)this.project);
        if (string == null) {
            string = "";
        }
        return (DocumentationResult)DocumentationResult.Companion.documentation(this.wrapDocInHtmlIfNecessary(string));
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.elementName).backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)this.project, (VirtualFile)this.file)).containerText(null, UtilKt.fileStatusAttributes((Project)this.project, (VirtualFile)this.file)).locationText(this.file.getName()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    private final String wrapDocInHtmlIfNecessary(String doc) {
        if (StringsKt.startsWith$default((String)doc, (String)"<html>", (boolean)false, (int)2, null)) {
            return doc;
        }
        String header = "<head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head>";
        if (StringsKt.startsWith$default((String)doc, (String)"<body>", (boolean)false, (int)2, null)) {
            return "<html>" + header + doc + "</html>";
        }
        return "<html>" + header + "<body>" + doc + "</body></html>";
    }
}

