/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandler;
import com.jetbrains.cidr.radler.protocol.RadCacheState;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.cpp.fileType.CppSourceFileType;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/radler/actions/RadNewFileLangBackendHandler;", "Lcom/jetbrains/cidr/lang/actions/newFile/OCNewFileLangBackendHandler;", "<init>", "()V", "isProjectLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lcom/intellij/psi/PsiFile;", "handleCreatedFile", "", "getFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getLanguage", "Lcom/intellij/lang/Language;", "isCppFileExtension", "extension", "", "determineExtensions", "Lcom/intellij/openapi/util/Couple;", "sampleFile", "preferredSourceExt", "preferredHeaderExt", "getHeaderGuardStylePattern", "filePath", "intellij.rider.plugins.clion.radler"})
public final class RadNewFileLangBackendHandler
implements OCNewFileLangBackendHandler {
    public boolean isProjectLoaded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RadCacheState.Companion.getInstance(project).isInitialUpdateFinished();
    }

    @Nullable
    public VirtualFile getVirtualFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getVirtualFile();
    }

    public void handleCreatedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    @NotNull
    public LanguageFileType getFileType() {
        return (LanguageFileType)CppSourceFileType.INSTANCE;
    }

    @NotNull
    public Language getLanguage() {
        return (Language)CppLanguage.INSTANCE;
    }

    public boolean isCppFileExtension(@NotNull String extension, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return OCFileTypeHelpers.isCppFile((String)extension);
    }

    @NotNull
    public Couple<String> determineExtensions(@NotNull PsiFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
        return couple;
    }

    @NotNull
    public String getHeaderGuardStylePattern(@NotNull String filePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String fileName = new File(filePath).getName();
        String string = StringUtil.toUpperCase((String)StringUtil.join((Collection)StringUtil.getWordsIn((String)fileName), (String)"_"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }
}

