/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageComposer;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageToolsProvider;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageComposer;", "<init>", "()V", "beforeProcessExecution", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "afterProcessTerminated", "event", "Lcom/intellij/execution/process/ProcessEvent;", "exportCoverageDataToJson", "llvmCov", "outputFile", "Ljava/nio/file/Path;", "createLLVMCovProcessAdapter", "Lcom/intellij/execution/process/CapturingProcessAdapter;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "createProfdataCommand", "profileRawFile", "", "profileFile", "toolsProvider", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageToolsProvider;", "createCovCommand", "isBranchCoverageSupportedByExportTool", "", "getCoverageDataFile", "getAuxiliaryFile", "extension", "Companion", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nLLVMCoverageComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLVMCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1863#2,2:187\n*S KotlinDebug\n*F\n+ 1 LLVMCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer\n*L\n84#1:187,2\n*E\n"})
public final class LLVMCoverageComposer
extends CidrCoverageComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<String> ARCH_KEY = new Key("LLVM_COVERAGE_ARCH");
    @JvmField
    @NotNull
    public static final Key<Collection<String>> EXECUTABLES_KEY = new Key("LLVM_COVERAGE_PROGRAM_EXECUTABLES");
    @JvmField
    @NotNull
    public static final Key<String> RAW_PROFILE_KEY = new Key("LLVM_COVERAGE_RAW_PROFILE");

    public LLVMCoverageComposer() {
        super("llvm-cov");
    }

    @Override
    public void beforeProcessExecution(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        String profileRawFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = (String)context.getUserData(RAW_PROFILE_KEY);
        if (string == null) {
            string = this.getAuxiliaryFile(configuration, "profraw", environment);
        }
        if ((profileRawFile = string) != null) {
            context.putUserData(RAW_PROFILE_KEY, (Object)profileRawFile);
            Files.deleteIfExists(environment.getHostMachine().getPath(profileRawFile, new String[0]));
            Map map = cmdLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
            Map map2 = map;
            String string2 = "LLVM_PROFILE_FILE";
            String string3 = environment.toEnvPath(profileRawFile.toString());
            map2.put(string2, string3);
            Map map3 = cmdLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getEnvironment(...)");
            map2 = map3;
            string2 = "__XPC_LLVM_PROFILE_FILE";
            string3 = environment.toEnvPath(profileRawFile.toString());
            map2.put(string2, string3);
        }
        if (context.getUserData(EXECUTABLES_KEY) == null) {
            context.putUserData(EXECUTABLES_KEY, (Object)CollectionsKt.listOf((Object)cmdLine.getExePath()));
        }
    }

    @Override
    public void afterProcessTerminated(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull ProcessEvent event, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Path coverageFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LLVMCoverageToolsProvider lLVMCoverageToolsProvider = LLVMCoverageToolsProvider.Companion.getInstance(configuration);
        if (lLVMCoverageToolsProvider == null) {
            throw new ExecutionException(CidrCoverageBundle.message("llvm.tools.missing", new Object[0]));
        }
        LLVMCoverageToolsProvider toolsProvider = lLVMCoverageToolsProvider;
        Collection executables = (Collection)EXECUTABLES_KEY.get(context);
        String profileRawFile = (String)RAW_PROFILE_KEY.get(context);
        if (profileRawFile == null || !Files.exists(environment.getHostMachine().getPath(profileRawFile, new String[0]), new LinkOption[0])) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("LLVM profile raw file is not found");
            return;
        }
        String profileFile = this.getAuxiliaryFile(configuration, "profdata", environment);
        if (profileFile == null) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("Cannot get path llvm profdata file path");
            return;
        }
        Files.deleteIfExists(environment.getHostMachine().getPath(profileFile, new String[0]));
        GeneralCommandLine llvmProfdata = this.createProfdataCommand(profileRawFile, profileFile, toolsProvider, configuration, environment);
        ProcessOutput output = environment.getHostMachine().runProcess(llvmProfdata, indicator, -1);
        boolean bl = false;
        if (output.getExitCode() != 0) {
            Object[] objectArray = new Object[]{output.getStderr()};
            throw new ExecutionException(CidrCoverageBundle.message("llvm.profdata.merge.failed", objectArray));
        }
        Files.deleteIfExists(environment.getHostMachine().getPath(profileRawFile, new String[0]));
        indicator.checkCanceled();
        GeneralCommandLine llvmCov = this.createCovCommand(profileFile, toolsProvider, configuration, environment, indicator);
        String arch = (String)context.getUserData(ARCH_KEY);
        Intrinsics.checkNotNull((Object)executables);
        Iterable $this$forEach$iv = executables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path exePath;
            String it = (String)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)environment.getHostMachine().getPath(it, new String[0]), (String)"getPath(...)");
            if (!Files.isExecutable(exePath) || Files.isDirectory(exePath, new LinkOption[0]) || StringsKt.endsWith$default((String)((Object)exePath).toString(), (String)".a", (boolean)false, (int)2, null)) continue;
            String[] stringArray = new String[]{"-object", environment.toEnvPath(it)};
            llvmCov.addParameters(stringArray);
            if (arch == null) continue;
            stringArray = new String[]{"-arch", arch};
            llvmCov.addParameters(stringArray);
        }
        String string = this.getCoverageDataFile(configuration);
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            v2 = environment.getHostMachine().getPath(it, new String[0]);
        } else {
            v2 = coverageFile = null;
        }
        if (coverageFile == null) {
            CidrCoverageLogKt.getCidrCoverageLog().error("Cannot get coverage output file path");
            return;
        }
        Files.deleteIfExists(coverageFile);
        indicator.checkCanceled();
        this.exportCoverageDataToJson(llvmCov, coverageFile, environment, indicator);
        Files.deleteIfExists(environment.getHostMachine().getPath(profileFile, new String[0]));
    }

    private final void exportCoverageDataToJson(GeneralCommandLine llvmCov, Path outputFile, CidrToolEnvironment environment, ProgressIndicator indicator) {
        BaseProcessHandler baseProcessHandler = environment.getHostMachine().createProcess(llvmCov, false, false, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)baseProcessHandler, (String)"createProcess(...)");
        BaseProcessHandler process = baseProcessHandler;
        Function1 processAdapterProducer = arg_0 -> LLVMCoverageComposer.exportCoverageDataToJson$lambda$3(this, outputFile, arg_0);
        CapturingProcessRunner processRunner = new CapturingProcessRunner(process, arg_0 -> LLVMCoverageComposer.exportCoverageDataToJson$lambda$4(processAdapterProducer, arg_0));
        ProcessOutput processOutput = processRunner.runProcess(indicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2.getExitCode() != 0) {
            Object[] objectArray = new Object[]{processOutput2.getStderr()};
            throw new ExecutionException(CidrCoverageBundle.message("llvm.cov.export.failed", objectArray));
        }
    }

    private final CapturingProcessAdapter createLLVMCovProcessAdapter(ProcessOutput processOutput, Path outputFile) {
        return new CapturingProcessAdapter(processOutput, outputFile){
            final /* synthetic */ Path $outputFile;
            {
                this.$outputFile = $outputFile;
                super($processOutput);
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                    OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE};
                    Files.writeString(this.$outputFile, (CharSequence)event.getText(), openOptionArray);
                    return;
                }
                super.onTextAvailable(event, outputType);
            }
        };
    }

    private final GeneralCommandLine createProfdataCommand(String profileRawFile, String profileFile, LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment) {
        GeneralCommandLine generalCommandLine = toolsProvider.createProfdataCommand(configuration, environment);
        if (generalCommandLine == null) {
            Object[] objectArray = new Object[]{"llvm-profdata"};
            throw new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", objectArray));
        }
        GeneralCommandLine command = generalCommandLine;
        CidrCoverageLogKt.getCidrCoverageLog().debug("llvm-profdata tool to use: " + command.getExePath());
        String[] stringArray = new String[]{"merge", environment.toEnvPath(profileRawFile), "-o", environment.toEnvPath(profileFile)};
        GeneralCommandLine generalCommandLine2 = command.withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
        return generalCommandLine2;
    }

    private final GeneralCommandLine createCovCommand(String profileFile, LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment, ProgressIndicator indicator) {
        GeneralCommandLine generalCommandLine = toolsProvider.createCovCommand(configuration, environment);
        if (generalCommandLine == null) {
            Object[] objectArray = new Object[]{"llvm-cov"};
            throw new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", objectArray));
        }
        GeneralCommandLine command = generalCommandLine;
        CidrCoverageLogKt.getCidrCoverageLog().debug("llvm-cov tool to use: " + command.getExePath());
        String[] stringArray = new String[]{"export", "-instr-profile", environment.toEnvPath(profileFile)};
        command.withParameters(stringArray);
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            if (this.isBranchCoverageSupportedByExportTool(toolsProvider, configuration, environment, indicator)) {
                String[] stringArray2 = new String[]{"--show-branch-summary"};
                stringArray = command.withParameters(stringArray2);
                Intrinsics.checkNotNull((Object)stringArray);
            } else {
                CidrCoverageLogKt.getCidrCoverageLog().warn("Branch coverage is disabled programmatically: `llvm-cov export` doesn't provide --show-branch-summary option");
            }
        }
        return command;
    }

    private final boolean isBranchCoverageSupportedByExportTool(LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment, ProgressIndicator indicator) {
        GeneralCommandLine generalCommandLine = toolsProvider.createCovCommand(configuration, environment);
        if (generalCommandLine == null) {
            return false;
        }
        GeneralCommandLine commandLine = generalCommandLine;
        String[] stringArray = new String[]{"export", "--help"};
        commandLine.withParameters(stringArray);
        ProcessOutput it = environment.getHostMachine().runProcess(commandLine, indicator, -1);
        boolean bl = false;
        String string = it.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"--show-branch-summary", (boolean)false, (int)2, null);
    }

    private final String getCoverageDataFile(RunConfiguration configuration) {
        CidrCoverageDataFileProvider cidrCoverageDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, this.getCoverageRunnerId());
        return cidrCoverageDataFileProvider != null ? cidrCoverageDataFileProvider.getLocalCoverageDataPath(configuration) : null;
    }

    private final String getAuxiliaryFile(RunConfiguration configuration, String extension, CidrToolEnvironment environment) {
        String string = this.getCoverageDataFile(configuration);
        if (string != null) {
            String file = string;
            boolean bl = false;
            String parentDirectory = new File(file).getParent();
            String[] stringArray = new String[]{parentDirectory, configuration.getName() + "." + extension};
            return FileUtil.join((String[])stringArray);
        }
        return null;
    }

    private static final CapturingProcessAdapter exportCoverageDataToJson$lambda$3(LLVMCoverageComposer this$0, Path $outputFile, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        return this$0.createLLVMCovProcessAdapter(processOutput, $outputFile);
    }

    private static final ProcessAdapter exportCoverageDataToJson$lambda$4(Function1 $tmp0, Object p0) {
        return (ProcessAdapter)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer$Companion;", "", "<init>", "()V", "ARCH_KEY", "Lcom/intellij/openapi/util/Key;", "", "EXECUTABLES_KEY", "", "RAW_PROFILE_KEY", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

