/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEnabledConfiguration;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageModel;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageParser;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J7\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "getPresentableName", "", "getDataFileExtension", "getId", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "parseModel", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/intellij/openapi/project/Project;)[Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "createLineData", "Lcom/intellij/rt/coverage/data/LineData;", "line", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "fileData", "Lcom/intellij/rt/coverage/data/ClassData;", "branchCoverageData", "Lcom/jetbrains/cidr/execution/coverage/CidrBranchCoverageFileData;", "Companion", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nGCovCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCovCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1#2:100\n12574#3,2:101\n13409#3,2:103\n*S KotlinDebug\n*F\n+ 1 GCovCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner\n*L\n54#1:101,2\n59#1:103,2\n*E\n"})
public final class GCovCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "gcov";

    @NotNull
    public String getPresentableName() {
        String string = CidrCoverageBundle.message("gcov.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDataFileExtension() {
        return ID;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CidrCoverageEngine;
    }

    @NotNull
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        File file;
        Object object;
        CidrToolEnvironment environment;
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        CoverageEnabledConfiguration configuration = CidrCoverageEnabledConfiguration.Companion.getCoverageEnabledConfiguration(baseCoverageSuite);
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(baseCoverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = environment = new CidrToolEnvironment();
        }
        if ((object = configuration) != null && (object = object.getCoverageFilePath()) != null) {
            Object it = object;
            boolean bl = false;
            file = new File((String)it);
        } else {
            file = null;
        }
        File workingDirectory = file;
        CoverageSuite coverageSuite = baseCoverageSuite;
        GCovCoverageModel[] models = this.parseModel(sessionDataFile, workingDirectory, environment, (Project)(coverageSuite != null ? coverageSuite.getProject() : null));
        CidrProjectData projectData = new CidrProjectData();
        for (GCovCoverageModel model : models) {
            LineData it;
            LineData element$iv;
            int n;
            if (model.getLines().isEmpty()) continue;
            ClassData fileData = projectData.getOrCreateClassData(model.getFilePath());
            CidrBranchCoverageFileData branchCoverageData = projectData.getOrCreateBranchCoverageData(model.getFilePath());
            LineData[] lines = new LineData[((GCovCoverageModel.GCovLineModel)CollectionsKt.last(model.getLines())).getLineIndex() + 1];
            for (GCovCoverageModel.GCovLineModel line : model.getLines()) {
                if (line.getTotalHits() == -1) continue;
                try {
                    int n2 = line.getLineIndex();
                    Intrinsics.checkNotNull((Object)fileData);
                    lines[n2] = this.createLineData(line, fileData, branchCoverageData);
                }
                catch (Exception e) {
                    CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to create gcov coverage line data", (Throwable)e);
                }
            }
            if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage() && branchCoverageData.getTotalBranches() == 0) {
                boolean bl;
                block11: {
                    LineData[] $this$any$iv = lines;
                    boolean $i$f$any = false;
                    n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        LineData lineData = it;
                        if (!((lineData != null ? Integer.valueOf(lineData.getHits()) : null) != null && it.getHits() > 0)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
                if (bl) {
                    branchCoverageData.setTotalBranches(1);
                    branchCoverageData.setCoveredBranches(1);
                }
            }
            LineData[] $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                LineData lineData = it;
                if (lineData == null) continue;
                lineData.fillArrays();
            }
            fileData.setLines(lines);
        }
        return projectData;
    }

    private final GCovCoverageModel[] parseModel(File sessionDataFile, File workingDirectory, CidrToolEnvironment environment, Project project) {
        GCovCoverageParser parser = new GCovCoverageParser();
        return parser.parse(sessionDataFile, workingDirectory, environment, project);
    }

    private final LineData createLineData(GCovCoverageModel.GCovLineModel line, ClassData fileData, CidrBranchCoverageFileData branchCoverageData) {
        LineData lineData = new LineData(line.getLineIndex(), null);
        lineData.setHits(line.getTotalHits());
        if (!((Collection)line.getBlocks()).isEmpty()) {
            int jumpIndex = 0;
            for (GCovCoverageModel.GCovBlockModel block : line.getBlocks()) {
                List<GCovCoverageModel.GCovBranchModel> branches = block.getBranches();
                for (GCovCoverageModel.GCovBranchModel branch : branches) {
                    JumpData jump = lineData.addJump(jumpIndex++);
                    jump.setTrueHits(branch.getTaken());
                    jump.setFalseHits(RangesKt.coerceAtLeast((int)0, (int)(block.getHits() - branch.getTaken())));
                    branchCoverageData.setTotalBranches(branchCoverageData.getTotalBranches() + 1);
                    if (branch.getTaken() <= 0) continue;
                    branchCoverageData.setCoveredBranches(branchCoverageData.getCoveredBranches() + 1);
                }
            }
        }
        if (fileData.getLines() != null) {
            Object[] objectArray = fileData.getLines();
            Intrinsics.checkNotNull((Object)objectArray);
            LineData oldLineData = (LineData)objectArray[line.getLineIndex()];
            if (oldLineData != null) {
                lineData.merge((CoverageData)oldLineData);
            }
        }
        return lineData;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner$Companion;", "", "<init>", "()V", "ID", "", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

