/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.execution.coverage.CidrCoverageAnnotator;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J \u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J#\u0010\u0014\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\b0\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010\u001c\u001a\u00020\bH\u0003R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrDirectoryCoverageViewExtension;", "Lcom/intellij/coverage/view/DirectoryCoverageViewExtension;", "project", "Lcom/intellij/openapi/project/Project;", "suiteBundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "sourceFileExtensions", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/coverage/CoverageSuitesBundle;Ljava/util/Collection;)V", "workspace", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "getWorkspace", "()Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "createRootNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getChildrenNodes", "", "node", "createColumnInfos", "", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "()[Lcom/intellij/util/ui/ColumnInfo;", "getPercentage", "columnIdx", "", "getLineCoverageString", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nCidrDirectoryCoverageViewExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDirectoryCoverageViewExtension.kt\ncom/jetbrains/cidr/execution/coverage/CidrDirectoryCoverageViewExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n774#2:74\n865#2,2:75\n*S KotlinDebug\n*F\n+ 1 CidrDirectoryCoverageViewExtension.kt\ncom/jetbrains/cidr/execution/coverage/CidrDirectoryCoverageViewExtension\n*L\n31#1:74\n31#1:75,2\n*E\n"})
public class CidrDirectoryCoverageViewExtension
extends DirectoryCoverageViewExtension {
    @NotNull
    private final Collection<String> sourceFileExtensions;

    public CidrDirectoryCoverageViewExtension(@NotNull Project project, @NotNull CoverageSuitesBundle suiteBundle, @NotNull Collection<String> sourceFileExtensions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suiteBundle, (String)"suiteBundle");
        Intrinsics.checkNotNullParameter(sourceFileExtensions, (String)"sourceFileExtensions");
        super(project, (CoverageAnnotator)CidrCoverageAnnotator.Companion.getInstance(project), suiteBundle);
        this.sourceFileExtensions = sourceFileExtensions;
    }

    @Nullable
    protected CidrWorkspace getWorkspace() {
        return null;
    }

    @NotNull
    public AbstractTreeNode<?> createRootNode() {
        CidrWorkspace cidrWorkspace = this.getWorkspace();
        if (cidrWorkspace != null && (cidrWorkspace = cidrWorkspace.getEffectiveContentRoot()) != null) {
            CidrWorkspace rootFile = cidrWorkspace;
            boolean bl = false;
            CidrCoverageLogKt.getCidrCoverageLog().debug("Coverage View Extension RootNode: " + (VirtualFile)rootFile);
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory((VirtualFile)rootFile);
            if (psiDirectory != null) {
                PsiDirectory rootDirectory = psiDirectory;
                boolean bl2 = false;
                return (AbstractTreeNode)new CoverageListRootNode(this.myProject, (PsiNamedElement)rootDirectory, this.mySuitesBundle);
            }
        }
        AbstractTreeNode abstractTreeNode = super.createRootNode();
        Intrinsics.checkNotNullExpressionValue((Object)abstractTreeNode, (String)"createRootNode(...)");
        return abstractTreeNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> getChildrenNodes(@Nullable AbstractTreeNode<?> node) {
        void $this$filterTo$iv$iv;
        List list = super.getChildrenNodes(node);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenNodes(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String ext;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = ext = string != null ? StringsKt.substringAfterLast((String)string, (char)'.', (String)"") : null;
            if (!(ext != null && (((CharSequence)ext).length() == 0 || this.sourceFileExtensions.contains(ext)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ColumnInfo<NodeDescriptor<?>, String>[] createColumnInfos() {
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, this.getLineCoverageString(), this.mySuitesBundle), new PercentageCoverageColumnInfo(2, CidrCoverageBundle.message("branch.coverage.table.column.name", new Object[0]), this.mySuitesBundle)};
            return columnInfoArray;
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, this.getLineCoverageString(), this.mySuitesBundle)};
        return columnInfoArray;
    }

    @Nullable
    public String getPercentage(int columnIdx, @NotNull AbstractTreeNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage() && columnIdx == 2) {
            String string;
            CoverageAnnotator coverageAnnotator = this.myAnnotator;
            Intrinsics.checkNotNull((Object)coverageAnnotator, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.coverage.CidrCoverageAnnotator");
            CidrCoverageAnnotator annotator = (CidrCoverageAnnotator)coverageAnnotator;
            VirtualFile virtualFile = this.extractFile(node);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            if (file.isDirectory()) {
                CoverageDataManager coverageDataManager = this.myCoverageDataManager;
                Intrinsics.checkNotNullExpressionValue((Object)coverageDataManager, (String)"myCoverageDataManager");
                string = annotator.getDirBranchCoverageInformationString(file, coverageDataManager);
            } else {
                CoverageDataManager coverageDataManager = this.myCoverageDataManager;
                Intrinsics.checkNotNullExpressionValue((Object)coverageDataManager, (String)"myCoverageDataManager");
                string = annotator.getFileBranchCoverageInformationString(file, coverageDataManager);
            }
            return string;
        }
        if (columnIdx == 1) {
            return super.getPercentage(columnIdx, node);
        }
        return null;
    }

    @Nls
    private final String getLineCoverageString() {
        if (PluginUtils.hasAppCode()) {
            String string = CoverageBundle.message((String)"table.column.name.statistics", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = CidrCoverageBundle.message("line.coverage.table.column.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

