/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSuite;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageUtil;", "", "<init>", "()V", "Companion", "intellij.cidr.coverage"})
public final class CidrCoverageUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TIMEOUT_IN_MS = 60000;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\"\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J*\u0010\u0012\u001a\u00020\u000b2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\b\u001a\u0004\u0018\u00010\tJ7\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%\"\u00020\u0014\u00a2\u0006\u0002\u0010&J7\u0010'\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%\"\u00020\u0014\u00a2\u0006\u0002\u0010&J?\u0010(\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%\"\u00020\u0014\u00a2\u0006\u0002\u0010*J?\u0010+\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%\"\u00020\u0014\u00a2\u0006\u0002\u0010*JC\u0010,\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140/H\u0002\u00a2\u0006\u0002\u00100J#\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140/2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageUtil$Companion;", "", "<init>", "()V", "TIMEOUT_IN_MS", "", "getEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "coverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "prepareCoverageSuite", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "environment", "project", "Lcom/intellij/openapi/project/Project;", "setEnvironment", "showBalloon", "message", "", "messageType", "Lcom/intellij/openapi/ui/MessageType;", "listener", "Ljavax/swing/event/HyperlinkListener;", "getCoverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getRunConfiguration", "deleteFilesWithExtensionsSequentially", "hostMachine", "Lcom/jetbrains/cidr/system/HostMachine;", "sourceDir", "Ljava/nio/file/Path;", "recursive", "", "extensions", "", "(Lcom/jetbrains/cidr/system/HostMachine;Ljava/nio/file/Path;Z[Ljava/lang/String;)V", "deleteFilesWithExtensionsInBatchMode", "moveFilesWithExtensionsSequentially", "targetDir", "(Lcom/jetbrains/cidr/system/HostMachine;Ljava/nio/file/Path;Ljava/nio/file/Path;Z[Ljava/lang/String;)V", "moveFilesWithExtensionInBatchMode", "executeBatchFindCommand", "workingDir", "extraArguments", "", "(Lcom/jetbrains/cidr/system/HostMachine;Ljava/lang/String;Z[Ljava/lang/String;Ljava/util/List;)Z", "buildSearchPattern", "([Ljava/lang/String;)Ljava/util/List;", "isBatchModeApplicable", "intellij.cidr.coverage"})
    @SourceDebugExtension(value={"SMAP\nCidrCoverageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrCoverageUtil.kt\ncom/jetbrains/cidr/execution/coverage/CidrCoverageUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1863#2,2:159\n1863#2,2:161\n*S KotlinDebug\n*F\n+ 1 CidrCoverageUtil.kt\ncom/jetbrains/cidr/execution/coverage/CidrCoverageUtil$Companion\n*L\n76#1:159,2\n99#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CidrToolEnvironment getEnvironment(@Nullable CoverageSuite coverageSuite) {
            if (coverageSuite instanceof CidrCoverageSuite) {
                return ((CidrCoverageSuite)coverageSuite).getToolEnvironment();
            }
            return null;
        }

        public final void prepareCoverageSuite(@NotNull RunConfigurationBase<?> configuration, @NotNull CidrToolEnvironment environment, @NotNull Project project) {
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CoverageSuite coverageSuite = CoverageEnabledConfiguration.getOrCreate(configuration).getCurrentCoverageSuite();
            BaseCoverageSuite baseCoverageSuite = (BaseCoverageSuite)coverageSuite;
            if (baseCoverageSuite != null) {
                baseCoverageSuite.setProject(project);
            }
            this.setEnvironment(coverageSuite, environment);
        }

        private final void setEnvironment(CoverageSuite coverageSuite, CidrToolEnvironment environment) {
            if (coverageSuite instanceof CidrCoverageSuite) {
                ((CidrCoverageSuite)coverageSuite).setToolEnvironment(environment);
            }
        }

        public final void showBalloon(@NlsContexts.PopupContent @NotNull String message, @NotNull MessageType messageType, @Nullable HyperlinkListener listener, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ActionsKt.runInEdt$default(null, () -> Companion.showBalloon$lambda$0(project, messageType, message, listener), (int)1, null);
        }

        @NotNull
        public final CoverageRunner getCoverageRunner(@NotNull RunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            CoverageRunner coverageRunner = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)((RunConfigurationBase)configuration)).getCoverageRunner();
            Intrinsics.checkNotNull((Object)coverageRunner);
            return coverageRunner;
        }

        @Nullable
        public final RunConfiguration getRunConfiguration(@Nullable CoverageSuite coverageSuite) {
            if (coverageSuite instanceof BaseCoverageSuite) {
                return (RunConfiguration)((BaseCoverageSuite)coverageSuite).getConfiguration();
            }
            return null;
        }

        public final void deleteFilesWithExtensionsSequentially(@NotNull HostMachine hostMachine, @NotNull Path sourceDir, boolean recursive, String ... extensions) throws IOException, ExecutionException {
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            List list = hostMachine.findFilesWithExtension(sourceDir, Boolean.valueOf(recursive), Arrays.copyOf(extensions, extensions.length));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesWithExtension(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Files.delete(it);
            }
        }

        public final void deleteFilesWithExtensionsInBatchMode(@NotNull HostMachine hostMachine, @NotNull Path sourceDir, boolean recursive, String ... extensions) throws IOException, ExecutionException {
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            if (extensions.length == 0) {
                return;
            }
            if (this.isBatchModeApplicable(hostMachine)) {
                if (this.executeBatchFindCommand(hostMachine, ((Object)sourceDir).toString(), recursive, extensions, CollectionsKt.listOf((Object)"-delete"))) {
                    return;
                }
                CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to delete files in batch, fallback to sequential removal");
            }
            this.deleteFilesWithExtensionsSequentially(hostMachine, sourceDir, recursive, Arrays.copyOf(extensions, extensions.length));
        }

        public final void moveFilesWithExtensionsSequentially(@NotNull HostMachine hostMachine, @NotNull Path sourceDir, @NotNull Path targetDir, boolean recursive, String ... extensions) throws IOException, ExecutionException {
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            List list = hostMachine.findFilesWithExtension(sourceDir, Boolean.valueOf(recursive), Arrays.copyOf(extensions, extensions.length));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesWithExtension(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{((Object)it.getFileName()).toString()};
                Path path = hostMachine.getPath(((Object)targetDir).toString(), (String[])objectArray);
                objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(it, path, (CopyOption[])objectArray);
            }
        }

        public final void moveFilesWithExtensionInBatchMode(@NotNull HostMachine hostMachine, @NotNull Path sourceDir, @NotNull Path targetDir, boolean recursive, String ... extensions) throws IOException, ExecutionException {
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            if (extensions.length == 0) {
                return;
            }
            if (this.isBatchModeApplicable(hostMachine)) {
                Object[] objectArray = new String[]{"-exec", "mv", "{}", ((Object)targetDir).toString(), ";"};
                List execArguments = CollectionsKt.listOf((Object[])objectArray);
                if (this.executeBatchFindCommand(hostMachine, ((Object)sourceDir).toString(), recursive, extensions, execArguments)) {
                    return;
                }
                CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to move files in batch, fallback to sequential moving");
            }
            this.moveFilesWithExtensionsSequentially(hostMachine, sourceDir, targetDir, recursive, Arrays.copyOf(extensions, extensions.length));
        }

        private final boolean executeBatchFindCommand(HostMachine hostMachine, String workingDir, boolean recursive, String[] extensions, List<String> extraArguments) {
            String[] stringArray = new String[]{"find"};
            GeneralCommandLine findCommandLine = new GeneralCommandLine(stringArray);
            if (!recursive) {
                stringArray = new String[]{"-maxdepth", "1"};
                findCommandLine.withParameters(stringArray);
            }
            stringArray = new String[]{"-type", "f"};
            findCommandLine.withParameters(stringArray).withParameters(this.buildSearchPattern(extensions)).withParameters(extraArguments).withWorkDirectory(workingDir);
            ProcessOutput processOutput = hostMachine.runProcess(findCommandLine, 60000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
            ProcessOutput output = processOutput;
            return CidrToolsUtil.checkSuccess((GeneralCommandLine)findCommandLine, (ProcessOutput)output, (Logger)CidrCoverageLogKt.getCidrCoverageLog());
        }

        private final List<String> buildSearchPattern(String[] extensions) {
            List pattern = new ArrayList();
            pattern.add("(");
            pattern.add("-name");
            pattern.add("*" + extensions[0]);
            int n = extensions.length;
            for (int i = 1; i < n; ++i) {
                pattern.add("-or");
                pattern.add("-name");
                pattern.add("*" + extensions[i]);
            }
            pattern.add(")");
            return pattern;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isBatchModeApplicable(HostMachine hostMachine) {
            if (hostMachine.getOS() != OS.Linux) return false;
            String string = hostMachine.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith((String)string, (String)"WSL", (boolean)true)) return false;
            return true;
        }

        private static final Unit showBalloon$lambda$0(Project $project, MessageType $messageType, String $message, HyperlinkListener $listener) {
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance($project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow("Coverage");
            if (toolWindow == null) {
                return Unit.INSTANCE;
            }
            toolWindow.setShowStripeButton(true);
            toolWindowManager.notifyByBalloon("Coverage", $messageType, $message, null, $listener);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

