/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.zephyr.binding;

import com.intellij.dts.zephyr.binding.BindingFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\bH\u0007\u001a\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"yaml", "Lorg/yaml/snakeyaml/Yaml;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loadFileData", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadExternalBindings", "", "Lcom/intellij/dts/zephyr/binding/BindingFile;", "root", "loadBundledBindings", "dir", "intellij.dts"})
public final class DtsZephyrBindingLoaderKt {
    @NotNull
    private static final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<?, ?> loadFileData(VirtualFile file) {
        try {
            Map map;
            Yaml yaml = DtsZephyrBindingLoaderKt.yaml;
            synchronized (yaml) {
                boolean bl = false;
                map = (Map)DtsZephyrBindingLoaderKt.yaml.load(VirtualFileUtil.readText((VirtualFile)file));
            }
            return map;
        }
        catch (Exception e) {
            logger.debug("could not load yaml file", (Throwable)e);
            return null;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public static final Map<String, BindingFile> loadExternalBindings(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ThreadingAssertions.assertBackgroundThread();
        Map bindings2 = new LinkedHashMap();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VirtualFileVisitor<Object> visitor2 = new VirtualFileVisitor<Object>((Map<String, BindingFile>)bindings2, optionArray){
            final /* synthetic */ Map<String, BindingFile> $bindings;
            {
                this.$bindings = $bindings;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (file.isDirectory() || !Intrinsics.areEqual((Object)file.getExtension(), (Object)"yaml")) {
                        return true;
                    }
                    Map map = DtsZephyrBindingLoaderKt.access$loadFileData(file);
                    if (map == null) break block1;
                    Map map2 = map;
                    Map<String, BindingFile> map3 = this.$bindings;
                    Map it = map2;
                    boolean bl = false;
                    map3.put(file.getNameWithoutExtension(), new BindingFile(file.getPath(), it));
                }
                return true;
            }
        };
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)((VirtualFileVisitor)visitor2));
        return bindings2;
    }

    @RequiresBackgroundThread
    @NotNull
    public static final Map<String, BindingFile> loadBundledBindings(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadingAssertions.assertBackgroundThread();
        Map bindings2 = new LinkedHashMap();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])dir.getChildren());
        while (iterator.hasNext()) {
            VirtualFile file = (VirtualFile)iterator.next();
            if (file.isDirectory() || !Intrinsics.areEqual((Object)file.getExtension(), (Object)"yaml")) continue;
            Intrinsics.checkNotNull((Object)file);
            Map<?, ?> binding = DtsZephyrBindingLoaderKt.loadFileData(file);
            if (binding != null) {
                bindings2.put(file.getNameWithoutExtension(), new BindingFile(null, binding));
                continue;
            }
            logger.error("could not load bundled binding: " + file);
        }
        return bindings2;
    }

    public static final /* synthetic */ Map access$loadFileData(VirtualFile file) {
        return DtsZephyrBindingLoaderKt.loadFileData(file);
    }

    static {
        Logger logger = Logger.getInstance((String)"DtsZephyrBindingLoader");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DtsZephyrBindingLoaderKt.logger = logger;
    }
}

